/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.connectors.outtopic.DigitalArchitectureOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.digitalarchitecture.connectors.outtopic.DigitalArchitectureOutTopicServerProvider;
import org.odpi.openmetadata.accessservices.digitalarchitecture.ffdc.DigitalArchitectureAuditCode;
import org.odpi.openmetadata.accessservices.digitalarchitecture.outtopic.DigitalArchitectureOMRSTopicListener;
import org.odpi.openmetadata.accessservices.digitalarchitecture.outtopic.DigitalArchitectureOutTopicPublisher;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.DigitalArchitectureServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditingComponent;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DigitalArchitectureAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private DigitalArchitectureServicesInstance instance = null;
    private String serverName = null;
    private DigitalArchitectureOutTopicPublisher eventPublisher = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", DigitalArchitectureAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = this.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DigitalArchitectureServicesInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                Connection outTopicEventBusConnection = accessServiceConfig.getAccessServiceOutTopic();
                Endpoint endpoint = outTopicEventBusConnection.getEndpoint();
                AuditLog outTopicAuditLog = auditLog.createNewAuditLog((ComponentDescription)OMRSAuditingComponent.OMAS_OUT_TOPIC);
                Connection serverSideOutTopicConnection = this.getOutTopicConnection(accessServiceConfig.getAccessServiceOutTopic(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName(), DigitalArchitectureOutTopicServerProvider.class.getName(), auditLog);
                DigitalArchitectureOutTopicServerConnector outTopicServerConnector = (DigitalArchitectureOutTopicServerConnector)super.getTopicConnector(serverSideOutTopicConnection, DigitalArchitectureOutTopicServerConnector.class, outTopicAuditLog, AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName(), "initialize");
                this.eventPublisher = new DigitalArchitectureOutTopicPublisher(outTopicServerConnector, endpoint.getAddress(), outTopicAuditLog, repositoryConnector.getRepositoryHelper(), AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceName(), this.serverName);
                this.registerWithEnterpriseTopic(AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)new DigitalArchitectureOMRSTopicListener(AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName(), serverUserName, this.eventPublisher, this.instance.getReferenceableHandler(), supportedZones, outTopicAuditLog), auditLog);
            }
            auditLog.logMessage("initialize", DigitalArchitectureAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", DigitalArchitectureAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.DIGITAL_ARCHITECTURE_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.eventPublisher != null) {
            this.eventPublisher.disconnect();
        }
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", DigitalArchitectureAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

