/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.converters;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.accessservices.digitalarchitecture.converters.DigitalArchitectureOMASConverter;
import org.odpi.openmetadata.accessservices.digitalarchitecture.metadataelements.LocationElement;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.LocationProperties;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LocationConverter<B>
extends DigitalArchitectureOMASConverter<B> {
    public LocationConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof LocationElement) {
                this.updateSimpleMetadataElement(beanClass, (LocationElement)returnBean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof LocationElement) {
                this.updateSimpleMetadataElement(beanClass, (LocationElement)returnBean, entity, methodName);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    void updateSimpleMetadataElement(Class<B> beanClass, LocationElement bean, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
            LocationProperties locationProperties = new LocationProperties();
            InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
            locationProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
            locationProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
            locationProperties.setIdentifier(this.removeIdentifier(instanceProperties));
            locationProperties.setDisplayName(this.removeDisplayName(instanceProperties));
            locationProperties.setDescription(this.removeDescription(instanceProperties));
            locationProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
            locationProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            bean.setLocationProperties(locationProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }
}

