/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.outtopic;

import org.odpi.openmetadata.accessservices.digitalarchitecture.connectors.outtopic.DigitalArchitectureOutTopicServerConnector;
import org.odpi.openmetadata.accessservices.digitalarchitecture.converters.ElementHeaderConverter;
import org.odpi.openmetadata.accessservices.digitalarchitecture.events.DigitalArchitectureEventType;
import org.odpi.openmetadata.accessservices.digitalarchitecture.events.DigitalArchitectureOutTopicEvent;
import org.odpi.openmetadata.accessservices.digitalarchitecture.ffdc.DigitalArchitectureAuditCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DigitalArchitectureOutTopicPublisher {
    private final DigitalArchitectureOutTopicServerConnector outTopicServerConnector;
    private final AuditLog outTopicAuditLog;
    private final String outTopicName;
    private final ElementHeaderConverter<ElementHeader> headerConverter;
    private final OMRSRepositoryHelper repositoryHelper;
    private final String actionDescription = "Out topic configuration refresh event publishing";

    public DigitalArchitectureOutTopicPublisher(DigitalArchitectureOutTopicServerConnector outTopicServerConnector, String outTopicName, AuditLog outTopicAuditLog, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.outTopicServerConnector = outTopicServerConnector;
        this.outTopicAuditLog = outTopicAuditLog;
        this.outTopicName = outTopicName;
        this.repositoryHelper = repositoryHelper;
        this.headerConverter = new ElementHeaderConverter(repositoryHelper, serviceName, serverName);
        if (outTopicAuditLog != null) {
            outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DigitalArchitectureAuditCode.SERVICE_PUBLISHING.getMessageDefinition(new String[]{outTopicName}));
        }
    }

    public void publishEntityEvent(EntityDetail entity, DigitalArchitectureEventType eventType) {
        this.publishEntityEvent(eventType, entity, null, null, null);
    }

    public void publishEntityEvent(DigitalArchitectureEventType eventType, EntityDetail entity, EntityDetail previousEntity, Classification newClassification, Classification previousClassification) {
        String methodName = "publishEntityEvent";
        if (this.outTopicServerConnector != null) {
            DigitalArchitectureOutTopicEvent event = new DigitalArchitectureOutTopicEvent();
            try {
                event.setEventType(eventType);
                if (entity.getUpdateTime() == null) {
                    event.setEventTime(entity.getCreateTime());
                } else {
                    event.setEventTime(entity.getUpdateTime());
                }
                event.setElementHeader(this.headerConverter.getNewBean(ElementHeader.class, entity, "publishEntityEvent"));
                event.setElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(entity.getProperties()));
                if (previousEntity != null) {
                    event.setPreviousElementHeader(this.headerConverter.getNewBean(ElementHeader.class, previousEntity, "publishEntityEvent"));
                    event.setPreviousElementProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousEntity.getProperties()));
                }
                if (newClassification != null) {
                    event.setClassificationName(newClassification.getName());
                }
                if (previousClassification != null) {
                    event.setClassificationName(previousClassification.getName());
                    event.setPreviousClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(previousClassification.getProperties()));
                }
                this.outTopicServerConnector.sendEvent(event);
            }
            catch (Exception error) {
                this.outTopicAuditLog.logException("publishEntityEvent", DigitalArchitectureAuditCode.PROCESS_EVENT_EXCEPTION.getMessageDefinition(new String[]{event.toString(), error.getClass().getName(), error.getMessage()}), (Throwable)error);
            }
        }
    }

    public void disconnect() {
        block3: {
            try {
                this.outTopicServerConnector.disconnect();
                if (this.outTopicAuditLog != null) {
                    this.outTopicAuditLog.logMessage("Out topic configuration refresh event publishing", DigitalArchitectureAuditCode.PUBLISHING_SHUTDOWN.getMessageDefinition(new String[]{this.outTopicName}));
                }
            }
            catch (Exception error) {
                if (this.outTopicAuditLog == null) break block3;
                this.outTopicAuditLog.logException("Out topic configuration refresh event publishing", DigitalArchitectureAuditCode.PUBLISHING_SHUTDOWN_ERROR.getMessageDefinition(new String[]{error.getClass().getName(), this.outTopicName, error.getMessage()}), (Throwable)error);
            }
        }
    }
}

