/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueAssignmentProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValueProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesImplProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ValidValuesMappingProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ReferenceValueAssignmentItemsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentConsumersResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueAssignmentDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValueResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplAssetsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesImplDefinitionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesMappingsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ValidValuesResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.ValidValuesRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/digital-architecture/users/{userId}"})
@Tag(name="Digital Architecture OMAS", description="The Digital Architecture OMAS provides APIs for tools and applications managing the design of data structures, software and the IT infrastructure that supports the operations of the organization.", externalDocs=@ExternalDocumentation(description="Digital Architecture Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/digital-architecture/"))
public class ValidValuesResource {
    private ValidValuesRESTServices restAPI = new ValidValuesRESTServices();

    @PostMapping(path={"/valid-values/sets"})
    public GUIDResponse createValidValueSet(@PathVariable String serverName, @PathVariable String userId, @RequestBody ValidValueProperties requestBody) {
        return this.restAPI.createValidValueSet(serverName, userId, requestBody);
    }

    @PostMapping(path={"/valid-values/sets/{setGUID}"})
    public GUIDResponse createValidValueDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @RequestBody ValidValueProperties requestBody) {
        return this.restAPI.createValidValueDefinition(serverName, userId, setGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/update"})
    public VoidResponse updateValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestBody ValidValueProperties requestBody) {
        return this.restAPI.updateValidValue(serverName, userId, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/delete"})
    public VoidResponse deleteValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestBody String qualifiedName) {
        return this.restAPI.deleteValidValue(serverName, userId, validValueGUID, qualifiedName);
    }

    @PostMapping(path={"/valid-values/sets/{setGUID}/members/{validValueGUID}"})
    public VoidResponse attachValidValueToSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @PathVariable String validValueGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.attachValidValueToSet(serverName, userId, setGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/sets/{setGUID}/members/{validValueGUID}/delete"})
    public VoidResponse detachValidValueFromSet(@PathVariable String serverName, @PathVariable String userId, @PathVariable String setGUID, @PathVariable String validValueGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.detachValidValueFromSet(serverName, userId, setGUID, validValueGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/implementations/{assetGUID}"})
    public VoidResponse linkValidValueToImplementation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String assetGUID, @RequestBody ValidValuesImplProperties requestBody) {
        return this.restAPI.linkValidValueToImplementation(serverName, userId, validValueGUID, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/classify-as-reference-data"})
    public VoidResponse classifyAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.classifyAssetAsReferenceData(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/implementations/{assetGUID}/delete"})
    public VoidResponse unlinkValidValueFromImplementation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unlinkValidValueFromImplementation(serverName, userId, validValueGUID, assetGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/declassify-as-reference-data"})
    public VoidResponse declassifyAssetAsReferenceData(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.declassifyAssetAsReferenceData(serverName, userId, assetGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/consumers/{consumerGUID}"})
    public VoidResponse assignValidValueToConsumer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String consumerGUID, @RequestBody ValidValueAssignmentProperties requestBody) {
        return this.restAPI.assignValidValueToConsumer(serverName, userId, validValueGUID, consumerGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValueGUID}/consumers/{consumerGUID}/delete"})
    public VoidResponse unassignValidValueFromConsumer(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String consumerGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unassignValidValueFromConsumer(serverName, userId, validValueGUID, consumerGUID, requestBody);
    }

    @PostMapping(path={"/reference-values/{validValueGUID}/items/{referenceableGUID}"})
    public VoidResponse assignReferenceValueToItem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String referenceableGUID, @RequestBody ReferenceValueAssignmentProperties requestBody) {
        return this.restAPI.assignReferenceValueToItem(serverName, userId, validValueGUID, referenceableGUID, requestBody);
    }

    @PostMapping(path={"/reference-values/{validValueGUID}/items/{referenceableGUID}/delete"})
    public VoidResponse unassignReferenceValueFromItem(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @PathVariable String referenceableGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unassignReferenceValueFromItem(serverName, userId, validValueGUID, referenceableGUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValue1GUID}/map/{validValue2GUID}"})
    public VoidResponse mapValidValues(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValue1GUID, @PathVariable String validValue2GUID, @RequestBody ValidValuesMappingProperties requestBody) {
        return this.restAPI.mapValidValues(serverName, userId, validValue1GUID, validValue2GUID, requestBody);
    }

    @PostMapping(path={"/valid-values/{validValue1GUID}/map/{validValue2GUID}/delete"})
    public VoidResponse unmapValidValues(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValue1GUID, @PathVariable String validValue2GUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.unmapValidValues(serverName, userId, validValue1GUID, validValue2GUID, requestBody);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}"})
    public ValidValueResponse getValidValueByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID) {
        return this.restAPI.getValidValueByGUID(serverName, userId, validValueGUID);
    }

    @PostMapping(path={"/valid-values/by-name"})
    public ValidValuesResponse getValidValueByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getValidValueByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/valid-values/by-search-string"})
    public ValidValuesResponse findValidValues(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findValidValues(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/sets/{validValueSetGUID}/members"})
    public ValidValuesResponse getValidValueSetMembers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueSetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValueSetMembers(serverName, userId, validValueSetGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/set-membership"})
    public ValidValuesResponse getSetsForValidValue(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getSetsForValidValue(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/consumers"})
    public ValidValueAssignmentConsumersResponse getValidValuesAssignmentConsumers(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValuesAssignmentConsumers(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/referenceables/{referenceableGUID}/valid-value-assignments"})
    public ValidValueAssignmentDefinitionsResponse getValidValuesAssignmentDefinition(@PathVariable String serverName, @PathVariable String userId, @PathVariable String referenceableGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValuesAssignmentDefinition(serverName, userId, referenceableGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/implementations"})
    public ValidValuesImplAssetsResponse getValidValuesImplementationAssets(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValuesImplementationAssets(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/assets/{assetGUID}/valid-value-implementation-definitions"})
    public ValidValuesImplDefinitionsResponse getValidValuesImplementationDefinitions(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValuesImplementationDefinitions(serverName, userId, assetGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/mapped-values"})
    public ValidValueMappingsResponse getValidValueMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValueMappings(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/map-relationships"})
    public ValidValuesMappingsResponse getValidValuesMappings(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getValidValuesMappings(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/valid-values/{validValueGUID}/reference-values/assigned-items"})
    public ReferenceValueAssignmentItemsResponse getReferenceValueAssignedItems(@PathVariable String serverName, @PathVariable String userId, @PathVariable String validValueGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getReferenceValueAssignedItems(serverName, userId, validValueGUID, startFrom, pageSize);
    }

    @GetMapping(path={"/referenceables/{referenceableGUID}/reference-value-assignments"})
    public ReferenceValueAssignmentDefinitionsResponse getReferenceValueAssignments(@PathVariable String serverName, @PathVariable String userId, @PathVariable String referenceableGUID, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getReferenceValueAssignments(serverName, userId, referenceableGUID, startFrom, pageSize);
    }
}

