/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ConnectionProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.EndpointProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectionResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectionsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.ConnectorTypesResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.EmbeddedConnectionRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.EndpointResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.EndpointsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.ConnectionRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/digital-architecture/users/{userId}"})
@Tag(name="Digital Architecture OMAS", description="The Digital Architecture OMAS provides APIs for tools and applications managing the design of data structures, software and the IT infrastructure that supports the operations of the organization.", externalDocs=@ExternalDocumentation(description="Digital Architecture Open Metadata Access Service (OMAS)", url="https://egeria.odpi.org/open-metadata-implementation/access-services/digital-architecture/"))
public class ManageConnectionsResource {
    private ConnectionRESTServices restAPI = new ConnectionRESTServices();

    @PostMapping(path={"/connections"})
    public GUIDResponse createConnection(@PathVariable String serverName, @PathVariable String userId, @RequestBody ConnectionProperties requestBody) {
        return this.restAPI.createConnection(serverName, userId, requestBody);
    }

    @PostMapping(path={"/connections/from-template/{templateGUID}"})
    public GUIDResponse createConnectionFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createConnectionFromTemplate(serverName, userId, templateGUID, templateProperties);
    }

    @PostMapping(path={"/connections/{connectionGUID}/update"})
    public VoidResponse updateConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @RequestParam boolean isMergeUpdate, @RequestBody ConnectionProperties requestBody) {
        return this.restAPI.updateConnection(serverName, userId, connectionGUID, isMergeUpdate, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/connector-types/{connectorTypeGUID}"})
    public VoidResponse setupConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String connectorTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.setupConnectorType(serverName, userId, connectionGUID, connectorTypeGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/connector-types/{connectorTypeGUID}/delete"})
    public VoidResponse clearConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String connectorTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearConnectorType(serverName, userId, connectionGUID, connectorTypeGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/endpoints/{endpointGUID}"})
    public VoidResponse setupEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String endpointGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.setupEndpoint(serverName, userId, connectionGUID, endpointGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/endpoints/{endpointGUID}/delete"})
    public VoidResponse clearEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String endpointGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearEndpoint(serverName, userId, connectionGUID, endpointGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/embedded-connections/{embeddedConnectionGUID}"})
    public VoidResponse setupEmbeddedConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String embeddedConnectionGUID, @RequestBody EmbeddedConnectionRequestBody requestBody) {
        return this.restAPI.setupEmbeddedConnection(serverName, userId, connectionGUID, embeddedConnectionGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/embedded-connections/{embeddedConnectionGUID}/delete"})
    public VoidResponse clearEmbeddedConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @PathVariable String embeddedConnectionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearEmbeddedConnection(serverName, userId, connectionGUID, embeddedConnectionGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/connections/{connectionGUID}"})
    public VoidResponse setupAssetConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID, @PathVariable StringRequestBody requestBody) {
        return this.restAPI.setupAssetConnection(serverName, userId, assetGUID, connectionGUID, requestBody);
    }

    @PostMapping(path={"/assets/{assetGUID}/connections/{connectionGUID}/delete"})
    public VoidResponse clearAssetConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String assetGUID, @PathVariable String connectionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearAssetConnection(serverName, userId, assetGUID, connectionGUID, requestBody);
    }

    @PostMapping(path={"/connections/{connectionGUID}/delete"})
    public VoidResponse removeConnection(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeConnection(serverName, userId, connectionGUID, requestBody);
    }

    @PostMapping(path={"/connections/by-search-string"})
    public ConnectionsResponse findConnections(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findConnections(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/connections/by-name"})
    public ConnectionsResponse getConnectionsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getConnectionsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/connections/{connectionGUID}"})
    public ConnectionResponse getConnectionByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectionGUID) {
        return this.restAPI.getConnectionByGUID(serverName, userId, connectionGUID);
    }

    @PostMapping(path={"/endpoints"})
    public GUIDResponse createEndpoint(@PathVariable String serverName, @PathVariable String userId, @RequestBody EndpointProperties endpointProperties) {
        return this.restAPI.createEndpoint(serverName, userId, endpointProperties);
    }

    @PostMapping(path={"/endpoints/network-address/{networkAddress}/from-template/{templateGUID}"})
    public GUIDResponse createEndpointFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String networkAddress, @PathVariable String templateGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createEndpointFromTemplate(serverName, userId, networkAddress, templateGUID, templateProperties);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}/update"})
    public VoidResponse updateEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestParam boolean isMergeUpdate, @RequestBody EndpointProperties endpointProperties) {
        return this.restAPI.updateEndpoint(serverName, userId, endpointGUID, isMergeUpdate, endpointProperties);
    }

    @PostMapping(path={"/endpoints/{endpointGUID}/delete"})
    public VoidResponse removeEndpoint(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeEndpoint(serverName, userId, endpointGUID, requestBody);
    }

    @PostMapping(path={"/endpoints/by-search-string"})
    public EndpointsResponse findEndpoints(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findEndpoints(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/endpoints/by-name"})
    public EndpointsResponse getEndpointsByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getEndpointsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/endpoints/{endpointGUID}"})
    public EndpointResponse getEndpointByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String endpointGUID) {
        return this.restAPI.getEndpointByGUID(serverName, userId, endpointGUID);
    }

    @PostMapping(path={"/connector-types"})
    public GUIDResponse createConnectorType(@PathVariable String serverName, @PathVariable String userId, @RequestBody ConnectorTypeProperties connectorTypeProperties) {
        return this.restAPI.createConnectorType(serverName, userId, connectorTypeProperties);
    }

    @PostMapping(path={"/connector-types/from-template/{templateGUID}"})
    public GUIDResponse createConnectorTypeFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createConnectorTypeFromTemplate(serverName, userId, templateGUID, templateProperties);
    }

    @PostMapping(path={"/connector-types/{connectorTypeGUID}/update"})
    public VoidResponse updateConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID, @RequestParam boolean isMergeUpdate, @RequestBody ConnectorTypeProperties connectorTypeProperties) {
        return this.restAPI.updateConnectorType(serverName, userId, connectorTypeGUID, isMergeUpdate, connectorTypeProperties);
    }

    @PostMapping(path={"/connector-types/{connectorTypeGUID}/delete"})
    public VoidResponse removeConnectorType(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeConnectorType(serverName, userId, connectorTypeGUID, requestBody);
    }

    @PostMapping(path={"/connector-types/by-search-string"})
    public ConnectorTypesResponse findConnectorTypes(@PathVariable String serverName, @PathVariable String userId, @RequestBody SearchStringRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.findConnectorTypes(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/connector-types/by-name"})
    public ConnectorTypesResponse getConnectorTypesByName(@PathVariable String serverName, @PathVariable String userId, @RequestBody NameRequestBody requestBody, @RequestParam int startFrom, @RequestParam int pageSize) {
        return this.restAPI.getConnectorTypesByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/connector-types/{connectorTypeGUID}"})
    public ConnectorTypeResponse getConnectorTypeByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String connectorTypeGUID) {
        return this.restAPI.getConnectorTypeByGUID(serverName, userId, connectorTypeGUID);
    }
}

