/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.LocationProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.properties.TemplateProperties;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.DigitalLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.FixedLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.LocationResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.LocationsResponse;
import org.odpi.openmetadata.accessservices.digitalarchitecture.rest.SecureLocationRequestBody;
import org.odpi.openmetadata.accessservices.digitalarchitecture.server.LocationRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SearchStringRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/digital-architecture/users/{userId}"})
@Tag(name="Digital Architecture OMAS", description="The Digital Architecture OMAS provides APIs for tools and applications managing the design of data structures, software and the IT infrastructure that supports the operations of the organization.", externalDocs=@ExternalDocumentation(description="Digital Architecture Open Metadata Access Service (OMAS)", url="https://odpi.github.io/egeria-docs/services/omas/digital-architecture/overview/"))
public class LocationResource {
    private LocationRESTServices restAPI = new LocationRESTServices();

    @PostMapping(path={"/locations"})
    public GUIDResponse createLocation(@PathVariable String serverName, @PathVariable String userId, @RequestBody LocationProperties locationProperties) {
        return this.restAPI.createLocation(serverName, userId, locationProperties);
    }

    @PostMapping(path={"/locations/from-template/{templateGUID}"})
    public GUIDResponse createLocationFromTemplate(@PathVariable String serverName, @PathVariable String userId, @PathVariable String templateGUID, @RequestBody TemplateProperties templateProperties) {
        return this.restAPI.createLocationFromTemplate(serverName, userId, templateGUID, templateProperties);
    }

    @PostMapping(path={"/locations/{locationGUID}/update"})
    public VoidResponse updateLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestParam boolean isMergeUpdate, @RequestBody LocationProperties locationProperties) {
        return this.restAPI.updateLocation(serverName, userId, locationGUID, isMergeUpdate, locationProperties);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-fixed-location"})
    public VoidResponse setLocationAsFixedPhysical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody FixedLocationRequestBody requestBody) {
        return this.restAPI.setLocationAsFixedPhysical(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-fixed-location/delete"})
    public VoidResponse clearLocationAsFixedPhysical(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearLocationAsFixedPhysical(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-secure-location"})
    public VoidResponse setLocationAsSecure(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody SecureLocationRequestBody requestBody) {
        return this.restAPI.setLocationAsSecure(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-secure-location/delete"})
    public VoidResponse clearLocationAsSecure(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearLocationAsSecure(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-digital-location"})
    public VoidResponse setLocationAsDigital(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody DigitalLocationRequestBody requestBody) {
        return this.restAPI.setLocationAsDigital(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/classify-as-digital-location/delete"})
    public VoidResponse clearLocationAsDigital(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearLocationAsDigital(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationGUID}/delete"})
    public VoidResponse removeLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.removeLocation(serverName, userId, locationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{parentLocationGUID}/has-nested-location/{childLocationGUID}"})
    public VoidResponse setupNestedLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentLocationGUID, @PathVariable String childLocationGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.setupNestedLocation(serverName, userId, parentLocationGUID, childLocationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{parentLocationGUID}/has-nested-location/{childLocationGUID}/delete"})
    public VoidResponse clearNestedLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String parentLocationGUID, @PathVariable String childLocationGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearNestedLocation(serverName, userId, parentLocationGUID, childLocationGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationOneGUID}/linked-to-peer-location/{locationTwoGUID}"})
    public VoidResponse setupAdjacentLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationOneGUID, @PathVariable String locationTwoGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.setupAdjacentLocation(serverName, userId, locationOneGUID, locationTwoGUID, requestBody);
    }

    @PostMapping(path={"/locations/{locationOneGUID}/linked-to-peer-location/{locationTwoGUID}/delete"})
    public VoidResponse clearAdjacentLocation(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationOneGUID, @PathVariable String locationTwoGUID, @RequestBody(required=false) NullRequestBody requestBody) {
        return this.restAPI.clearAdjacentLocation(serverName, userId, locationOneGUID, locationTwoGUID, requestBody);
    }

    @PostMapping(path={"/locations/by-search-string"})
    public LocationsResponse findLocations(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody SearchStringRequestBody requestBody) {
        return this.restAPI.findLocations(serverName, userId, requestBody, startFrom, pageSize);
    }

    @PostMapping(path={"/locations/by-name"})
    public LocationsResponse getLocationsByName(@PathVariable String serverName, @PathVariable String userId, @RequestParam int startFrom, @RequestParam int pageSize, @RequestBody NameRequestBody requestBody) {
        return this.restAPI.getLocationsByName(serverName, userId, requestBody, startFrom, pageSize);
    }

    @GetMapping(path={"/locations/{locationGUID}"})
    public LocationResponse getLocationByGUID(@PathVariable String serverName, @PathVariable String userId, @PathVariable String locationGUID) {
        return this.restAPI.getLocationByGUID(serverName, userId, locationGUID);
    }
}

