/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalarchitecture.connectors.outtopic;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.accessservices.digitalarchitecture.api.DigitalArchitectureEventInterface;
import org.odpi.openmetadata.accessservices.digitalarchitecture.api.DigitalArchitectureEventListener;
import org.odpi.openmetadata.accessservices.digitalarchitecture.events.DigitalArchitectureOutTopicEvent;
import org.odpi.openmetadata.accessservices.digitalarchitecture.ffdc.DigitalArchitectureErrorCode;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicListenerConnectorBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalArchitectureOutTopicClientConnector
extends OpenMetadataTopicListenerConnectorBase
implements DigitalArchitectureEventInterface {
    private static final Logger log = LoggerFactory.getLogger(DigitalArchitectureOutTopicClientConnector.class);
    private List<DigitalArchitectureEventListener> internalEventListeners = new ArrayList<DigitalArchitectureEventListener>();

    public synchronized void registerListener(String userId, DigitalArchitectureEventListener listener) throws InvalidParameterException {
        String methodName = "registerListener";
        String parameterName = "listener";
        if (listener == null) {
            throw new InvalidParameterException(DigitalArchitectureErrorCode.NULL_LISTENER.getMessageDefinition(new String[]{userId, "registerListener"}), ((Object)((Object)this)).getClass().getName(), "registerListener", "listener");
        }
        this.internalEventListeners.add(listener);
    }

    public synchronized void processEvent(String event) {
        if (event != null) {
            try {
                DigitalArchitectureOutTopicEvent eventObject = (DigitalArchitectureOutTopicEvent)super.getEventBean(event, DigitalArchitectureOutTopicEvent.class);
                for (DigitalArchitectureEventListener listener : this.internalEventListeners) {
                    try {
                        listener.processEvent(eventObject);
                    }
                    catch (Exception error) {
                        log.error("Listener: " + listener.getClass().getName() + " is unable to process event: " + event, (Throwable)error);
                    }
                }
            }
            catch (Exception error) {
                log.error("Unable to read event: " + event, (Throwable)error);
            }
        }
    }
}

