/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DigitalServiceEventType implements Serializable
{
    UNKNOWN_DIGITAL_SERVICE_EVENT(0, "UnknownEvent", "An event that is not recognized by the local server."),
    NEW_DIGITAL_SERVICE_EVENT(1, "NewDigitalService", "A new digital service has been defined."),
    UPDATED_DIGITAL_SERVICE_EVENT(2, "UpdatedDigitalService", "An existing digital service has been updated."),
    DELETED_DIGITAL_SERVICE_EVENT(3, "DeletedDigitalService", "An existing digital service has been deleted.");

    private static final long serialVersionUID = 1L;
    private final int eventTypeCode;
    private final String eventTypeName;
    private final String eventTypeDescription;

    private DigitalServiceEventType(int eventTypeCode, String eventTypeName, String eventTypeDescription) {
        this.eventTypeCode = eventTypeCode;
        this.eventTypeName = eventTypeName;
        this.eventTypeDescription = eventTypeDescription;
    }

    public int getEventTypeCode() {
        return this.eventTypeCode;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public String getEventTypeDescription() {
        return this.eventTypeDescription;
    }

    public String toString() {
        return "DigitalServiceEventType{eventTypeCode=" + this.eventTypeCode + ", eventTypeName='" + this.eventTypeName + "', eventTypeDescription='" + this.eventTypeDescription + "'}";
    }
}

