/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogRecordSeverity;

public enum DigitalServiceAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-DIGITAL-SERVICE-0001", OMRSAuditLogRecordSeverity.STARTUP, "The DigitalService Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the DigitalService OMAS.", "No action is needed if this service is required.  This is part of the configured operation of the server."),
    SERVICE_INITIALIZED("OMAS-DIGITAL-SERVICE-0003", OMRSAuditLogRecordSeverity.STARTUP, "The DigitalService Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that there were no errors reported as the service started."),
    SERVICE_SHUTDOWN("OMAS-DIGITAL-SERVICE-0004", OMRSAuditLogRecordSeverity.SHUTDOWN, "The DigitalService Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an DigitalService OMAS instance.", "Verify that all resources have been released."),
    SERVICE_INSTANCE_FAILURE("OMAS-DIGITAL-SERVICE-0005", OMRSAuditLogRecordSeverity.EXCEPTION, "The DigitalService Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private final AuditLogMessageDefinition messageDefinition;

    private DigitalServiceAuditCode(String messageId, OMRSAuditLogRecordSeverity severity, String message, String systemAction, String userAction) {
        this.messageDefinition = new AuditLogMessageDefinition(messageId, (AuditLogRecordSeverity)severity, message, systemAction, userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }
}

