/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalservice.events.DigitalServiceEventHeader;
import org.odpi.openmetadata.accessservices.digitalservice.events.DigitalServiceEventType;
import org.odpi.openmetadata.accessservices.digitalservice.properties.DigitalService;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DigitalServiceEvent
extends DigitalServiceEventHeader {
    private static final long serialVersionUID = 1L;
    private DigitalServiceEventType eventType = null;
    private DigitalService originalDigitalService = null;
    private DigitalService digitalService = null;

    public DigitalServiceEvent() {
    }

    public DigitalServiceEvent(DigitalServiceEvent template) {
        super(template);
        if (template != null) {
            this.eventType = template.getEventType();
            this.digitalService = template.getDigitalService();
            this.originalDigitalService = template.getOriginalDigitalService();
        }
    }

    public DigitalServiceEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(DigitalServiceEventType eventType) {
        this.eventType = eventType;
    }

    public DigitalService getOriginalDigitalService() {
        if (this.originalDigitalService == null) {
            return null;
        }
        return new DigitalService(this.originalDigitalService);
    }

    public void setOriginalDigitalService(DigitalService originalDigitalService) {
        this.originalDigitalService = originalDigitalService;
    }

    public DigitalService getDigitalService() {
        if (this.digitalService == null) {
            return null;
        }
        return new DigitalService(this.digitalService);
    }

    public void setDigitalService(DigitalService digitalService) {
        this.digitalService = digitalService;
    }

    @Override
    public String toString() {
        return "DigitalServiceEvent{eventType=" + this.eventType + ", originalDigitalService=" + this.originalDigitalService + ", digitalService=" + this.digitalService + ", eventVersionId=" + this.getEventVersionId() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof DigitalServiceEvent)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DigitalServiceEvent that = (DigitalServiceEvent)objectToCompare;
        return this.getEventType() == that.getEventType() && Objects.equals(this.getOriginalDigitalService(), that.getOriginalDigitalService()) && Objects.equals(this.getDigitalService(), that.getDigitalService());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEventType(), this.getOriginalDigitalService(), this.getDigitalService());
    }
}

