/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalservice.properties.ClassificationProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DigitalProductProperties
extends ClassificationProperties {
    private static final long serialVersionUID = 1L;
    private String productName = null;
    private String productType = null;
    private String description = null;
    private Date introductionDate = null;
    private String maturity = null;
    private String serviceLife = null;
    private String currentVersion = null;
    private Date nextVersion = null;
    private Date withdrawDate = null;
    private Map<String, String> additionalProperties = null;

    public DigitalProductProperties() {
    }

    public DigitalProductProperties(DigitalProductProperties template) {
        super(template);
        if (template != null) {
            this.productName = template.getProductName();
            this.productType = template.getProductType();
            this.description = template.getDescription();
            this.introductionDate = template.getIntroductionDate();
            this.maturity = template.getMaturity();
            this.serviceLife = template.getServiceLife();
            this.currentVersion = template.getCurrentVersion();
            this.nextVersion = template.getNextVersion();
            this.withdrawDate = template.getWithdrawDate();
            this.additionalProperties = template.getAdditionalProperties();
        }
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getIntroductionDate() {
        return this.introductionDate;
    }

    public void setIntroductionDate(Date introductionDate) {
        this.introductionDate = introductionDate;
    }

    public String getMaturity() {
        return this.maturity;
    }

    public void setMaturity(String maturity) {
        this.maturity = maturity;
    }

    public String getServiceLife() {
        return this.serviceLife;
    }

    public void setServiceLife(String serviceLife) {
        this.serviceLife = serviceLife;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public Date getNextVersion() {
        return this.nextVersion;
    }

    public void setNextVersion(Date nextVersion) {
        this.nextVersion = nextVersion;
    }

    public Date getWithdrawDate() {
        return this.withdrawDate;
    }

    public void setWithdrawDate(Date withdrawDate) {
        this.withdrawDate = withdrawDate;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public String toString() {
        return "DigitalProductProperties{effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", extendedProperties=" + this.getExtendedProperties() + ", productName='" + this.productName + "', productType='" + this.productType + "', description='" + this.description + "', introductionDate=" + this.introductionDate + ", maturity='" + this.maturity + "', serviceLife='" + this.serviceLife + "', currentVersion='" + this.currentVersion + "', nextVersion=" + this.nextVersion + ", withdrawDate=" + this.withdrawDate + ", additionalProperties=" + this.additionalProperties + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof DigitalProductProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DigitalProductProperties that = (DigitalProductProperties)objectToCompare;
        return Objects.equals(this.productName, that.productName) && Objects.equals(this.productType, that.productType) && Objects.equals(this.description, that.description) && Objects.equals(this.introductionDate, that.introductionDate) && Objects.equals(this.maturity, that.maturity) && Objects.equals(this.serviceLife, that.serviceLife) && Objects.equals(this.currentVersion, that.currentVersion) && Objects.equals(this.nextVersion, that.nextVersion) && Objects.equals(this.withdrawDate, that.withdrawDate) && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.productName, this.productType, this.description, this.introductionDate, this.maturity, this.serviceLife, this.currentVersion, this.nextVersion, this.withdrawDate, this.additionalProperties);
    }
}

