/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.metadataelements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalservice.metadataelements.Appointee;
import org.odpi.openmetadata.accessservices.digitalservice.metadataelements.PersonRoleAppointee;
import org.odpi.openmetadata.accessservices.digitalservice.metadataelements.PersonRoleElement;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PersonRoleHistory
extends PersonRoleAppointee {
    private List<Appointee> predecessors = null;
    private List<Appointee> successors = null;

    public PersonRoleHistory() {
    }

    public PersonRoleHistory(PersonRoleHistory template) {
        super(template);
        if (template != null) {
            this.predecessors = template.getPredecessors();
            this.successors = template.getSuccessors();
        }
    }

    public PersonRoleHistory(PersonRoleElement template) {
        super(template);
    }

    public List<Appointee> getPredecessors() {
        return this.predecessors;
    }

    public void setPredecessors(List<Appointee> predecessors) {
        this.predecessors = predecessors;
    }

    public List<Appointee> getSuccessors() {
        return this.successors;
    }

    public void setSuccessors(List<Appointee> successors) {
        this.successors = successors;
    }

    @Override
    public String toString() {
        return "PersonRoleHistory{currentAppointees=" + this.getCurrentAppointees() + ", elementHeader=" + this.getElementHeader() + ", properties=" + this.getProperties() + ", predecessors=" + this.predecessors + ", successors=" + this.successors + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PersonRoleHistory that = (PersonRoleHistory)objectToCompare;
        return Objects.equals(this.predecessors, that.predecessors) && Objects.equals(this.successors, that.successors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.predecessors, this.successors);
    }
}

