/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalservice.properties.DigitalSubscriptionProperties;
import org.odpi.openmetadata.accessservices.digitalservice.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DigitalSubscriptionProperties.class, name="DigitalSubscriptionProperties")})
public class AgreementProperties
extends ReferenceableProperties {
    private String displayName = null;
    private String description = null;
    private String agreementType = null;

    public AgreementProperties() {
    }

    public AgreementProperties(AgreementProperties template) {
        super(template);
        if (template != null) {
            this.agreementType = template.getAgreementType();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAgreementType() {
        return this.agreementType;
    }

    public void setAgreementType(String agreementType) {
        this.agreementType = agreementType;
    }

    @Override
    public String toString() {
        return "AgreementProperties{displayName='" + this.displayName + "', description='" + this.description + "', agreementType='" + this.agreementType + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AgreementProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AgreementProperties that = (AgreementProperties)objectToCompare;
        return Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && Objects.equals(this.agreementType, that.agreementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.description, this.agreementType);
    }
}

