/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DigitalProductStatus {
    UNKNOWN(0, "Unknown", "Unknown instance status."),
    DRAFT(1, "Draft", "The content is incomplete."),
    PREPARED(2, "Prepared", "The content is ready for review."),
    PROPOSED(3, "Proposed", "The content is in review."),
    APPROVED(4, "Approved", "The content is approved."),
    REJECTED(5, "Rejected", "The request or proposal is rejected."),
    APPROVED_CONCEPT(6, "Approved concept", "The request or proposal is approved for development."),
    UNDER_DEVELOPMENT(7, "Under development", "The instance is being developed."),
    DEVELOPMENT_COMPLETE(8, "Development complete", "The development of the instance is complete."),
    APPROVED_FOR_DEPLOYMENT(9, "Approved for deployment", "The instance is approved for deployment."),
    ACTIVE(15, "Active", "The instance is approved and in use."),
    DISABLED(21, "Disabled", "The instance is shutdown or disabled."),
    DEPRECATED(30, "Deprecated", "The instance is out of date and should not be used."),
    OTHER(50, "Other", "The instance is in a locally defined state.");

    private final int ordinal;
    private final String name;
    private final String description;

    private DigitalProductStatus(int ordinal, String name, String description) {
        this.ordinal = ordinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "DigitalProductStatus{ordinal=" + this.ordinal + ", name='" + this.name + "', description='" + this.description + "'}";
    }
}

