/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalservice.properties.CertificationTypeProperties;
import org.odpi.openmetadata.accessservices.digitalservice.properties.LicenseTypeProperties;
import org.odpi.openmetadata.accessservices.digitalservice.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=LicenseTypeProperties.class, name="LicenseTypeProperties"), @JsonSubTypes.Type(value=CertificationTypeProperties.class, name="CertificationTypeProperties")})
public class GovernanceDefinitionProperties
extends ReferenceableProperties {
    private String title = null;
    private String summary = null;
    private String description = null;
    private String scope = null;
    private int domainIdentifier = 0;
    private String priority = null;
    private List<String> implications = null;
    private List<String> outcomes = null;
    private List<String> results = null;

    public GovernanceDefinitionProperties() {
    }

    public GovernanceDefinitionProperties(GovernanceDefinitionProperties template) {
        super(template);
        if (template != null) {
            this.title = template.getTitle();
            this.summary = template.getSummary();
            this.description = template.getDescription();
            this.scope = template.getScope();
            this.domainIdentifier = template.getDomainIdentifier();
            this.priority = template.getPriority();
            this.implications = template.getImplications();
            this.outcomes = template.getOutcomes();
            this.results = template.getResults();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public void setDomainIdentifier(int domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public List<String> getImplications() {
        return this.implications;
    }

    public void setImplications(List<String> implications) {
        this.implications = implications;
    }

    public List<String> getOutcomes() {
        if (this.outcomes == null) {
            return null;
        }
        if (this.outcomes.isEmpty()) {
            return null;
        }
        return this.outcomes;
    }

    public void setOutcomes(List<String> outcomes) {
        this.outcomes = outcomes;
    }

    public List<String> getResults() {
        if (this.outcomes == null) {
            return null;
        }
        if (this.outcomes.isEmpty()) {
            return null;
        }
        return this.outcomes;
    }

    public void setResults(List<String> results) {
        this.results = results;
    }

    @Override
    public String toString() {
        return "GovernanceDefinitionProperties{title='" + this.title + "', summary='" + this.summary + "', description='" + this.description + "', scope='" + this.scope + "', domainIdentifier=" + this.domainIdentifier + ", priority='" + this.priority + "', implications=" + this.implications + ", outcomes=" + this.outcomes + ", results=" + this.results + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof GovernanceDefinitionProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceDefinitionProperties that = (GovernanceDefinitionProperties)objectToCompare;
        return this.domainIdentifier == that.domainIdentifier && Objects.equals(this.title, that.title) && Objects.equals(this.summary, that.summary) && Objects.equals(this.description, that.description) && Objects.equals(this.scope, that.scope) && Objects.equals(this.priority, that.priority) && Objects.equals(this.implications, that.implications) && Objects.equals(this.outcomes, that.outcomes) && Objects.equals(this.results, that.results);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.title, this.summary, this.description, this.scope, this.domainIdentifier, this.priority, this.implications, this.outcomes, this.results);
    }
}

