/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.digitalservice.properties.PersonRoleProperties;
import org.odpi.openmetadata.accessservices.digitalservice.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=PersonRoleProperties.class, name="PersonRoleProperties")})
public class PersonalRoleProperties
extends ReferenceableProperties {
    private String roleId = null;
    private String scope = null;
    private String title = null;
    private String description = null;
    private int domainIdentifier = 0;

    public PersonalRoleProperties() {
    }

    public PersonalRoleProperties(PersonalRoleProperties template) {
        super(template);
        if (template != null) {
            this.roleId = template.getRoleId();
            this.scope = template.getScope();
            this.title = template.getTitle();
            this.description = template.getDescription();
            this.domainIdentifier = template.getDomainIdentifier();
        }
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public void setDomainIdentifier(int domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    @Override
    public String toString() {
        return "PersonalRoleProperties{roleId='" + this.roleId + "', scope='" + this.scope + "', title='" + this.title + "', description='" + this.description + "', domainIdentifier=" + this.domainIdentifier + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof PersonalRoleProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        PersonalRoleProperties that = (PersonalRoleProperties)objectToCompare;
        return this.domainIdentifier == that.domainIdentifier && Objects.equals(this.roleId, that.roleId) && Objects.equals(this.scope, that.scope) && Objects.equals(this.title, that.title) && Objects.equals(this.description, that.description);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.roleId, this.scope, this.title, this.description, this.domainIdentifier);
    }
}

