/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalservice.api.CollectionsInterface;
import org.odpi.openmetadata.accessservices.digitalservice.client.DigitalServiceBaseClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.converters.CollectionConverter;
import org.odpi.openmetadata.frameworks.governanceaction.converters.CollectionMemberConverter;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ClassificationCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchClassifications;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CollectionMemberStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OrderBy;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionMember;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionFolderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.digitalbusiness.DigitalProductProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.resources.ResourceListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class CollectionsClient
extends DigitalServiceBaseClient
implements CollectionsInterface {
    private final CollectionConverter<CollectionElement> collectionConverter;
    private final Class<CollectionElement> collectionBeanClass = CollectionElement.class;
    private final CollectionMemberConverter<CollectionMember> collectionMemberConverter;
    private final Class<CollectionMember> collectionMemberBeanClass = CollectionMember.class;

    public CollectionsClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
        this.collectionConverter = new CollectionConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
        this.collectionMemberConverter = new CollectionMemberConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
    }

    public CollectionsClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.collectionConverter = new CollectionConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
        this.collectionMemberConverter = new CollectionMemberConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
    }

    public List<CollectionElement> getAttachedCollections(String userId, String parentGUID, String collectionType, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getLinkedCollections";
        String parentGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLinkedCollections");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "getLinkedCollections");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLinkedCollections");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, parentGUID, 1, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<CollectionElement> filteredCollections = new ArrayList<CollectionElement>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.COLLECTION.typeName)) continue;
                CollectionElement collectionElement = (CollectionElement)this.collectionConverter.getNewBean(this.collectionBeanClass, relatedMetadataElement, "getLinkedCollections");
                if (collectionType != null && !collectionType.equals(collectionElement.getProperties().getCollectionType())) continue;
                filteredCollections.add(collectionElement);
            }
            if (!filteredCollections.isEmpty()) {
                return null;
            }
        }
        return null;
    }

    public List<CollectionElement> getClassifiedCollections(String userId, String classificationName, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getClassifiedCollections";
        this.invalidParameterHandler.validateUserId(userId, "getClassifiedCollections");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getClassifiedCollections");
        SearchClassifications searchClassifications = null;
        if (classificationName != null) {
            searchClassifications = new SearchClassifications();
            ArrayList<ClassificationCondition> classificationConditions = new ArrayList<ClassificationCondition>();
            ClassificationCondition classificationCondition = new ClassificationCondition();
            classificationCondition.setName(classificationName);
            classificationConditions.add(classificationCondition);
            searchClassifications.setConditions(classificationConditions);
            searchClassifications.setMatchCriteria(MatchCriteria.ALL);
        }
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.COLLECTION.typeName, null, null, null, null, searchClassifications, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, new Date(), startFrom, pageSize);
        return this.convertCollections(openMetadataElements, "getClassifiedCollections");
    }

    private List<CollectionElement> convertCollections(List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<CollectionElement> collectionElements = new ArrayList<CollectionElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                collectionElements.add((CollectionElement)this.collectionConverter.getNewBean(this.collectionBeanClass, openMetadataElement, methodName));
            }
            return collectionElements;
        }
        return null;
    }

    public List<CollectionElement> findCollections(String userId, String searchString, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findCollections";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findCollections");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findCollections");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findCollections");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.COLLECTION.typeName, null, null, null, null, false, false, effectiveTime, startFrom, pageSize);
        return this.convertCollections(openMetadataElements, "findCollections");
    }

    public List<CollectionElement> getCollectionsByName(String userId, String name, int startFrom, int pageSize, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getCollectionsByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionsByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.NAME.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.COLLECTION.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, name, PropertyComparisonOperator.EQ), null, null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, effectiveTime, startFrom, pageSize);
        return this.convertCollections(openMetadataElements, "getCollectionsByName");
    }

    public List<CollectionElement> getCollectionsByType(String userId, String collectionType, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionsByType";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionsByType");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionsByType");
        List<String> propertyNames = List.of(OpenMetadataProperty.COLLECTION_TYPE.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.COLLECTION.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, collectionType, PropertyComparisonOperator.EQ), null, null, null, OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, new Date(), startFrom, pageSize);
        return this.convertCollections(openMetadataElements, "getCollectionsByType");
    }

    public CollectionElement getCollection(String userId, String collectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollection";
        String guidParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollection");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, collectionGUID, false, false, null, new Date());
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.COLLECTION.typeName)) {
            return (CollectionElement)this.collectionConverter.getNewBean(this.collectionBeanClass, openMetadataElement, "getCollection");
        }
        return null;
    }

    public String createCollection(String userId, String anchorGUID, boolean isOwnAnchor, String optionalClassification, CollectionProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createCollection";
        String collectionPropertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createCollection");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createCollection");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createCollection");
        String collectionTypeName = OpenMetadataType.COLLECTION.typeName;
        if (properties.getTypeName() != null) {
            collectionTypeName = properties.getTypeName();
        }
        HashMap<String, ElementProperties> initialClassifications = null;
        if (OpenMetadataType.FOLDER.typeName.equals(optionalClassification)) {
            initialClassifications = new HashMap<String, ElementProperties>();
            ElementProperties classificationProperties = null;
            if (properties instanceof CollectionFolderProperties) {
                CollectionFolderProperties collectionFolderProperties = (CollectionFolderProperties)properties;
                classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ORDER_BY_PROPERTY_NAME.name, collectionFolderProperties.getOrderByPropertyName());
                if (collectionFolderProperties.getCollectionOrder() != null) {
                    classificationProperties = this.propertyHelper.addEnumProperty(classificationProperties, OpenMetadataProperty.COLLECTION_ORDER.name, OrderBy.getOpenTypeName(), collectionFolderProperties.getCollectionOrder().getName());
                }
            }
            initialClassifications.put(OpenMetadataType.FOLDER.typeName, classificationProperties);
        } else if (optionalClassification != null) {
            initialClassifications = new HashMap();
            initialClassifications.put(optionalClassification, null);
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, null, null, collectionTypeName, ElementStatus.ACTIVE, initialClassifications, anchorGUID, isOwnAnchor, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public String createCollectionFromTemplate(String userId, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createMetadataElementFromTemplate(userId, OpenMetadataType.COLLECTION.typeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
    }

    public String createDigitalProduct(String userId, String anchorGUID, boolean isOwnAnchor, CollectionProperties collectionProperties, DigitalProductProperties digitalProductProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createDigitalProduct";
        this.invalidParameterHandler.validateUserId(userId, "createDigitalProduct");
        String collectionGUID = this.createCollection(userId, anchorGUID, isOwnAnchor, null, collectionProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
        if (collectionGUID != null) {
            this.openMetadataStoreClient.classifyMetadataElementInStore(userId, collectionGUID, OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION.typeName, false, false, digitalProductProperties.getEffectiveFrom(), digitalProductProperties.getEffectiveTo(), this.getElementProperties(digitalProductProperties), new Date());
        }
        return collectionGUID;
    }

    public void updateCollection(String userId, String collectionGUID, boolean replaceAllProperties, CollectionProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateCollection";
        String collectionPropertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateCollection");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateCollection");
        if (replaceAllProperties) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateCollection");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, collectionGUID, replaceAllProperties, false, false, this.getElementProperties(properties), new Date());
    }

    public void updateDigitalProduct(String userId, String collectionGUID, boolean replaceAllProperties, DigitalProductProperties properties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateDigitalProduct";
        String propertiesName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateDigitalProduct");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateDigitalProduct");
        this.openMetadataStoreClient.reclassifyMetadataElementInStore(userId, collectionGUID, OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION.typeName, replaceAllProperties, false, false, this.getElementProperties(properties), new Date());
    }

    public void attachCollection(String userId, String collectionGUID, String parentGUID, ResourceListProperties collectionUse, boolean makeAnchor) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataElement parent;
        String methodName = "attachCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String parentGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "attachCollection");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "attachCollection");
        ElementProperties properties = null;
        if (collectionUse != null) {
            properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.RESOURCE_USE.name, collectionUse.getResourceUse());
            properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name, collectionUse.getResourceUse());
            properties = this.propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, collectionUse.getResourceUseProperties());
            properties = this.propertyHelper.addBooleanProperty(properties, OpenMetadataProperty.WATCH_RESOURCE.name, collectionUse.getWatchResource());
        }
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, parentGUID, collectionGUID, false, false, null, null, properties, new Date());
        if (makeAnchor && (parent = this.openMetadataStoreClient.getMetadataElementByGUID(userId, parentGUID, false, false, null, new Date())) != null) {
            ElementProperties classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ANCHOR_GUID.name, parent.getElementGUID());
            classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, parent.getType().getTypeName());
            classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, this.propertyHelper.getDomainName((ElementControlHeader)parent));
            this.openMetadataStoreClient.classifyMetadataElementInStore(userId, collectionGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, false, false, null, null, classificationProperties, new Date());
        }
    }

    public void detachCollection(String userId, String collectionGUID, String parentGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String parentGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "detachCollection");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "detachCollection");
        this.openMetadataStoreClient.deleteRelatedElementsInStore(userId, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, parentGUID, collectionGUID, false, false, new Date());
    }

    public void deleteCollection(String userId, String collectionGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteCollection";
        String collectionGUIDParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "deleteCollection");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, collectionGUID, false, false, new Date());
    }

    public List<CollectionMember> getCollectionMembers(String userId, String collectionGUID, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionMembers";
        String collectionGUIDParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionMembers");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollectionMembers");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionMembers");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, collectionGUID, 1, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<CollectionMember> collectionMembers = new ArrayList<CollectionMember>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                collectionMembers.add((CollectionMember)this.collectionMemberConverter.getNewBean(this.collectionMemberBeanClass, relatedMetadataElement, "getCollectionMembers"));
            }
            if (!collectionMembers.isEmpty()) {
                return collectionMembers;
            }
        }
        return null;
    }

    private String getMembershipRelationshipGUID(String userId, String collectionGUID, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataRelationshipList linkedResources = this.openMetadataStoreClient.getMetadataElementRelationships(userId, collectionGUID, elementGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, null, null, null, null, false, false, new Date(), 0, 0);
        if (linkedResources != null) {
            for (OpenMetadataRelationship relatedMetadataElement : linkedResources.getElementList()) {
                if (relatedMetadataElement == null) continue;
                return relatedMetadataElement.getRelationshipGUID();
            }
        }
        return null;
    }

    public void addToCollection(String userId, String collectionGUID, CollectionMembershipProperties membershipProperties, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addToCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "addToCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "addToCollection");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "addToCollection");
        String relationshipGUID = this.getMembershipRelationshipGUID(userId, collectionGUID, elementGUID);
        if (relationshipGUID == null) {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, collectionGUID, elementGUID, false, false, null, null, this.getElementProperties(membershipProperties), new Date());
        } else {
            this.updateCollectionMembership(userId, relationshipGUID, true, membershipProperties);
        }
    }

    public void updateCollectionMembership(String userId, String collectionGUID, boolean replaceAllProperties, CollectionMembershipProperties membershipProperties, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateCollectionMembership";
        String collectionGUIDParameterName = "collectionGUID";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateCollectionMembership");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "updateCollectionMembership");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "updateCollectionMembership");
        String relationshipGUID = this.getMembershipRelationshipGUID(userId, collectionGUID, elementGUID);
        if (relationshipGUID != null) {
            this.updateCollectionMembership(userId, relationshipGUID, replaceAllProperties, membershipProperties);
        } else {
            this.addToCollection(userId, collectionGUID, membershipProperties, elementGUID);
        }
    }

    private void updateCollectionMembership(String userId, String relationshipGUID, boolean replaceAllProperties, CollectionMembershipProperties membershipProperties) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.openMetadataStoreClient.updateRelatedElementsInStore(userId, relationshipGUID, replaceAllProperties, false, false, this.getElementProperties(membershipProperties), new Date());
    }

    public void removeFromCollection(String userId, String collectionGUID, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeFromCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeFromCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "removeFromCollection");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "removeFromCollection");
        String relationshipGUID = this.getMembershipRelationshipGUID(userId, collectionGUID, elementGUID);
        if (relationshipGUID != null) {
            this.openMetadataStoreClient.deleteRelatedElementsInStore(userId, relationshipGUID, false, false, new Date());
        }
    }

    private ElementProperties getElementProperties(CollectionProperties collectionProperties) {
        if (collectionProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, collectionProperties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, collectionProperties.getName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, collectionProperties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.COLLECTION_TYPE.name, collectionProperties.getCollectionType());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, collectionProperties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, collectionProperties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(DigitalProductProperties digitalProductProperties) {
        if (digitalProductProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.PRODUCT_NAME.name, digitalProductProperties.getProductName());
            if (digitalProductProperties.getProductStatus() != null) {
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PRODUCT_STATUS.name, digitalProductProperties.getProductStatus().getName());
            }
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PRODUCT_TYPE.name, digitalProductProperties.getProductType());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, digitalProductProperties.getDescription());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.INTRODUCTION_DATE.name, digitalProductProperties.getIntroductionDate());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.MATURITY.name, digitalProductProperties.getMaturity());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SERVICE_LIFE.name, digitalProductProperties.getServiceLife());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.CURRENT_VERSION.name, digitalProductProperties.getCurrentVersion());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.NEXT_VERSION_DATE.name, digitalProductProperties.getNextVersionDate());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.WITHDRAW_DATE.name, digitalProductProperties.getWithdrawDate());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, digitalProductProperties.getAdditionalProperties());
            return elementProperties;
        }
        return null;
    }

    private ElementProperties getElementProperties(CollectionMembershipProperties collectionMembershipProperties) {
        if (collectionMembershipProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.MEMBERSHIP_RATIONALE.name, collectionMembershipProperties.getMembershipRationale());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.EXPRESSION.name, collectionMembershipProperties.getExpression());
            if (collectionMembershipProperties.getStatus() != null) {
                elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.MEMBERSHIP_STATUS.name, CollectionMemberStatus.getOpenTypeName(), collectionMembershipProperties.getStatus().getName());
            }
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, "userDefinedStatus", collectionMembershipProperties.getUserDefinedStatus());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.CONFIDENCE.name, collectionMembershipProperties.getConfidence());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, "createdBy", collectionMembershipProperties.getCreatedBy());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD.name, collectionMembershipProperties.getSteward());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, collectionMembershipProperties.getStewardTypeName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, collectionMembershipProperties.getStewardPropertyName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SOURCE.name, collectionMembershipProperties.getSource());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NOTES.name, collectionMembershipProperties.getNotes());
            return elementProperties;
        }
        return null;
    }
}

