/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.digitalservice.api.CollectionsInterface;
import org.odpi.openmetadata.accessservices.digitalservice.client.OpenMetadataBaseClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.mermaid.CollectionMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.converters.CollectionConverter;
import org.odpi.openmetadata.frameworks.openmetadata.converters.CollectionMemberConverter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OrderBy;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionMember;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.CollectionMemberGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionFolderProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.digitalbusiness.DigitalProductProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.resources.ResourceListProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class CollectionsClient
extends OpenMetadataBaseClient
implements CollectionsInterface {
    private final CollectionConverter<CollectionElement> collectionConverter;
    private final Class<CollectionElement> collectionBeanClass = CollectionElement.class;
    private final CollectionMemberConverter<CollectionMember> collectionMemberConverter;
    private final Class<CollectionMember> collectionMemberBeanClass = CollectionMember.class;
    private final boolean forLineage = false;
    private final boolean forDuplicateProcessing = false;

    public CollectionsClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize);
        this.collectionConverter = new CollectionConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
        this.collectionMemberConverter = new CollectionMemberConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
    }

    public CollectionsClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.collectionConverter = new CollectionConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
        this.collectionMemberConverter = new CollectionMemberConverter(this.propertyHelper, AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceName(), serverName);
    }

    public List<CollectionElement> getAttachedCollections(String userId, String parentGUID, String collectionType, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getLinkedCollections";
        String parentGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "getLinkedCollections");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "getLinkedCollections");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getLinkedCollections");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, parentGUID, 1, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<CollectionElement> filteredCollections = new ArrayList<CollectionElement>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                if (!this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement.getElement(), OpenMetadataType.COLLECTION.typeName)) continue;
                CollectionElement collectionElement = (CollectionElement)this.collectionConverter.getNewBean(this.collectionBeanClass, relatedMetadataElement, "getLinkedCollections");
                if (collectionType != null && !collectionType.equals(collectionElement.getProperties().getCollectionType())) continue;
                filteredCollections.add(collectionElement);
            }
            if (!filteredCollections.isEmpty()) {
                return null;
            }
        }
        return null;
    }

    public List<CollectionElement> getClassifiedCollections(String userId, String classificationName, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getClassifiedCollections";
        this.invalidParameterHandler.validateUserId(userId, "getClassifiedCollections");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getClassifiedCollections");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.COLLECTION.typeName, null, null, null, null, this.propertyHelper.getSearchClassifications(classificationName), OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, new Date(), startFrom, pageSize);
        return this.convertCollections(openMetadataElements, null, "getClassifiedCollections");
    }

    private List<CollectionElement> convertCollections(List<OpenMetadataElement> openMetadataElements, String classificationName, String methodName) throws PropertyServerException {
        if (openMetadataElements != null) {
            ArrayList<CollectionElement> collectionElements = new ArrayList<CollectionElement>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                if (classificationName == null) {
                    collectionElements.add((CollectionElement)this.collectionConverter.getNewBean(this.collectionBeanClass, openMetadataElement, methodName));
                    continue;
                }
                if (openMetadataElement.getClassifications() == null) continue;
                for (AttachedClassification classification : openMetadataElement.getClassifications()) {
                    if (classification == null || !classificationName.equals(classification.getClassificationName())) continue;
                    collectionElements.add((CollectionElement)this.collectionConverter.getNewBean(this.collectionBeanClass, openMetadataElement, methodName));
                }
            }
            return collectionElements;
        }
        return null;
    }

    public List<CollectionElement> findCollections(String userId, String classificationName, String searchString, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "findCollections";
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, "findCollections");
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", "findCollections");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "findCollections");
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElementsWithString(userId, searchString, OpenMetadataType.COLLECTION.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertCollections(openMetadataElements, classificationName, "findCollections");
    }

    public List<CollectionElement> getCollectionsByName(String userId, String classificationName, String name, List<ElementStatus> limitResultsByStatus, Date asOfTime, SequencingOrder sequencingOrder, String sequencingProperty, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionsByName";
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionsByName");
        this.invalidParameterHandler.validateName(name, "name", "getCollectionsByName");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionsByName");
        List<String> propertyNames = Arrays.asList(OpenMetadataProperty.QUALIFIED_NAME.name, OpenMetadataProperty.NAME.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.COLLECTION.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, name, PropertyComparisonOperator.EQ), limitResultsByStatus, asOfTime, this.propertyHelper.getSearchClassifications(classificationName), sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        return this.convertCollections(openMetadataElements, null, "getCollectionsByName");
    }

    public List<CollectionElement> getCollectionsByType(String userId, String classificationName, String collectionType, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionsByType";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionsByType");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionsByType");
        List<String> propertyNames = List.of(OpenMetadataProperty.COLLECTION_TYPE.name);
        List openMetadataElements = this.openMetadataStoreClient.findMetadataElements(userId, OpenMetadataType.COLLECTION.typeName, null, this.propertyHelper.getSearchPropertiesByName(propertyNames, collectionType, PropertyComparisonOperator.EQ), null, null, this.propertyHelper.getSearchClassifications(classificationName), OpenMetadataProperty.QUALIFIED_NAME.name, SequencingOrder.PROPERTY_ASCENDING, false, false, new Date(), startFrom, pageSize);
        return this.convertCollections(openMetadataElements, null, "getCollectionsByType");
    }

    public CollectionElement getCollection(String userId, String collectionGUID, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollection";
        String guidParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollection");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, collectionGUID, false, false, null, new Date());
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.COLLECTION.typeName)) {
            return (CollectionElement)this.collectionConverter.getNewBean(this.collectionBeanClass, openMetadataElement, "getCollection");
        }
        return null;
    }

    public String createCollection(String userId, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, String optionalClassification, CollectionProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createCollection";
        String collectionPropertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createCollection");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "createCollection");
        this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "createCollection");
        String collectionTypeName = OpenMetadataType.COLLECTION.typeName;
        if (properties.getTypeName() != null) {
            collectionTypeName = properties.getTypeName();
        }
        HashMap<String, ElementProperties> initialClassifications = null;
        if (OpenMetadataType.FOLDER.typeName.equals(optionalClassification)) {
            initialClassifications = new HashMap<String, ElementProperties>();
            ElementProperties classificationProperties = null;
            if (properties instanceof CollectionFolderProperties) {
                CollectionFolderProperties collectionFolderProperties = (CollectionFolderProperties)properties;
                classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ORDER_BY_PROPERTY_NAME.name, collectionFolderProperties.getOrderByPropertyName());
                if (collectionFolderProperties.getCollectionOrder() != null) {
                    classificationProperties = this.propertyHelper.addEnumProperty(classificationProperties, OpenMetadataProperty.COLLECTION_ORDER.name, OrderBy.getOpenTypeName(), collectionFolderProperties.getCollectionOrder().getName());
                }
            }
            initialClassifications.put(OpenMetadataType.FOLDER.typeName, classificationProperties);
        } else if (optionalClassification != null) {
            initialClassifications = new HashMap();
            initialClassifications.put(optionalClassification, null);
        }
        return this.openMetadataStoreClient.createMetadataElementInStore(userId, null, null, collectionTypeName, ElementStatus.ACTIVE, initialClassifications, anchorGUID, isOwnAnchor, anchorScopeGUID, properties.getEffectiveFrom(), properties.getEffectiveTo(), this.getElementProperties(properties), parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, false, false, effectiveTime);
    }

    public String createCollectionFromTemplate(String userId, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataStoreClient.createMetadataElementFromTemplate(userId, OpenMetadataType.COLLECTION.typeName, anchorGUID, isOwnAnchor, anchorScopeGUID, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, false, false, effectiveTime);
    }

    public String createDigitalProduct(String userId, String anchorGUID, boolean isOwnAnchor, String anchorScopeGUID, CollectionProperties collectionProperties, DigitalProductProperties digitalProductProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createDigitalProduct";
        this.invalidParameterHandler.validateUserId(userId, "createDigitalProduct");
        String collectionGUID = this.createCollection(userId, anchorGUID, isOwnAnchor, anchorScopeGUID, null, collectionProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1, effectiveTime);
        if (collectionGUID != null) {
            this.openMetadataStoreClient.classifyMetadataElementInStore(userId, collectionGUID, OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION.typeName, false, false, digitalProductProperties.getEffectiveFrom(), digitalProductProperties.getEffectiveTo(), this.getElementProperties(digitalProductProperties), effectiveTime);
        }
        return collectionGUID;
    }

    public void updateCollection(String userId, String collectionGUID, boolean replaceAllProperties, CollectionProperties properties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateCollection";
        String collectionPropertiesName = "properties";
        String qualifiedNameParameterName = "properties.qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateCollection");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateCollection");
        if (replaceAllProperties) {
            this.invalidParameterHandler.validateName(properties.getQualifiedName(), "properties.qualifiedName", "updateCollection");
        }
        this.openMetadataStoreClient.updateMetadataElementInStore(userId, collectionGUID, replaceAllProperties, false, false, this.getElementProperties(properties), effectiveTime);
    }

    public void updateDigitalProduct(String userId, String collectionGUID, boolean replaceAllProperties, DigitalProductProperties properties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateDigitalProduct";
        String propertiesName = "properties";
        this.invalidParameterHandler.validateUserId(userId, "updateDigitalProduct");
        this.invalidParameterHandler.validateObject((Object)properties, "properties", "updateDigitalProduct");
        this.openMetadataStoreClient.reclassifyMetadataElementInStore(userId, collectionGUID, OpenMetadataType.DIGITAL_PRODUCT_CLASSIFICATION.typeName, replaceAllProperties, false, false, this.getElementProperties(properties), new Date());
    }

    public void attachCollection(String userId, String collectionGUID, String parentGUID, ResourceListProperties collectionUse, boolean makeAnchor, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataElement parent;
        String methodName = "attachCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String parentGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "attachCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "attachCollection");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "attachCollection");
        ElementProperties properties = null;
        if (collectionUse != null) {
            properties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.RESOURCE_USE.name, collectionUse.getResourceUse());
            properties = this.propertyHelper.addStringProperty(properties, OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name, collectionUse.getResourceUse());
            properties = this.propertyHelper.addStringMapProperty(properties, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, collectionUse.getResourceUseProperties());
            properties = this.propertyHelper.addBooleanProperty(properties, OpenMetadataProperty.WATCH_RESOURCE.name, collectionUse.getWatchResource());
        }
        this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, parentGUID, collectionGUID, false, false, null, null, properties, new Date());
        if (makeAnchor && (parent = this.openMetadataStoreClient.getMetadataElementByGUID(userId, parentGUID, false, false, null, effectiveTime)) != null) {
            ElementProperties classificationProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ANCHOR_GUID.name, parent.getElementGUID());
            classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, parent.getType().getTypeName());
            classificationProperties = this.propertyHelper.addStringProperty(classificationProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, this.propertyHelper.getDomainName((ElementControlHeader)parent));
            this.openMetadataStoreClient.classifyMetadataElementInStore(userId, collectionGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, false, false, null, null, classificationProperties, new Date());
        }
    }

    public void detachCollection(String userId, String collectionGUID, String parentGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "detachCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String parentGUIDParameterName = "parentGUID";
        this.invalidParameterHandler.validateUserId(userId, "detachCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "detachCollection");
        this.invalidParameterHandler.validateGUID(parentGUID, "parentGUID", "detachCollection");
        this.openMetadataStoreClient.deleteRelationshipInStore(userId, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, parentGUID, collectionGUID, false, false, new Date());
    }

    public void deleteCollection(String userId, String collectionGUID, boolean cascadedDelete) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "deleteCollection";
        String collectionGUIDParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "deleteCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "deleteCollection");
        this.openMetadataStoreClient.deleteMetadataElementInStore(userId, collectionGUID, cascadedDelete, false, false, new Date());
    }

    public List<CollectionMember> getCollectionMembers(String userId, String collectionGUID, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionMembers";
        String collectionGUIDParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionMembers");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollectionMembers");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionMembers");
        RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, collectionGUID, 1, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            ArrayList<CollectionMember> collectionMembers = new ArrayList<CollectionMember>();
            for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                collectionMembers.add((CollectionMember)this.collectionMemberConverter.getNewBean(this.collectionMemberBeanClass, relatedMetadataElement, "getCollectionMembers"));
            }
            if (!collectionMembers.isEmpty()) {
                return collectionMembers;
            }
        }
        return null;
    }

    public CollectionGraph getCollectionGraph(String userId, String collectionGUID, List<ElementStatus> limitResultsByStatus, Date asOfTime, String sequencingProperty, SequencingOrder sequencingOrder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getCollectionGraph";
        String collectionGUIDParameterName = "collectionGUID";
        this.invalidParameterHandler.validateUserId(userId, "getCollectionGraph");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "getCollectionGraph");
        this.invalidParameterHandler.validatePaging(startFrom, pageSize, "getCollectionGraph");
        OpenMetadataElement openMetadataElement = this.openMetadataStoreClient.getMetadataElementByGUID(userId, collectionGUID, false, false, null, new Date());
        if (openMetadataElement != null && this.propertyHelper.isTypeOf((ElementControlHeader)openMetadataElement, OpenMetadataType.COLLECTION.typeName)) {
            RelatedMetadataElementList linkedResources = this.openMetadataStoreClient.getRelatedMetadataElements(userId, collectionGUID, 0, null, limitResultsByStatus, asOfTime, sequencingProperty, sequencingOrder, forLineage, forDuplicateProcessing, effectiveTime, startFrom, pageSize);
            ArrayList<CollectionMemberGraph> collectionMembers = new ArrayList<CollectionMemberGraph>();
            ArrayList<RelatedMetadataElement> otherRelatedElements = new ArrayList<RelatedMetadataElement>();
            if (linkedResources != null && linkedResources.getElementList() != null) {
                for (RelatedMetadataElement relatedMetadataElement : linkedResources.getElementList()) {
                    if (this.propertyHelper.isTypeOf((ElementControlHeader)relatedMetadataElement, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName) && !relatedMetadataElement.getElementAtEnd1()) {
                        collectionMembers.add(this.convertCollectionMemberGraph(userId, relatedMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, "getCollectionGraph"));
                        continue;
                    }
                    otherRelatedElements.add(relatedMetadataElement);
                }
                if (collectionMembers.isEmpty()) {
                    collectionMembers = null;
                }
            }
            CollectionGraph collectionGraph = new CollectionGraph((CollectionElement)this.collectionConverter.getNewComplexBean(this.collectionBeanClass, openMetadataElement, otherRelatedElements, "getCollectionGraph"));
            collectionGraph.setCollectionMemberGraphs(collectionMembers);
            CollectionMermaidGraphBuilder graphBuilder = new CollectionMermaidGraphBuilder(collectionGraph);
            collectionGraph.setMermaidGraph(graphBuilder.getMermaidGraph());
            return collectionGraph;
        }
        return null;
    }

    private CollectionMemberGraph convertCollectionMemberGraph(String userId, RelatedMetadataElement startingMetadataElement, Date asOfTime, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (startingMetadataElement != null) {
            RelatedMetadataElementList linkedMembers;
            CollectionMemberGraph collectionMemberGraph = new CollectionMemberGraph((CollectionMember)this.collectionMemberConverter.getNewBean(CollectionMember.class, startingMetadataElement, methodName));
            if (this.propertyHelper.isTypeOf((ElementControlHeader)startingMetadataElement.getElement(), OpenMetadataType.COLLECTION.typeName) && (linkedMembers = this.openMetadataStoreClient.getRelatedMetadataElements(userId, startingMetadataElement.getElement().getElementGUID(), 1, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, null, asOfTime, null, SequencingOrder.CREATION_DATE_RECENT, forLineage, forDuplicateProcessing, effectiveTime, 0, this.invalidParameterHandler.getMaxPagingSize())) != null && linkedMembers.getElementList() != null) {
                ArrayList<CollectionMemberGraph> collectionMembers = new ArrayList<CollectionMemberGraph>();
                for (RelatedMetadataElement relatedMetadataElement : linkedMembers.getElementList()) {
                    collectionMembers.add(this.convertCollectionMemberGraph(userId, relatedMetadataElement, asOfTime, forLineage, forDuplicateProcessing, effectiveTime, methodName));
                }
                collectionMemberGraph.setNestedMembers(collectionMembers);
            }
            return collectionMemberGraph;
        }
        return null;
    }

    private String getMembershipRelationshipGUID(String userId, String collectionGUID, String elementGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataRelationshipList linkedResources = this.openMetadataStoreClient.getMetadataElementRelationships(userId, collectionGUID, elementGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, null, null, null, null, false, false, new Date(), 0, 0);
        if (linkedResources != null && linkedResources.getElementList() != null) {
            for (OpenMetadataRelationship relatedMetadataElement : linkedResources.getElementList()) {
                if (relatedMetadataElement == null) continue;
                return relatedMetadataElement.getRelationshipGUID();
            }
        }
        return null;
    }

    public void addToCollection(String userId, String collectionGUID, CollectionMembershipProperties membershipProperties, String elementGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "addToCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "addToCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "addToCollection");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "addToCollection");
        String relationshipGUID = this.getMembershipRelationshipGUID(userId, collectionGUID, elementGUID);
        if (relationshipGUID == null) {
            this.openMetadataStoreClient.createRelatedElementsInStore(userId, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, collectionGUID, elementGUID, false, false, null, null, this.getElementProperties(membershipProperties), effectiveTime);
        } else {
            this.updateCollectionMembership(userId, relationshipGUID, true, membershipProperties, effectiveTime);
        }
    }

    public void updateCollectionMembership(String userId, String collectionGUID, boolean replaceAllProperties, CollectionMembershipProperties membershipProperties, String elementGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "updateCollectionMembership";
        String collectionGUIDParameterName = "collectionGUID";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "updateCollectionMembership");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "updateCollectionMembership");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "updateCollectionMembership");
        String relationshipGUID = this.getMembershipRelationshipGUID(userId, collectionGUID, elementGUID);
        if (relationshipGUID != null) {
            this.updateCollectionMembership(userId, relationshipGUID, replaceAllProperties, membershipProperties, effectiveTime);
        } else {
            this.addToCollection(userId, collectionGUID, membershipProperties, elementGUID, effectiveTime);
        }
    }

    private void updateCollectionMembership(String userId, String relationshipGUID, boolean replaceAllProperties, CollectionMembershipProperties membershipProperties, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.openMetadataStoreClient.updateRelationshipInStore(userId, relationshipGUID, replaceAllProperties, false, false, this.getElementProperties(membershipProperties), effectiveTime);
    }

    public void removeFromCollection(String userId, String collectionGUID, String elementGUID, Date effectiveTime) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "removeFromCollection";
        String collectionGUIDParameterName = "collectionGUID";
        String elementGUIDParameterName = "elementGUID";
        this.invalidParameterHandler.validateUserId(userId, "removeFromCollection");
        this.invalidParameterHandler.validateGUID(collectionGUID, "collectionGUID", "removeFromCollection");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "removeFromCollection");
        String relationshipGUID = this.getMembershipRelationshipGUID(userId, collectionGUID, elementGUID);
        if (relationshipGUID != null) {
            this.openMetadataStoreClient.deleteRelationshipInStore(userId, relationshipGUID, false, false, effectiveTime);
        }
    }
}

