/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.client;

import org.odpi.openmetadata.accessservices.digitalservice.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CollectionMemberStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionMembershipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.collections.CollectionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.digitalbusiness.DigitalProductProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public abstract class OpenMetadataBaseClient {
    protected final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected final OpenMetadataStoreClient openMetadataStoreClient;

    public OpenMetadataBaseClient(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    public OpenMetadataBaseClient(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
    }

    protected ElementProperties getElementProperties(CollectionProperties collectionProperties) {
        if (collectionProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, collectionProperties.getQualifiedName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NAME.name, collectionProperties.getName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, collectionProperties.getDescription());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.COLLECTION_TYPE.name, collectionProperties.getCollectionType());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, collectionProperties.getAdditionalProperties());
            elementProperties = this.propertyHelper.addPropertyMap(elementProperties, collectionProperties.getExtendedProperties());
            return elementProperties;
        }
        return null;
    }

    protected ElementProperties getElementProperties(DigitalProductProperties digitalProductProperties) {
        if (digitalProductProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.PRODUCT_NAME.name, digitalProductProperties.getProductName());
            if (digitalProductProperties.getProductStatus() != null) {
                elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PRODUCT_STATUS.name, digitalProductProperties.getProductStatus().getName());
            }
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.PRODUCT_TYPE.name, digitalProductProperties.getProductType());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.DESCRIPTION.name, digitalProductProperties.getDescription());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.INTRODUCTION_DATE.name, digitalProductProperties.getIntroductionDate());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.MATURITY.name, digitalProductProperties.getMaturity());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SERVICE_LIFE.name, digitalProductProperties.getServiceLife());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.CURRENT_VERSION.name, digitalProductProperties.getCurrentVersion());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.NEXT_VERSION_DATE.name, digitalProductProperties.getNextVersionDate());
            elementProperties = this.propertyHelper.addDateProperty(elementProperties, OpenMetadataProperty.WITHDRAW_DATE.name, digitalProductProperties.getWithdrawDate());
            elementProperties = this.propertyHelper.addStringMapProperty(elementProperties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, digitalProductProperties.getAdditionalProperties());
            return elementProperties;
        }
        return null;
    }

    protected ElementProperties getElementProperties(CollectionMembershipProperties collectionMembershipProperties) {
        if (collectionMembershipProperties != null) {
            ElementProperties elementProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.MEMBERSHIP_RATIONALE.name, collectionMembershipProperties.getMembershipRationale());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.EXPRESSION.name, collectionMembershipProperties.getExpression());
            if (collectionMembershipProperties.getStatus() != null) {
                elementProperties = this.propertyHelper.addEnumProperty(elementProperties, OpenMetadataProperty.MEMBERSHIP_STATUS.name, CollectionMemberStatus.getOpenTypeName(), collectionMembershipProperties.getStatus().getName());
            }
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.USER_DEFINED_STATUS.name, collectionMembershipProperties.getUserDefinedStatus());
            elementProperties = this.propertyHelper.addIntProperty(elementProperties, OpenMetadataProperty.CONFIDENCE.name, collectionMembershipProperties.getConfidence());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD.name, collectionMembershipProperties.getSteward());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, collectionMembershipProperties.getStewardTypeName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, collectionMembershipProperties.getStewardPropertyName());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.SOURCE.name, collectionMembershipProperties.getSource());
            elementProperties = this.propertyHelper.addStringProperty(elementProperties, OpenMetadataProperty.NOTES.name, collectionMembershipProperties.getNotes());
            return elementProperties;
        }
        return null;
    }
}

