/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.builders;

import java.util.Collections;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.builders.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DigitalServiceBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private String versionNumber = null;

    public DigitalServiceBuilder(String qualifiedName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, repositoryHelper, serviceName, serverName);
    }

    public DigitalServiceBuilder(String displayName, String description, String versionNumer, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super("", Collections.emptyMap(), Collections.emptyMap(), repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.versionNumber = this.versionNumber;
    }

    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        if (this.displayName != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "displayName", this.displayName, methodName);
        }
        if (this.description != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "description", this.description, methodName);
        }
        if (this.versionNumber != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, "versionNumber", this.versionNumber, methodName);
        }
        return properties;
    }

    public InstanceProperties getClassificationInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = null;
        return properties;
    }
}

