/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.server;

import org.odpi.openmetadata.accessservices.digitalservice.handlers.DigitalServiceEntityHandler;
import org.odpi.openmetadata.accessservices.digitalservice.properties.DigitalService;
import org.odpi.openmetadata.accessservices.digitalservice.rest.DigitalServiceRequestBody;
import org.odpi.openmetadata.accessservices.digitalservice.server.DigitalServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitalServiceRESTServices {
    private static DigitalServiceInstanceHandler instanceHandler = new DigitalServiceInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(DigitalServiceRESTServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDigitalService(String userId, String serverName, DigitalServiceRequestBody digitalServiceRequestBody) {
        String methodName = "createDigitalService";
        GUIDResponse response = new GUIDResponse();
        try {
            if (digitalServiceRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDigitalService", serverName);
                return response;
            }
            DigitalServiceEntityHandler handler = instanceHandler.getDigitalServiceEntityHandler(userId, serverName, "createDigitalService");
            DigitalService digitalService = digitalServiceRequestBody.getDigitalService();
            response.setGUID(handler.createDigitalServiceEntity(userId, serverName, digitalService));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDigitalService");
        }
        log.debug("Returning from method: {1} with response: {2}", (Object)"createDigitalService", (Object)response.toString());
        return response;
    }
}

