/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.server;

import org.odpi.openmetadata.accessservices.digitalservice.handlers.DigitalServiceEntityHandler;
import org.odpi.openmetadata.accessservices.digitalservice.properties.DigitalService;
import org.odpi.openmetadata.accessservices.digitalservice.rest.DigitalServiceRequestBody;
import org.odpi.openmetadata.accessservices.digitalservice.server.DigitalServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.slf4j.LoggerFactory;

public class DigitalServiceRESTServices {
    private static DigitalServiceInstanceHandler instanceHandler = new DigitalServiceInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DigitalServiceRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDigitalService(String userId, String serverName, DigitalServiceRequestBody digitalServiceRequestBody) {
        String methodName = "createDigitalService";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "createDigitalService");
        GUIDResponse response = new GUIDResponse();
        try {
            if (digitalServiceRequestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDigitalService", serverName);
                return response;
            }
            DigitalServiceEntityHandler handler = instanceHandler.getDigitalServiceEntityHandler(userId, serverName, "createDigitalService");
            DigitalService digitalService = digitalServiceRequestBody.getDigitalService();
            response.setGUID(handler.createDigitalServiceEntity(userId, serverName, digitalService));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "createDigitalService");
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

