/* SPDX-License-Identifier: Apache 2.0 */
/* Copyright Contributors to the ODPi Egeria project. */
package org.odpi.openmetadata.accessservices.digitalservice.mappers;

/**
 * DigitlaServiceMapper provides property name mapping for Egeria Digital Service.
 * No actual mapping taking place, just included for readability.
 */
public class DigitalServiceMapper
{
    /* Referenceable property names*/
    public static final String DIGITAL_SERVICE_ENTITY_TYPE_GUID          = "f671e1fc-b204-4ee6-a4e2-da1633ecf50e";
    public static final String DIGITAL_SERVICE_ENTITY_TYPE_NAME          = "DigitalService";
    public static final String ADDITIONAL_PROPERTIES_PROPERTY_NAME       = "additionalProperties";

    /* entity property names */
    public static final String DISPLAY_NAME_PROPERTY_NAME                = "displayName";                         /* from DigitalService entity */
    public static final String DESCRIPTION_PROPERTY_NAME                 = "description";                          /* from DigitalService entity */
    public static final String DIGITAL_SERVICE_VERSION_NUMER             = "versionNumber";
    public static final String IMPLEMENTATION_STYLE_PROPERTY_NAME        = "implementationStyle";                  /* from DigitalService entity */
    public static final String STATUS_PROPERTY_NAME                      = "status";                               /* from DigitalService entity */
    public static final String VISIBILTY_PROPERTY_NAME                   = "visibility";                           /* from DigitalService entity */
    public static final String RESPONSIBILITY_PROPERTY_NAME              = "responsibility";                       /* from DigitalService entity */

    public static final String DIGITAL_SERVICE_CLASSIFICATION_TYPE_GUID      = "cad5da1b-cfb3-4fca-857b-c07711fc4157";
    public static final String DIGITAL_SERVICE_CLASSIFICATION_TYPE_NAME      = "DigitalService";
    public static final String SERVICE_NAME = "DigitalService";
}
