/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.handlers;

import org.odpi.openmetadata.accessservices.digitalservice.builders.DigitalServiceBuilder;
import org.odpi.openmetadata.accessservices.digitalservice.properties.DigitalService;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DigitalServiceEntityHandler {
    private OMRSRepositoryHelper repositoryHelper;
    private RepositoryHandler repositoryHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public DigitalServiceEntityHandler(OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, InvalidParameterHandler invalidParameterHandler) {
        this.repositoryHelper = repositoryHelper;
        this.repositoryHandler = repositoryHandler;
        this.invalidParameterHandler = invalidParameterHandler;
    }

    public String createDigitalServiceEntity(String userId, String serverName, DigitalService digitalService) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        String methodName = "createDigitalServiceEntity";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        DigitalServiceBuilder digitalServiceBuilder = new DigitalServiceBuilder(digitalService.getDisplayName(), digitalService.getDescription(), digitalService.getVersion(), this.repositoryHelper, "DigitalService", serverName);
        return this.repositoryHandler.createEntity(userId, "f671e1fc-b204-4ee6-a4e2-da1633ecf50e", "DigitalService", null, null, digitalServiceBuilder.getInstanceProperties(methodName), null, InstanceStatus.ACTIVE, methodName);
    }
}

