/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.admin;

import java.util.List;
import org.odpi.openmetadata.accessservices.digitalservice.ffdc.DigitalServiceAuditCode;
import org.odpi.openmetadata.accessservices.digitalservice.listener.DigitalServiceOMRSTopicListener;
import org.odpi.openmetadata.accessservices.digitalservice.server.DigitalServiceServicesInstance;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.registration.AccessServiceAdmin;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.omrstopic.OMRSTopicListener;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryConnector;

public class DigitalServiceAdmin
extends AccessServiceAdmin {
    private AuditLog auditLog = null;
    private DigitalServiceServicesInstance instance = null;
    private String serverName = null;

    public void initialize(AccessServiceConfig accessServiceConfig, OMRSTopicConnector omrsTopicConnector, OMRSRepositoryConnector repositoryConnector, AuditLog auditLog, String serverUserName) throws OMAGConfigurationErrorException {
        String actionDescription = "initialize";
        auditLog.logMessage("initialize", DigitalServiceAuditCode.SERVICE_INITIALIZING.getMessageDefinition());
        this.auditLog = auditLog;
        try {
            List supportedZones = this.extractSupportedZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List defaultZones = this.extractDefaultZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            List publishZones = this.extractPublishZones(accessServiceConfig.getAccessServiceOptions(), accessServiceConfig.getAccessServiceName(), auditLog);
            this.instance = new DigitalServiceServicesInstance(repositoryConnector, supportedZones, defaultZones, publishZones, auditLog, serverUserName, repositoryConnector.getMaxPageSize(), accessServiceConfig.getAccessServiceOutTopic());
            this.serverName = this.instance.getServerName();
            if (accessServiceConfig.getAccessServiceOutTopic() != null) {
                DigitalServiceOMRSTopicListener omrsTopicListener = new DigitalServiceOMRSTopicListener(accessServiceConfig.getAccessServiceOutTopic(), repositoryConnector.getRepositoryHelper(), repositoryConnector.getRepositoryValidator(), accessServiceConfig.getAccessServiceName(), supportedZones, auditLog);
                super.registerWithEnterpriseTopic(accessServiceConfig.getAccessServiceName(), this.serverName, omrsTopicConnector, (OMRSTopicListener)omrsTopicListener, auditLog);
            }
            auditLog.logMessage("initialize", DigitalServiceAuditCode.SERVICE_INITIALIZED.getMessageDefinition(new String[]{this.serverName}), accessServiceConfig.toString());
        }
        catch (OMAGConfigurationErrorException error) {
            throw error;
        }
        catch (Exception error) {
            auditLog.logException("initialize", DigitalServiceAuditCode.SERVICE_INSTANCE_FAILURE.getMessageDefinition(new String[]{error.getMessage()}), accessServiceConfig.toString(), (Throwable)error);
            super.throwUnexpectedInitializationException("initialize", AccessServiceDescription.DIGITAL_SERVICE_OMAS.getAccessServiceFullName(), (Throwable)error);
        }
    }

    public void shutdown() {
        String actionDescription = "shutdown";
        if (this.instance != null) {
            this.instance.shutdown();
        }
        this.auditLog.logMessage("shutdown", DigitalServiceAuditCode.SERVICE_SHUTDOWN.getMessageDefinition(new String[]{this.serverName}));
    }
}

