/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.digitalservice.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.accessservices.digitalservice.server.DigitalServiceRESTServices;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/open-metadata/access-services/digital-service/users/{userId}"})
@Tag(name="Metadata Access Server: Digital Service OMAS", description="The Digital Service OMAS provides services to aid the integration of tools involved in tracking the life cycle of an Egeria Digital Service", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omas/digital-service/overview/"))
public class DigitalServiceResource {
    private final DigitalServiceRESTServices restAPI = new DigitalServiceRESTServices();

    @GetMapping(path={"/description"})
    public RegisteredOMAGServiceResponse getServiceDescription(@PathVariable String serverName, @PathVariable String userId) {
        return this.restAPI.getServiceDescription(serverName, userId);
    }
}

