/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dino.api.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationSummary;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.platformservices.properties.ServerStatus;
import org.odpi.openmetadata.viewservices.dino.api.properties.ServerCohortDetails;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ServerOverview {
    private static final long serialVersionUID = 1L;
    private String serverInstanceName;
    private String serverName;
    private String platformRootURL;
    private String description;
    private String serverOrigin;
    private ServerTypeClassificationSummary serverClassification;
    private boolean isActive;
    private Map<String, ServerCohortDetails> cohortDetails;
    private ServerStatus serverStatus;
    private List<RegisteredOMAGService> integrationServices;
    private List<RegisteredOMAGService> engineServices;
    private List<RegisteredOMAGService> accessServices;
    private List<RegisteredOMAGService> viewServices;

    public ServerOverview() {
    }

    public ServerOverview(String serverInstanceName, String serverName, String description, String platformRootURL, String serverOrigin, ServerTypeClassificationSummary serverClassification, boolean isActive, Map<String, ServerCohortDetails> cohortDetails, ServerStatus serverStatus, List<RegisteredOMAGService> integrationServices, List<RegisteredOMAGService> engineServices, List<RegisteredOMAGService> accessServices, List<RegisteredOMAGService> viewServices) {
        this.serverInstanceName = serverInstanceName;
        this.serverName = serverName;
        this.description = description;
        this.platformRootURL = platformRootURL;
        this.serverOrigin = serverOrigin;
        this.serverClassification = serverClassification;
        this.isActive = isActive;
        this.cohortDetails = cohortDetails;
        this.serverStatus = serverStatus;
        this.integrationServices = integrationServices;
        this.engineServices = engineServices;
        this.accessServices = accessServices;
        this.viewServices = viewServices;
    }

    public ServerOverview(ResourceEndpointConfig cfg) {
        this.serverInstanceName = cfg.getServerInstanceName();
        this.serverName = cfg.getServerName();
        this.description = cfg.getDescription();
        this.platformRootURL = cfg.getPlatformRootURL();
    }

    public String getServerInstanceName() {
        return this.serverInstanceName;
    }

    public void setServerInstanceName(String serverInstanceName) {
        this.serverInstanceName = serverInstanceName;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPlatformRootURL() {
        return this.platformRootURL;
    }

    public void setPlatformRootURL(String platformRootURL) {
        this.platformRootURL = platformRootURL;
    }

    public String getServerOrigin() {
        return this.serverOrigin;
    }

    public void setServerOrigin(String serverOrigin) {
        this.serverOrigin = serverOrigin;
    }

    public ServerTypeClassificationSummary getServerClassification() {
        return this.serverClassification;
    }

    public void setServerClassification(ServerTypeClassificationSummary serverClassification) {
        this.serverClassification = serverClassification;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public Map<String, ServerCohortDetails> getCohortDetails() {
        return this.cohortDetails;
    }

    public void setCohortDetails(Map<String, ServerCohortDetails> cohortDetails) {
        this.cohortDetails = cohortDetails;
    }

    public ServerStatus getServerStatus() {
        return this.serverStatus;
    }

    public void setServerStatus(ServerStatus serverStatus) {
        this.serverStatus = serverStatus;
    }

    public List<RegisteredOMAGService> getIntegrationServices() {
        return this.integrationServices;
    }

    public void setIntegrationServices(List<RegisteredOMAGService> integrationServices) {
        this.integrationServices = integrationServices;
    }

    public List<RegisteredOMAGService> getEngineServices() {
        return this.engineServices;
    }

    public void setEngineServices(List<RegisteredOMAGService> engineServices) {
        this.engineServices = engineServices;
    }

    public List<RegisteredOMAGService> getAccessServices() {
        return this.accessServices;
    }

    public void setAccessServices(List<RegisteredOMAGService> accessServices) {
        this.accessServices = accessServices;
    }

    public List<RegisteredOMAGService> getViewServices() {
        return this.viewServices;
    }

    public void setViewServices(List<RegisteredOMAGService> viewServices) {
        this.viewServices = viewServices;
    }

    public String toString() {
        return "ServerOverview{, description='" + this.description + "', platformRootURL=" + this.platformRootURL + "', serverName=" + this.serverName + "', serverInstanceName=" + this.serverInstanceName + "', serverOrigin=" + this.serverOrigin + "', serverClassification=" + this.serverClassification + "', isActive=" + this.isActive + "', cohortDetails=" + this.cohortDetails + "', serverStatus=" + this.serverStatus + "', integrationServices=" + this.integrationServices + "', engineServices=" + this.engineServices + "', accessServices=" + this.accessServices + "', viewServices=" + this.viewServices + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ServerOverview that = (ServerOverview)objectToCompare;
        return Objects.equals(this.getServerInstanceName(), that.getServerInstanceName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getPlatformRootURL(), that.getPlatformRootURL()) && Objects.equals(this.getServerName(), that.getServerName()) && Objects.equals(this.getServerOrigin(), that.getServerOrigin()) && Objects.equals(this.getIsActive(), that.getIsActive()) && Objects.equals(this.getCohortDetails(), that.getCohortDetails()) && Objects.equals(this.getIntegrationServices(), that.getIntegrationServices()) && Objects.equals(this.getEngineServices(), that.getEngineServices()) && Objects.equals(this.getAccessServices(), that.getAccessServices()) && Objects.equals(this.getViewServices(), that.getViewServices()) && Objects.equals(this.getServerStatus(), that.getServerStatus());
    }

    public int hashCode() {
        return Objects.hash(this.getServerInstanceName(), this.getDescription(), this.getPlatformRootURL(), this.getServerName(), this.getServerOrigin(), this.getIsActive(), this.getCohortDetails(), this.getServerStatus(), this.getIntegrationServices(), this.getAccessServices(), this.getViewServices(), this.getEngineServices());
    }
}

