/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dino.api.ffdc;

import java.net.ConnectException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoViewErrorCode;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoViewServiceException;

public class DinoExceptionHandler {
    public static void captureCheckedException(FFDCResponse response, OCFCheckedExceptionBase error, String exceptionClassName) {
        response.setRelatedHTTPCode(error.getReportedHTTPCode());
        response.setExceptionClassName(exceptionClassName);
        if (error.getReportedCaughtException() != null) {
            response.setExceptionCausedBy(error.getReportedCaughtException().getClass().getName());
        }
        response.setActionDescription(error.getReportingActionDescription());
        String fullErrorMessage = error.getReportedErrorMessage();
        String errorMessageId = error.getReportedErrorMessageId();
        String trimmedErrorMessage = fullErrorMessage.substring(errorMessageId.length() + 1);
        response.setExceptionErrorMessage(trimmedErrorMessage);
        response.setExceptionErrorMessageId(error.getReportedErrorMessageId());
        response.setExceptionErrorMessageParameters(error.getReportedErrorMessageParameters());
        response.setExceptionSystemAction(error.getReportedSystemAction());
        response.setExceptionUserAction(error.getReportedUserAction());
        response.setExceptionProperties(null);
    }

    public static DinoViewServiceException mapOMRSUserNotAuthorizedException(String className, String methodName, org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException repositoryException) {
        String userId = repositoryException.getUserId();
        return new DinoViewServiceException(DinoViewErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(userId), className, methodName);
    }

    public static DinoViewServiceException mapOMRSInvalidParameterException(String className, String methodName, org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException repositoryException) {
        String parameterName = repositoryException.getReportedErrorMessageParameters()[0];
        if (parameterName.equals("searchCriteria")) {
            parameterName = "Search Text";
        }
        return new DinoViewServiceException(DinoViewErrorCode.INVALID_PARAMETER.getMessageDefinition(methodName, parameterName), className, methodName);
    }

    public static DinoViewServiceException mapOCFInvalidParameterException(String className, String methodName, InvalidParameterException ocfException) {
        String ocfMessage = ocfException.getReportedErrorMessage();
        return new DinoViewServiceException(DinoViewErrorCode.INVALID_PARAMETER.getMessageDefinition(methodName, ocfMessage), className, methodName);
    }

    public static DinoViewServiceException mapOCFUserNotAuthorizedException(String className, String methodName, String userName, UserNotAuthorizedException ocfException) {
        return new DinoViewServiceException(DinoViewErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(methodName, userName), className, methodName);
    }

    public static DinoViewServiceException mapOCFPropertyServerException(String className, String methodName, String platformName, PropertyServerException ocfException) {
        String message;
        Exception cause2;
        Exception cause1;
        if (ocfException.getCause() != null && (cause1 = (Exception)ocfException.getCause()).getCause() != null && (cause2 = (Exception)cause1.getCause()).getCause() != null && cause2.getCause() instanceof ConnectException && (message = cause2.getCause().getMessage()).contains("Connection refused")) {
            return new DinoViewServiceException(DinoViewErrorCode.PLATFORM_NOT_AVAILABLE.getMessageDefinition(methodName, platformName), className, methodName);
        }
        String exceptionMessage = ocfException.getReportedErrorMessage();
        return new DinoViewServiceException(DinoViewErrorCode.UNKNOWN_ERROR.getMessageDefinition(methodName, exceptionMessage), className, methodName);
    }

    public static DinoViewServiceException mapOMAGInvalidParameterException(String className, String methodName, OMAGInvalidParameterException omagException) {
        if (omagException != null) {
            String omagMessage = omagException.getReportedErrorMessage();
            return new DinoViewServiceException(DinoViewErrorCode.INVALID_PARAMETER.getMessageDefinition(methodName, omagMessage), className, methodName);
        }
        return new DinoViewServiceException(DinoViewErrorCode.UNKNOWN_ERROR.getMessageDefinition(methodName), className, methodName);
    }

    public static DinoViewServiceException mapOMAGNotAuthorizedException(String className, String methodName, String userName, OMAGNotAuthorizedException omagException) {
        return new DinoViewServiceException(DinoViewErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(methodName, userName), className, methodName);
    }

    public static DinoViewServiceException mapOMAGConfigurationErrorException(String className, String methodName, String serverName, OMAGConfigurationErrorException omagException) {
        return new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_RETRIEVE_SERVER_CONFIGURATION.getMessageDefinition(methodName, serverName), className, methodName);
    }

    public static DinoViewServiceException mapInvalidParameterException(String className, String methodName, InvalidParameterException exception) {
        if (exception != null) {
            String message = exception.getReportedErrorMessage();
            return new DinoViewServiceException(DinoViewErrorCode.INVALID_PARAMETER.getMessageDefinition(methodName, message), className, methodName);
        }
        return new DinoViewServiceException(DinoViewErrorCode.UNKNOWN_ERROR.getMessageDefinition(methodName), className, methodName);
    }

    public static DinoViewServiceException mapUserNotAuthorizedException(String className, String methodName, UserNotAuthorizedException repositoryException) {
        String userId = repositoryException.getUserId();
        return new DinoViewServiceException(DinoViewErrorCode.USER_NOT_AUTHORIZED.getMessageDefinition(userId), className, methodName);
    }
}

