/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dino.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.client.OMAGServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationSummary;
import org.odpi.openmetadata.commonservices.ffdc.OMAGCommonErrorCode;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;
import org.odpi.openmetadata.platformservices.properties.ServerStatus;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogReport;
import org.odpi.openmetadata.repositoryservices.clients.AuditLogServicesClient;
import org.odpi.openmetadata.repositoryservices.clients.MetadataHighwayServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.odpi.openmetadata.viewservices.dino.api.properties.DinoServerInstance;
import org.odpi.openmetadata.viewservices.dino.api.properties.PlatformOverview;
import org.odpi.openmetadata.viewservices.dino.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.dino.api.properties.ServerCohortDetails;
import org.odpi.openmetadata.viewservices.dino.api.properties.ServerOverview;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DinoViewHandler {
    private static final Logger log = LoggerFactory.getLogger(DinoViewHandler.class);
    private Map<String, ResourceEndpoint> configuredPlatforms = null;
    private Map<String, ResourceEndpoint> configuredServerInstances = null;

    public DinoViewHandler(List<ResourceEndpointConfig> resourceEndpoints) {
        if (resourceEndpoints != null && !resourceEndpoints.isEmpty()) {
            this.configuredPlatforms = new HashMap<String, ResourceEndpoint>();
            this.configuredServerInstances = new HashMap<String, ResourceEndpoint>();
            resourceEndpoints.forEach(res -> {
                String resCategory = res.getResourceCategory();
                ResourceEndpoint rep = new ResourceEndpoint(res);
                String resName = null;
                switch (resCategory) {
                    case "Platform": {
                        resName = res.getPlatformName();
                        this.configuredPlatforms.put(resName, rep);
                        break;
                    }
                    case "Server": {
                        resName = res.getServerInstanceName();
                        this.configuredServerInstances.put(resName, rep);
                        break;
                    }
                }
            });
        }
    }

    public Map<String, List<ResourceEndpoint>> getResourceEndpoints(String userId, String methodName) {
        ArrayList<ResourceEndpoint> platformList = new ArrayList<ResourceEndpoint>();
        ArrayList<ResourceEndpoint> serverList = new ArrayList<ResourceEndpoint>();
        platformList.addAll(this.configuredPlatforms.values());
        serverList.addAll(this.configuredServerInstances.values());
        HashMap<String, List<ResourceEndpoint>> returnMap = new HashMap<String, List<ResourceEndpoint>>();
        returnMap.put("platformList", platformList);
        returnMap.put("serverList", serverList);
        return returnMap;
    }

    private String resolvePlatformRootURL(String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        ResourceEndpoint resource;
        String platformRootURL = null;
        if (platformName != null && (resource = this.configuredPlatforms.get(platformName)) != null) {
            platformRootURL = resource.getResourceRootURL();
        }
        if (platformName == null || platformRootURL == null) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException(OMAGCommonErrorCode.VIEW_SERVICE_NULL_PLATFORM_NAME.getMessageDefinition(), this.getClass().getName(), methodName, "platformName");
        }
        return platformRootURL;
    }

    private PlatformServicesClient getPlatformServicesClient(String platformName, String platformRootURL) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        PlatformServicesClient client = new PlatformServicesClient(platformName, platformRootURL);
        return client;
    }

    private OMAGServerConfigurationClient getOMAGServerConfigurationClient(String userId, String serverName, String serverRootURL) throws OMAGInvalidParameterException {
        OMAGServerConfigurationClient client = new OMAGServerConfigurationClient(userId, serverName, serverRootURL);
        return client;
    }

    private MetadataHighwayServicesClient getMetadataHighwayServicesClient(String userId, String serverName, String platformRootURL) throws InvalidParameterException {
        String serverRootURL = platformRootURL + "/servers/" + serverName;
        MetadataHighwayServicesClient client = new MetadataHighwayServicesClient(serverName, serverRootURL);
        return client;
    }

    private AuditLogServicesClient getAuditLogServicesClient(String userId, String serverName, String platformRootURL) throws InvalidParameterException {
        String serverRootURL = platformRootURL + "/servers/" + serverName;
        AuditLogServicesClient client = new AuditLogServicesClient(serverName, serverRootURL);
        return client;
    }

    public PlatformOverview platformGetOverview(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        ResourceEndpoint platformConfig = this.configuredPlatforms.get(platformName);
        PlatformOverview platformOverview = new PlatformOverview();
        platformOverview.setPlatformName(platformConfig.getPlatformName());
        platformOverview.setDescription(platformConfig.getResourceDescription());
        platformOverview.setPlatformRootURL(platformConfig.getResourceRootURL());
        String platformOrigin = platformServicesClient.getPlatformOrigin(userId);
        platformOverview.setPlatformOrigin(platformOrigin);
        List accessServiceList = platformServicesClient.getAccessServices(userId);
        platformOverview.setAccessServices(accessServiceList);
        List commonServiceList = platformServicesClient.getCommonServices(userId);
        platformOverview.setCommonServices(commonServiceList);
        List governanceServiceList = platformServicesClient.getGovernanceServices(userId);
        platformOverview.setGovernanceServices(governanceServiceList);
        List viewServiceList = platformServicesClient.getViewServices(userId);
        platformOverview.setViewServices(viewServiceList);
        return platformOverview;
    }

    public String platformGetOrigin(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        String string = platformServicesClient.getPlatformOrigin(userId);
        return string;
    }

    public List<DinoServerInstance> platformGetActiveServerList(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        List serverNames = platformServicesClient.getActiveServers(userId);
        ArrayList<DinoServerInstance> serverList = new ArrayList<DinoServerInstance>();
        serverNames.forEach(serverName -> {
            DinoServerInstance dinoServerInstance = new DinoServerInstance();
            String configuredInstanceName = null;
            for (ResourceEndpoint csire : this.configuredServerInstances.values()) {
                if (!csire.getServerName().equals(serverName) || !csire.getPlatformName().equals(platformName)) continue;
                configuredInstanceName = csire.getServerInstanceName();
            }
            dinoServerInstance.setServerInstanceName(configuredInstanceName);
            dinoServerInstance.setIsActive(true);
            dinoServerInstance.setServerName(serverName);
            dinoServerInstance.setPlatformName(platformName);
            serverList.add(dinoServerInstance);
        });
        return serverList;
    }

    public List<DinoServerInstance> platformGetKnownServerList(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        List serverNames = platformServicesClient.getKnownServers(userId);
        ArrayList<DinoServerInstance> serverList = new ArrayList<DinoServerInstance>();
        List activeServerNames = platformServicesClient.getActiveServers(userId);
        HashMap serverMap = new HashMap();
        serverNames.forEach(serverName -> {
            DinoServerInstance dinoServerInstance = new DinoServerInstance();
            dinoServerInstance.setServerName(serverName);
            dinoServerInstance.setPlatformName(platformName);
            if (activeServerNames.contains(serverName)) {
                dinoServerInstance.setIsActive(true);
            } else {
                dinoServerInstance.setIsActive(false);
            }
            serverList.add(dinoServerInstance);
        });
        return serverList;
    }

    public List<RegisteredOMAGService> platformGetAccessServiceList(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        ArrayList<RegisteredOMAGService> serviceList = new ArrayList();
        serviceList = platformServicesClient.getAccessServices(userId);
        return serviceList;
    }

    public List<RegisteredOMAGService> platformGetViewServiceList(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        ArrayList<RegisteredOMAGService> serviceList = new ArrayList();
        serviceList = platformServicesClient.getViewServices(userId);
        return serviceList;
    }

    public List<RegisteredOMAGService> platformGetGovernanceServiceList(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        ArrayList<RegisteredOMAGService> serviceList = new ArrayList();
        serviceList = platformServicesClient.getGovernanceServices(userId);
        return serviceList;
    }

    public List<RegisteredOMAGService> platformGetCommonServiceList(String userId, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        ArrayList<RegisteredOMAGService> serviceList = new ArrayList();
        serviceList = platformServicesClient.getCommonServices(userId);
        return serviceList;
    }

    public ServerOverview serverGetOverview(String userId, String serverName, String platformName, String serverInstanceName, String description, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException, RepositoryErrorException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        ServerOverview serverOverview = null;
        Object serverEndpoint = null;
        serverOverview = new ServerOverview();
        serverOverview.setServerName(serverName);
        serverOverview.setPlatformRootURL(platformRootURL);
        if (serverInstanceName != null) {
            serverOverview.setServerInstanceName(serverInstanceName);
        }
        if (description != null) {
            serverOverview.setDescription(description);
        }
        String serverOrigin = platformServicesClient.getPlatformOrigin(userId);
        serverOverview.setServerOrigin(serverOrigin);
        try {
            ServerTypeClassificationSummary serverClassification = this.serverGetTypeClassification(userId, serverName, platformName, methodName);
            serverOverview.setServerClassification(serverClassification);
        }
        catch (OMAGInvalidParameterException exc) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException("Could not retrieve server type classification due to an invalid value for serverName parameter", (OCFCheckedExceptionBase)exc, serverName);
        }
        catch (OMAGNotAuthorizedException exc) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)exc, serverName);
        }
        catch (OMAGConfigurationErrorException exc) {
            throw new PropertyServerException((OCFCheckedExceptionBase)exc);
        }
        ServerStatus serverStatus = platformServicesClient.getServerStatus(userId, serverName);
        serverOverview.setServerStatus(serverStatus);
        List serverList = platformServicesClient.getActiveServices(userId, serverName);
        serverOverview.setServerServicesList(serverList);
        Map<String, ServerCohortDetails> cohortDetails = this.serverGetCohortDetails(userId, serverName, platformName, methodName);
        serverOverview.setCohortDetails(cohortDetails);
        return serverOverview;
    }

    public String serverGetOrigin(String userId, String serverName, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        String string = platformServicesClient.getPlatformOrigin(userId);
        return string;
    }

    public ServerTypeClassificationSummary serverGetTypeClassification(String userId, String serverName, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, OMAGInvalidParameterException, OMAGNotAuthorizedException, OMAGConfigurationErrorException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        OMAGServerConfigurationClient adminServicesClient = this.getOMAGServerConfigurationClient(userId, serverName, platformRootURL);
        ServerTypeClassificationSummary summary = adminServicesClient.getServerClassification();
        return summary;
    }

    public OMAGServerConfig serverGetStoredConfiguration(String userId, String serverName, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        try {
            OMAGServerConfigurationClient adminServicesClient = this.getOMAGServerConfigurationClient(userId, serverName, platformRootURL);
            OMAGServerConfig config = adminServicesClient.getOMAGServerConfig();
            return config;
        }
        catch (OMAGInvalidParameterException exc) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException("Could not retrieve server type classification due to an invalid value for serverName parameter", (OCFCheckedExceptionBase)exc, serverName);
        }
        catch (OMAGNotAuthorizedException exc) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)exc, userId);
        }
        catch (OMAGConfigurationErrorException exc) {
            throw new PropertyServerException((OCFCheckedExceptionBase)exc);
        }
    }

    public OMAGServerConfig serverGetInstanceConfiguration(String userId, String serverName, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        try {
            OMAGServerConfigurationClient adminServicesClient = this.getOMAGServerConfigurationClient(userId, serverName, platformRootURL);
            OMAGServerConfig config = adminServicesClient.getOMAGServerInstanceConfig();
            return config;
        }
        catch (OMAGInvalidParameterException exc) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException("Could not retrieve server type classification due to an invalid value for serverName parameter", (OCFCheckedExceptionBase)exc, serverName);
        }
        catch (OMAGNotAuthorizedException exc) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)exc, userId);
        }
        catch (OMAGConfigurationErrorException exc) {
            throw new PropertyServerException((OCFCheckedExceptionBase)exc);
        }
    }

    public Map<String, ServerCohortDetails> serverGetCohortDetails(String userId, String serverName, String platformName, String methodName) throws org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException, UserNotAuthorizedException {
        HashMap<String, ServerCohortDetails> returnMap = new HashMap<String, ServerCohortDetails>();
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        try {
            MetadataHighwayServicesClient metadataHighwayServicesClient = this.getMetadataHighwayServicesClient(userId, serverName, platformRootURL);
            List cohortDescriptions = metadataHighwayServicesClient.getCohortDescriptions(userId);
            for (CohortDescription cohortDescription : cohortDescriptions) {
                String cohortName = cohortDescription.getCohortName();
                ServerCohortDetails serverCohortDetails = new ServerCohortDetails();
                serverCohortDetails.setCohortDescription(cohortDescription);
                MemberRegistration localRegistration = metadataHighwayServicesClient.getLocalRegistration(serverName, userId, cohortName);
                serverCohortDetails.setLocalRegistration(localRegistration);
                List remoteRegistrations = metadataHighwayServicesClient.getRemoteRegistrations(serverName, userId, cohortName);
                serverCohortDetails.setRemoteRegistrations(remoteRegistrations);
                returnMap.put(cohortName, serverCohortDetails);
            }
            return returnMap;
        }
        catch (RepositoryErrorException exc) {
            return null;
        }
        catch (InvalidParameterException exc) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException("Could not retrieve cohort descriptions due to an invalid value for serverName parameter", (OCFCheckedExceptionBase)exc, serverName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException exc) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)exc, userId);
        }
    }

    public OMRSAuditLogReport serverGetAuditLog(String userId, String serverName, String platformName, String methodName) throws UserNotAuthorizedException, org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        try {
            AuditLogServicesClient auditLogServicesClient = this.getAuditLogServicesClient(userId, serverName, platformRootURL);
            OMRSAuditLogReport report = auditLogServicesClient.getAuditLog(userId);
            return report;
        }
        catch (RepositoryErrorException exc) {
            return null;
        }
        catch (InvalidParameterException exc) {
            throw new org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException("Could not retrieve cohort descriptions due to an invalid value for serverName parameter", (OCFCheckedExceptionBase)exc, serverName);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException exc) {
            throw new UserNotAuthorizedException((OCFCheckedExceptionBase)exc, userId);
        }
    }
}

