/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dino.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationSummary;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.dino.api.properties.RequestSummary;
import org.odpi.openmetadata.viewservices.dino.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoPlatformOverviewResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoPlatformRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoResourceEndpointListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerAuditLogResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerConfigResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerDoubleConfigResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerOverviewResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerTypeResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServiceListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoStringResponse;
import org.odpi.openmetadata.viewservices.dino.handlers.DinoViewHandler;
import org.odpi.openmetadata.viewservices.dino.server.DinoViewInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DinoViewRESTServices {
    protected static DinoViewInstanceHandler instanceHandler = new DinoViewInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DinoViewRESTServices.class), instanceHandler.getServiceName());
    private static final Logger log = LoggerFactory.getLogger(DinoViewRESTServices.class);

    public DinoResourceEndpointListResponse getResourceEndpointList(String serverName, String userId) {
        String methodName = "getResourceEndpointList";
        DinoResourceEndpointListResponse response = new DinoResourceEndpointListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceEndpointList");
            DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "getResourceEndpointList");
            Map<String, List<ResourceEndpoint>> lists = handler.getResourceEndpoints(userId, "getResourceEndpointList");
            response.setPlatformList(lists.get("platformList"));
            response.setServerList(lists.get("serverList"));
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getResourceEndpointList", auditLog);
        }
        log.debug("Returning from method: getResourceEndpointList with response: " + response.toString());
        return response;
    }

    public DinoPlatformOverviewResponse platformGetOverview(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetOverview";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetOverview");
        DinoPlatformOverviewResponse response = new DinoPlatformOverviewResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetOverview");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetOverview");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetOverview");
                response.setPlatformOverview(handler.platformGetOverview(userId, requestBody.getPlatformName(), "platformGetOverview"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetOverview", auditLog);
        }
        log.debug("Returning from method: platformGetOverview with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoStringResponse platformGetOrigin(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetOrigin");
        DinoStringResponse response = new DinoStringResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetOrigin");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetOrigin");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetOrigin");
                response.setString(handler.platformGetOrigin(userId, requestBody.getPlatformName(), "platformGetOrigin"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetOrigin", auditLog);
        }
        log.debug("Returning from method: platformGetOrigin with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerListResponse platformGetActiveServers(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetActiveServers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetActiveServers");
        DinoServerListResponse response = new DinoServerListResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetActiveServers");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetActiveServers");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetActiveServers");
                response.setServerList(handler.platformGetActiveServerList(userId, requestBody.getPlatformName(), "platformGetActiveServers"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetActiveServers", auditLog);
        }
        log.debug("Returning from method: platformGetActiveServers with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerListResponse platformGetKnownServers(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetKnownServers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetKnownServers");
        DinoServerListResponse response = new DinoServerListResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetKnownServers");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetKnownServers");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetKnownServers");
                response.setServerList(handler.platformGetKnownServerList(userId, requestBody.getPlatformName(), "platformGetKnownServers"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetKnownServers", auditLog);
        }
        log.debug("Returning from method: platformGetKnownServers with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetAccessServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetAccessServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetAccessServices");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetAccessServices");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetAccessServices");
                response.setServiceList(handler.platformGetAccessServiceList(userId, requestBody.getPlatformName(), "platformGetAccessServices"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetAccessServices", auditLog);
        }
        log.debug("Returning from method: platformGetAccessServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetViewServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetViewServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetViewServices");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetViewServices");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetViewServices");
                response.setServiceList(handler.platformGetViewServiceList(userId, requestBody.getPlatformName(), "platformGetViewServices"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetViewServices", auditLog);
        }
        log.debug("Returning from method: platformGetViewServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetGovernanceServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetGovernanceServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetGovernanceServices");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetGovernanceServices");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetGovernanceServices");
                response.setServiceList(handler.platformGetGovernanceServiceList(userId, requestBody.getPlatformName(), "platformGetGovernanceServices"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetGovernanceServices", auditLog);
        }
        log.debug("Returning from method: platformGetGovernanceServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetCommonServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetCommonServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetCommonServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, "platformGetCommonServices");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetCommonServices");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetCommonServices");
                response.setServiceList(handler.platformGetCommonServiceList(userId, requestBody.getPlatformName(), "platformGetCommonServices"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetCommonServices", auditLog);
        }
        log.debug("Returning from method: platformGetCommonServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerOverviewResponse serverGetOverview(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetOverview";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetOverview");
        DinoServerOverviewResponse response = new DinoServerOverviewResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), "serverGetOverview");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetOverview");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetOverview");
                response.setServerOverview(handler.serverGetOverview(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getServerInstanceName(), requestBody.getDescription(), "serverGetOverview"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetOverview", auditLog);
        }
        log.debug("Returning from method: serverGetOverview with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoStringResponse serverGetOrigin(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetOrigin");
        DinoStringResponse response = new DinoStringResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), "serverGetOrigin");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetOrigin");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetOrigin");
                response.setString(handler.serverGetOrigin(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetOrigin"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetOrigin", auditLog);
        }
        log.debug("Returning from method: serverGetOrigin with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerTypeResponse serverGetTypeClassification(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetTypeClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetTypeClassification");
        DinoServerTypeResponse response = new DinoServerTypeResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), "serverGetTypeClassification");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetTypeClassification");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetTypeClassification");
                ServerTypeClassificationSummary summary = handler.serverGetTypeClassification(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetTypeClassification");
                response.setServerTypeName(summary.getServerTypeName());
                response.setServerTypeDescription(summary.getServerTypeDescription());
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetTypeClassification", auditLog);
        }
        log.debug("Returning from method: serverGetTypeClassification with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerConfigResponse serverGetStoredConfiguration(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetConfiguration");
        DinoServerConfigResponse response = new DinoServerConfigResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), "serverGetConfiguration");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetConfiguration");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetConfiguration");
                response.setServerConfig(handler.serverGetStoredConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetConfiguration"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetConfiguration", auditLog);
        }
        log.debug("Returning from method: serverGetConfiguration with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerConfigResponse serverGetInstanceConfiguration(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetInstanceConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetInstanceConfiguration");
        DinoServerConfigResponse response = new DinoServerConfigResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), "serverGetInstanceConfiguration");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetInstanceConfiguration");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetInstanceConfiguration");
                response.setServerConfig(handler.serverGetInstanceConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetInstanceConfiguration"));
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetInstanceConfiguration", auditLog);
        }
        log.debug("Returning from method: serverGetInstanceConfiguration with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerDoubleConfigResponse serverGetStoredAndActiveConfiguration(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetInstanceConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetInstanceConfiguration");
        DinoServerDoubleConfigResponse response = new DinoServerDoubleConfigResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), "serverGetInstanceConfiguration");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetInstanceConfiguration");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetInstanceConfiguration");
                response.setStoredConfig(handler.serverGetStoredConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetInstanceConfiguration"));
                response.setActiveConfig(handler.serverGetInstanceConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetInstanceConfiguration"));
            }
        }
        catch (PropertyServerException error) {
            OCFCheckedExceptionBase cause;
            boolean tolerate = false;
            if (error.getCause() != null && error.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)error.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                tolerate = true;
                response.setActiveConfig(null);
            }
            if (!tolerate) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetInstanceConfiguration", auditLog);
        }
        log.debug("Returning from method: serverGetInstanceConfiguration with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerAuditLogResponse serverGetAuditLog(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetAuditLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetAuditLog");
        DinoServerAuditLogResponse response = new DinoServerAuditLogResponse();
        RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), "serverGetAuditLog");
        response.setRequestSummary(request);
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetAuditLog");
            if (requestBody != null) {
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetAuditLog");
                response.setAuditLog(handler.serverGetAuditLog(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetAuditLog"));
            }
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetAuditLog", auditLog);
        }
        log.debug("Returning from method: serverGetAuditLog with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

