/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dino.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationSummary;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoExceptionHandler;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoViewErrorCode;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoViewServiceException;
import org.odpi.openmetadata.viewservices.dino.api.properties.RequestSummary;
import org.odpi.openmetadata.viewservices.dino.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoEngineDetailsResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoEngineRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoPlatformOverviewResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoPlatformRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoResourceEndpointListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerAuditLogResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerConfigResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerDoubleConfigResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerOverviewResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerTypeResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServiceDetailsResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServiceListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServiceRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoStringResponse;
import org.odpi.openmetadata.viewservices.dino.handlers.DinoViewHandler;
import org.odpi.openmetadata.viewservices.dino.server.DinoViewInstanceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DinoViewRESTServices {
    protected static DinoViewInstanceHandler instanceHandler = new DinoViewInstanceHandler();
    private static RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(DinoViewRESTServices.class), instanceHandler.getServiceName());
    private static final Logger log = LoggerFactory.getLogger(DinoViewRESTServices.class);

    public DinoResourceEndpointListResponse getResourceEndpointList(String serverName, String userId) {
        String methodName = "getResourceEndpointList";
        DinoResourceEndpointListResponse response = new DinoResourceEndpointListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getResourceEndpointList");
            DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "getResourceEndpointList");
            if (handler == null) {
                throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"getResourceEndpointList"}), this.getClass().getName(), "getResourceEndpointList");
            }
            Map<String, List<ResourceEndpoint>> lists = handler.getResourceEndpoints(userId, "getResourceEndpointList");
            List<ResourceEndpoint> platformList = null;
            List<ResourceEndpoint> serverList = null;
            if (lists != null) {
                platformList = lists.get("platformList");
                serverList = lists.get("serverList");
            }
            response.setPlatformList(platformList);
            response.setServerList(serverList);
        }
        catch (InvalidParameterException error) {
            restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
        }
        catch (PropertyServerException error) {
            restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
        }
        catch (UserNotAuthorizedException error) {
            restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
        }
        catch (DinoViewServiceException error) {
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        catch (Throwable error) {
            restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getResourceEndpointList", auditLog);
        }
        log.debug("Returning from method: getResourceEndpointList with response: " + response.toString());
        return response;
    }

    public DinoPlatformOverviewResponse platformGetOverview(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetOverview";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetOverview");
        DinoPlatformOverviewResponse response = new DinoPlatformOverviewResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetOverview");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetOverview");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetOverview");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetOverview"}), this.getClass().getName(), "platformGetOverview");
                }
                response.setPlatformOverview(handler.platformGetOverview(userId, requestBody.getPlatformName(), "platformGetOverview"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetOverview", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetOverview");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetOverview with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoStringResponse platformGetOrigin(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetOrigin");
        DinoStringResponse response = new DinoStringResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetOrigin");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetOrigin");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetOrigin");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetOrigin"}), this.getClass().getName(), "platformGetOrigin");
                }
                response.setString(handler.platformGetOrigin(userId, requestBody.getPlatformName(), "platformGetOrigin"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetOrigin", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetOrigin");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetOrigin with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerListResponse platformGetActiveServers(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetActiveServers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetActiveServers");
        DinoServerListResponse response = new DinoServerListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetActiveServers");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetActiveServers");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetActiveServers");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetActiveServers"}), this.getClass().getName(), "platformGetActiveServers");
                }
                response.setServerList(handler.platformGetActiveServerList(userId, requestBody.getPlatformName(), "platformGetActiveServers"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetActiveServers", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetActiveServers");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetActiveServers with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerListResponse platformGetKnownServers(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetKnownServers";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetKnownServers");
        DinoServerListResponse response = new DinoServerListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetKnownServers");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetKnownServers");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetKnownServers");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetKnownServers"}), this.getClass().getName(), "platformGetKnownServers");
                }
                response.setServerList(handler.platformGetKnownServerList(userId, requestBody.getPlatformName(), "platformGetKnownServers"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetKnownServers", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetKnownServers");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetKnownServers with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetAccessServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetAccessServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetAccessServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetAccessServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetAccessServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetAccessServices"}), this.getClass().getName(), "platformGetAccessServices");
                }
                response.setServiceList(handler.platformGetAccessServiceList(userId, requestBody.getPlatformName(), "platformGetAccessServices"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetAccessServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetAccessServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetAccessServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetViewServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetViewServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetViewServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetViewServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetViewServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetViewServices"}), this.getClass().getName(), "platformGetViewServices");
                }
                response.setServiceList(handler.platformGetViewServiceList(userId, requestBody.getPlatformName(), "platformGetViewServices"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetViewServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetViewServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetViewServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetGovernanceServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetGovernanceServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetGovernanceServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetGovernanceServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetGovernanceServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetGovernanceServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetGovernanceServices"}), this.getClass().getName(), "platformGetGovernanceServices");
                }
                response.setServiceList(handler.platformGetGovernanceServiceList(userId, requestBody.getPlatformName(), "platformGetGovernanceServices"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetGovernanceServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetGovernanceServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetGovernanceServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse platformGetCommonServices(String serverName, String userId, DinoPlatformRequestBody requestBody) {
        String methodName = "platformGetCommonServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "platformGetCommonServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), null, null, "platformGetCommonServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "platformGetCommonServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "platformGetCommonServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"platformGetCommonServices"}), this.getClass().getName(), "platformGetCommonServices");
                }
                response.setServiceList(handler.platformGetCommonServiceList(userId, requestBody.getPlatformName(), "platformGetCommonServices"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "platformGetCommonServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "platformGetCommonServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: platformGetCommonServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerOverviewResponse serverGetOverview(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetOverview";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetOverview");
        DinoServerOverviewResponse response = new DinoServerOverviewResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetOverview");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetOverview");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetOverview");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetOverview"}), this.getClass().getName(), "serverGetOverview");
                }
                response.setServerOverview(handler.serverGetOverview(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getServerInstanceName(), requestBody.getDescription(), "serverGetOverview"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetOverview", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetOverview");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetOverview with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoStringResponse serverGetOrigin(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetOrigin";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetOrigin");
        DinoStringResponse response = new DinoStringResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetOrigin");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetOrigin");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetOrigin");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetOrigin"}), this.getClass().getName(), "serverGetOrigin");
                }
                response.setString(handler.serverGetOrigin(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetOrigin"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetOrigin", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetOrigin");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetOrigin with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerTypeResponse serverGetTypeClassification(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetTypeClassification";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetTypeClassification");
        DinoServerTypeResponse response = new DinoServerTypeResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetTypeClassification");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetTypeClassification");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetTypeClassification");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetTypeClassification"}), this.getClass().getName(), "serverGetTypeClassification");
                }
                ServerTypeClassificationSummary summary = handler.serverGetTypeClassification(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetTypeClassification");
                response.setServerTypeName(summary.getServerTypeName());
                response.setServerTypeDescription(summary.getServerTypeDescription());
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetTypeClassification", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetTypeClassification");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetTypeClassification with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerConfigResponse serverGetStoredConfiguration(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetConfiguration");
        DinoServerConfigResponse response = new DinoServerConfigResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetConfiguration");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetConfiguration");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetConfiguration");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetConfiguration"}), this.getClass().getName(), "serverGetConfiguration");
                }
                response.setServerConfig(handler.serverGetStoredConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetConfiguration"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetConfiguration", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetConfiguration");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetConfiguration with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerConfigResponse serverGetInstanceConfiguration(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetInstanceConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetInstanceConfiguration");
        DinoServerConfigResponse response = new DinoServerConfigResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetInstanceConfiguration");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetInstanceConfiguration");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetInstanceConfiguration");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetInstanceConfiguration"}), this.getClass().getName(), "serverGetInstanceConfiguration");
                }
                response.setServerConfig(handler.serverGetInstanceConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetInstanceConfiguration"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetInstanceConfiguration", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetInstanceConfiguration");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetInstanceConfiguration with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerDoubleConfigResponse serverGetStoredAndActiveConfiguration(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetInstanceConfiguration";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetInstanceConfiguration");
        DinoServerDoubleConfigResponse response = new DinoServerDoubleConfigResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetInstanceConfiguration");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetInstanceConfiguration");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetInstanceConfiguration");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetInstanceConfiguration"}), this.getClass().getName(), "serverGetInstanceConfiguration");
                }
                response.setStoredConfig(handler.serverGetStoredConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetInstanceConfiguration"));
                response.setActiveConfig(handler.serverGetInstanceConfiguration(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetInstanceConfiguration"));
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                if (response.getStoredConfig() == null) {
                    DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
                }
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetInstanceConfiguration", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetInstanceConfiguration");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetInstanceConfiguration with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServerAuditLogResponse serverGetAuditLog(String serverName, String userId, DinoServerRequestBody requestBody) {
        String methodName = "serverGetAuditLog";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetAuditLog");
        DinoServerAuditLogResponse response = new DinoServerAuditLogResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetAuditLog");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetAuditLog");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetAuditLog");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetAuditLog"}), this.getClass().getName(), "serverGetAuditLog");
                }
                response.setAuditLog(handler.serverGetAuditLog(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetAuditLog"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetAuditLog", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetAuditLog");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetAuditLog with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse serverGetIntegrationServices(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetIntegrationServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetIntegrationServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetIntegrationServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetIntegrationServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetIntegrationServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetIntegrationServices"}), this.getClass().getName(), "serverGetIntegrationServices");
                }
                response.setServiceList(handler.serverGetIntegrationServices(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetIntegrationServices"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetIntegrationServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetIntegrationServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetIntegrationServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse serverGetEngineServices(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetEngineServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetEngineServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetEngineServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetEngineServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetEngineServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetEngineServices"}), this.getClass().getName(), "serverGetEngineServices");
                }
                response.setServiceList(handler.serverGetEngineServices(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetEngineServices"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetEngineServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetEngineServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetEngineServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse serverGetAccessServices(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetAccessServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetAccessServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetAccessServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetAccessServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetAccessServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetAccessServices"}), this.getClass().getName(), "serverGetAccessServices");
                }
                response.setServiceList(handler.serverGetAccessServices(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetAccessServices"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetAccessServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetAccessServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetAccessServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceListResponse serverGetViewServices(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetViewServices";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetViewServices");
        DinoServiceListResponse response = new DinoServiceListResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetViewServices");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetViewServices");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetViewServices");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetViewServices"}), this.getClass().getName(), "serverGetViewServices");
                }
                response.setServiceList(handler.serverGetViewServices(userId, requestBody.getServerName(), requestBody.getPlatformName(), "serverGetViewServices"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetViewServices", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetViewServices");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetViewServices with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceDetailsResponse serverGetIntegrationServiceDetails(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetIntegrationServiceDetails";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetIntegrationServiceDetails");
        DinoServiceDetailsResponse response = new DinoServiceDetailsResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetIntegrationServiceDetails");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetIntegrationServiceDetails");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetIntegrationServiceDetails");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetIntegrationServiceDetails"}), this.getClass().getName(), "serverGetIntegrationServiceDetails");
                }
                response.setServiceDetails(handler.serverGetIntegrationServiceDetails(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getServiceURLMarker(), "serverGetIntegrationServiceDetails"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetIntegrationServiceDetails", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetIntegrationServiceDetails");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetIntegrationServiceDetails with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceDetailsResponse serverGetEngineServiceDetails(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetEngineServiceDetails";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetEngineServiceDetails");
        DinoServiceDetailsResponse response = new DinoServiceDetailsResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetEngineServiceDetails");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetEngineServiceDetails");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetEngineServiceDetails");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetEngineServiceDetails"}), this.getClass().getName(), "serverGetEngineServiceDetails");
                }
                response.setServiceDetails(handler.serverGetEngineServiceDetails(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getServiceURLMarker(), "serverGetEngineServiceDetails"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetEngineServiceDetails", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetEngineServiceDetails");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetEngineServiceDetails with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceDetailsResponse serverGetAccessServiceDetails(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetAccessServiceDetails";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetAccessServiceDetails");
        DinoServiceDetailsResponse response = new DinoServiceDetailsResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetAccessServiceDetails");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetAccessServiceDetails");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetAccessServiceDetails");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetAccessServiceDetails"}), this.getClass().getName(), "serverGetAccessServiceDetails");
                }
                response.setServiceDetails(handler.serverGetAccessServiceDetails(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getServiceFullName(), requestBody.getServiceURLMarker(), "serverGetAccessServiceDetails"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetAccessServiceDetails", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetAccessServiceDetails");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetAccessServiceDetails with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoServiceDetailsResponse serverGetViewServiceDetails(String serverName, String userId, DinoServiceRequestBody requestBody) {
        String methodName = "serverGetViewServiceDetails";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetViewServiceDetails");
        DinoServiceDetailsResponse response = new DinoServiceDetailsResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), null, "serverGetViewServiceDetails");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetViewServiceDetails");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetViewServiceDetails");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetViewServiceDetails"}), this.getClass().getName(), "serverGetViewServiceDetails");
                }
                response.setServiceDetails(handler.serverGetViewServiceDetails(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getServiceURLMarker(), "serverGetViewServiceDetails"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetViewServiceDetails", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetViewServiceDetails");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetViewServiceDetails with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }

    public DinoEngineDetailsResponse serverGetEngineDetails(String serverName, String userId, DinoEngineRequestBody requestBody) {
        String methodName = "serverGetEngineDetails";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "serverGetEngineDetails");
        DinoEngineDetailsResponse response = new DinoEngineDetailsResponse();
        if (requestBody != null) {
            RequestSummary request = new RequestSummary(requestBody.getPlatformName(), requestBody.getServerName(), requestBody.getRequestContextCorrelator(), "serverGetEngineDetails");
            response.setRequestSummary(request);
            AuditLog auditLog = null;
            try {
                auditLog = instanceHandler.getAuditLog(userId, serverName, "serverGetEngineDetails");
                DinoViewHandler handler = instanceHandler.getDinoViewHandler(userId, serverName, "serverGetEngineDetails");
                if (handler == null) {
                    throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_CREATE_HANDLER.getMessageDefinition(new String[]{"serverGetEngineDetails"}), this.getClass().getName(), "serverGetEngineDetails");
                }
                response.setEngineDetails(handler.serverGetEngineDetails(userId, requestBody.getServerName(), requestBody.getPlatformName(), requestBody.getEngineQualifiedName(), "serverGetEngineDetails"));
            }
            catch (PropertyServerException error) {
                restExceptionHandler.capturePropertyServerException((FFDCResponse)response, error);
            }
            catch (InvalidParameterException error) {
                restExceptionHandler.captureInvalidParameterException((FFDCResponse)response, error);
            }
            catch (UserNotAuthorizedException error) {
                restExceptionHandler.captureUserNotAuthorizedException((FFDCResponse)response, error);
            }
            catch (DinoViewServiceException error) {
                DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
            }
            catch (Throwable error) {
                restExceptionHandler.captureThrowable((FFDCResponse)response, error, "serverGetEngineDetails", auditLog);
            }
        } else {
            DinoViewServiceException error = new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_REQUEST_BODY_MISSING.getMessageDefinition(), this.getClass().getName(), "serverGetEngineDetails");
            DinoExceptionHandler.captureCheckedException((FFDCResponse)response, (OCFCheckedExceptionBase)error, (String)((Object)((Object)error)).getClass().getName());
        }
        log.debug("Returning from method: serverGetEngineDetails with response: " + response.toString());
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

