/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dino.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineConfigurationClient;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceEngineElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.GovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.metadataelements.RegisteredGovernanceServiceElement;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceServiceProperties;
import org.odpi.openmetadata.accessservices.governanceengine.properties.RegisteredGovernanceService;
import org.odpi.openmetadata.adminservices.client.EngineHostConfigurationClient;
import org.odpi.openmetadata.adminservices.client.IntegrationDaemonConfigurationClient;
import org.odpi.openmetadata.adminservices.client.MetadataAccessPointConfigurationClient;
import org.odpi.openmetadata.adminservices.client.OMAGServerConfigurationClient;
import org.odpi.openmetadata.adminservices.client.ViewServerConfigurationClient;
import org.odpi.openmetadata.adminservices.configuration.properties.AccessServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.EngineServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.IntegrationServiceConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ResourceEndpointConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGConfigurationErrorException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGInvalidParameterException;
import org.odpi.openmetadata.adminservices.ffdc.exception.OMAGNotAuthorizedException;
import org.odpi.openmetadata.adminservices.rest.ServerTypeClassificationSummary;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGService;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.platformservices.client.PlatformServicesClient;
import org.odpi.openmetadata.platformservices.properties.ServerStatus;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLogReport;
import org.odpi.openmetadata.repositoryservices.clients.AuditLogServicesClient;
import org.odpi.openmetadata.repositoryservices.clients.MetadataHighwayServicesClient;
import org.odpi.openmetadata.repositoryservices.connectors.stores.cohortregistrystore.properties.MemberRegistration;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoExceptionHandler;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoViewErrorCode;
import org.odpi.openmetadata.viewservices.dino.api.ffdc.DinoViewServiceException;
import org.odpi.openmetadata.viewservices.dino.api.properties.DinoServerInstance;
import org.odpi.openmetadata.viewservices.dino.api.properties.EngineDetails;
import org.odpi.openmetadata.viewservices.dino.api.properties.PlatformOverview;
import org.odpi.openmetadata.viewservices.dino.api.properties.ResourceEndpoint;
import org.odpi.openmetadata.viewservices.dino.api.properties.ServerCohortDetails;
import org.odpi.openmetadata.viewservices.dino.api.properties.ServerOverview;
import org.odpi.openmetadata.viewservices.dino.api.properties.ServiceDetails;
import org.odpi.openmetadata.viewservices.dino.api.properties.ServicePropertiesAndRequests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DinoViewHandler {
    private static final Logger log = LoggerFactory.getLogger(DinoViewHandler.class);
    private Map<String, ResourceEndpoint> configuredPlatforms = null;
    private Map<String, ResourceEndpoint> configuredServerInstances = null;

    public DinoViewHandler() {
    }

    public DinoViewHandler(List<ResourceEndpointConfig> resourceEndpoints) {
        this.configuredPlatforms = new HashMap<String, ResourceEndpoint>();
        this.configuredServerInstances = new HashMap<String, ResourceEndpoint>();
        if (resourceEndpoints != null && !resourceEndpoints.isEmpty()) {
            resourceEndpoints.forEach(res -> {
                String resCategory = res.getResourceCategory();
                ResourceEndpoint rep = new ResourceEndpoint(res);
                switch (resCategory) {
                    case "Platform": {
                        String resName = res.getPlatformName();
                        this.configuredPlatforms.put(resName, rep);
                        break;
                    }
                    case "Server": {
                        String resName = res.getServerInstanceName();
                        this.configuredServerInstances.put(resName, rep);
                        break;
                    }
                }
            });
        }
    }

    public Map<String, List<ResourceEndpoint>> getResourceEndpoints(String userId, String methodName) {
        HashMap<String, List<ResourceEndpoint>> returnMap = new HashMap<String, List<ResourceEndpoint>>();
        ArrayList<ResourceEndpoint> platformList = null;
        ArrayList<ResourceEndpoint> serverList = null;
        if (!this.configuredPlatforms.isEmpty()) {
            platformList = new ArrayList<ResourceEndpoint>();
            platformList.addAll(this.configuredPlatforms.values());
        }
        if (!this.configuredServerInstances.isEmpty()) {
            serverList = new ArrayList<ResourceEndpoint>();
            serverList.addAll(this.configuredServerInstances.values());
        }
        returnMap.put("platformList", platformList);
        returnMap.put("serverList", serverList);
        return returnMap;
    }

    private String resolvePlatformRootURL(String platformName, String methodName) throws DinoViewServiceException {
        ResourceEndpoint resource;
        String platformRootURL = null;
        if (platformName != null && (resource = this.configuredPlatforms.get(platformName)) != null) {
            platformRootURL = resource.getResourceRootURL();
        }
        if (platformName == null || platformRootURL == null) {
            throw new DinoViewServiceException(DinoViewErrorCode.VIEW_SERVICE_NULL_PLATFORM_NAME.getMessageDefinition(), this.getClass().getName(), methodName);
        }
        return platformRootURL;
    }

    private PlatformServicesClient getPlatformServicesClient(String platformName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getOMAGServerConfigurationClient";
        try {
            return new PlatformServicesClient(platformName, platformRootURL);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
    }

    private OMAGServerConfigurationClient getOMAGServerConfigurationClient(String userId, String serverName, String serverRootURL) throws DinoViewServiceException {
        String methodName = "getOMAGServerConfigurationClient";
        try {
            return new OMAGServerConfigurationClient(userId, serverName, serverRootURL);
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
    }

    private MetadataHighwayServicesClient getMetadataHighwayServicesClient(String userId, String serverName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getMetadataHighwayServicesClient";
        try {
            String serverRootURL = platformRootURL + "/servers/" + serverName;
            return new MetadataHighwayServicesClient(serverName, serverRootURL);
        }
        catch (InvalidParameterException e) {
            throw DinoExceptionHandler.mapOMRSInvalidParameterException((String)this.getClass().getName(), (String)methodName, (InvalidParameterException)e);
        }
    }

    private AuditLogServicesClient getAuditLogServicesClient(String userId, String serverName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getAuditLogServicesClient";
        try {
            String serverRootURL = platformRootURL + "/servers/" + serverName;
            return new AuditLogServicesClient(serverName, serverRootURL);
        }
        catch (InvalidParameterException e) {
            throw DinoExceptionHandler.mapOMRSInvalidParameterException((String)this.getClass().getName(), (String)methodName, (InvalidParameterException)e);
        }
    }

    private IntegrationDaemonConfigurationClient getIntegrationDaemonConfigurationClient(String userId, String serverName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getIntegrationDaemonConfigurationClient";
        try {
            return new IntegrationDaemonConfigurationClient(userId, serverName, platformRootURL);
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
    }

    private EngineHostConfigurationClient getEngineHostConfigurationClient(String userId, String serverName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getEngineHostConfigurationClient";
        try {
            return new EngineHostConfigurationClient(userId, serverName, platformRootURL);
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
    }

    private MetadataAccessPointConfigurationClient getMetadataAccessPointConfigurationClient(String userId, String serverName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getMetadataAccessPointConfigurationClient";
        try {
            return new MetadataAccessPointConfigurationClient(userId, serverName, platformRootURL);
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
    }

    private ViewServerConfigurationClient getViewServerConfigurationClient(String userId, String serverName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getViewServerConfigurationClient";
        try {
            return new ViewServerConfigurationClient(userId, serverName, platformRootURL);
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
    }

    private GovernanceEngineConfigurationClient getGovernanceEngineConfigurationClient(String userId, String serverName, String platformRootURL) throws DinoViewServiceException {
        String methodName = "getGovernanceEngineConfigurationClient";
        try {
            return new GovernanceEngineConfigurationClient(serverName, platformRootURL);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
    }

    public PlatformOverview platformGetOverview(String userId, String platformName, String methodName) throws DinoViewServiceException {
        String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
        PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
        try {
            ResourceEndpoint platformConfig = this.configuredPlatforms.get(platformName);
            PlatformOverview platformOverview = new PlatformOverview();
            platformOverview.setPlatformName(platformConfig.getPlatformName());
            platformOverview.setDescription(platformConfig.getResourceDescription());
            platformOverview.setPlatformRootURL(platformConfig.getResourceRootURL());
            String platformOrigin = platformServicesClient.getPlatformOrigin(userId);
            platformOverview.setPlatformOrigin(platformOrigin);
            List accessServiceList = platformServicesClient.getAccessServices(userId);
            platformOverview.setAccessServices(accessServiceList);
            List commonServiceList = platformServicesClient.getCommonServices(userId);
            platformOverview.setCommonServices(commonServiceList);
            List governanceServiceList = platformServicesClient.getGovernanceServices(userId);
            platformOverview.setGovernanceServices(governanceServiceList);
            List viewServiceList = platformServicesClient.getViewServices(userId);
            platformOverview.setViewServices(viewServiceList);
            List integrationServiceList = platformServicesClient.getIntegrationServices(userId);
            platformOverview.setIntegrationServices(integrationServiceList);
            List engineServiceList = platformServicesClient.getEngineServices(userId);
            platformOverview.setEngineServices(engineServiceList);
            return platformOverview;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public String platformGetOrigin(String userId, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            return platformServicesClient.getPlatformOrigin(userId);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public List<DinoServerInstance> platformGetActiveServerList(String userId, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            List serverNames = platformServicesClient.getActiveServers(userId);
            if (serverNames != null) {
                ArrayList<DinoServerInstance> serverList = new ArrayList<DinoServerInstance>();
                serverNames.forEach(serverName -> {
                    DinoServerInstance dinoServerInstance = new DinoServerInstance();
                    String configuredInstanceName = null;
                    for (ResourceEndpoint csire : this.configuredServerInstances.values()) {
                        if (!csire.getServerName().equals(serverName) || !csire.getPlatformName().equals(platformName)) continue;
                        configuredInstanceName = csire.getServerInstanceName();
                    }
                    dinoServerInstance.setServerInstanceName(configuredInstanceName);
                    dinoServerInstance.setIsActive(true);
                    dinoServerInstance.setServerName(serverName);
                    dinoServerInstance.setPlatformName(platformName);
                    serverList.add(dinoServerInstance);
                });
                return serverList;
            }
            return null;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public List<DinoServerInstance> platformGetKnownServerList(String userId, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            List serverNames = platformServicesClient.getKnownServers(userId);
            if (serverNames != null) {
                ArrayList<DinoServerInstance> serverList = new ArrayList<DinoServerInstance>();
                List activeServerNames = platformServicesClient.getActiveServers(userId);
                serverNames.forEach(serverName -> {
                    DinoServerInstance dinoServerInstance = new DinoServerInstance();
                    dinoServerInstance.setServerName(serverName);
                    dinoServerInstance.setPlatformName(platformName);
                    if (activeServerNames != null && activeServerNames.contains(serverName)) {
                        dinoServerInstance.setIsActive(true);
                    } else {
                        dinoServerInstance.setIsActive(false);
                    }
                    serverList.add(dinoServerInstance);
                });
                return serverList;
            }
            return null;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public List<RegisteredOMAGService> platformGetAccessServiceList(String userId, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            return platformServicesClient.getAccessServices(userId);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public List<RegisteredOMAGService> platformGetViewServiceList(String userId, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            return platformServicesClient.getViewServices(userId);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public List<RegisteredOMAGService> platformGetGovernanceServiceList(String userId, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            return platformServicesClient.getGovernanceServices(userId);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public List<RegisteredOMAGService> platformGetCommonServiceList(String userId, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            return platformServicesClient.getCommonServices(userId);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public ServerOverview serverGetOverview(String userId, String serverName, String platformName, String serverInstanceName, String description, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            ServerOverview serverOverview = new ServerOverview();
            serverOverview.setServerName(serverName);
            serverOverview.setPlatformRootURL(platformRootURL);
            if (serverInstanceName != null) {
                serverOverview.setServerInstanceName(serverInstanceName);
            }
            if (description != null) {
                serverOverview.setDescription(description);
            }
            String serverOrigin = platformServicesClient.getPlatformOrigin(userId);
            serverOverview.setServerOrigin(serverOrigin);
            ServerTypeClassificationSummary serverClassification = this.serverGetTypeClassification(userId, serverName, platformName, methodName);
            serverOverview.setServerClassification(serverClassification);
            ServerStatus serverStatus = platformServicesClient.getServerStatus(userId, serverName);
            serverOverview.setServerStatus(serverStatus);
            List<RegisteredOMAGService> integrationServices = this.serverGetIntegrationServices(userId, serverName, platformName, methodName);
            serverOverview.setIntegrationServices(integrationServices);
            List<RegisteredOMAGService> engineServices = this.serverGetEngineServices(userId, serverName, platformName, methodName);
            serverOverview.setEngineServices(engineServices);
            List<RegisteredOMAGService> accessServices = this.serverGetAccessServices(userId, serverName, platformName, methodName);
            serverOverview.setAccessServices(accessServices);
            List<RegisteredOMAGService> viewServices = this.serverGetViewServices(userId, serverName, platformName, methodName);
            serverOverview.setViewServices(viewServices);
            Map<String, ServerCohortDetails> cohortDetails = this.serverGetCohortDetails(userId, serverName, platformName, methodName);
            serverOverview.setCohortDetails(cohortDetails);
            return serverOverview;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public String serverGetOrigin(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            PlatformServicesClient platformServicesClient = this.getPlatformServicesClient(platformName, platformRootURL);
            return platformServicesClient.getPlatformOrigin(userId);
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapOCFInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOCFUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }

    public ServerTypeClassificationSummary serverGetTypeClassification(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            OMAGServerConfigurationClient adminServicesClient = this.getOMAGServerConfigurationClient(userId, serverName, platformRootURL);
            return adminServicesClient.getServerClassification();
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public OMAGServerConfig serverGetStoredConfiguration(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            OMAGServerConfigurationClient adminServicesClient = this.getOMAGServerConfigurationClient(userId, serverName, platformRootURL);
            return adminServicesClient.getOMAGServerConfig();
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public OMAGServerConfig serverGetInstanceConfiguration(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            OMAGServerConfigurationClient adminServicesClient = this.getOMAGServerConfigurationClient(userId, serverName, platformRootURL);
            return adminServicesClient.getOMAGServerInstanceConfig();
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public Map<String, ServerCohortDetails> serverGetCohortDetails(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        HashMap<String, ServerCohortDetails> returnMap = new HashMap<String, ServerCohortDetails>();
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            MetadataHighwayServicesClient metadataHighwayServicesClient = this.getMetadataHighwayServicesClient(userId, serverName, platformRootURL);
            List cohortDescriptions = metadataHighwayServicesClient.getCohortDescriptions(userId);
            for (CohortDescription cohortDescription : cohortDescriptions) {
                String cohortName = cohortDescription.getCohortName();
                ServerCohortDetails serverCohortDetails = new ServerCohortDetails();
                serverCohortDetails.setCohortDescription(cohortDescription);
                MemberRegistration localRegistration = metadataHighwayServicesClient.getLocalRegistration(serverName, userId, cohortName);
                serverCohortDetails.setLocalRegistration(localRegistration);
                List remoteRegistrations = metadataHighwayServicesClient.getRemoteRegistrations(serverName, userId, cohortName);
                serverCohortDetails.setRemoteRegistrations(remoteRegistrations);
                returnMap.put(cohortName, serverCohortDetails);
            }
            return returnMap;
        }
        catch (RepositoryErrorException e) {
            return null;
        }
        catch (InvalidParameterException e) {
            throw DinoExceptionHandler.mapOMRSInvalidParameterException((String)this.getClass().getName(), (String)methodName, (InvalidParameterException)e);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMRSUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException)e);
        }
    }

    public OMRSAuditLogReport serverGetAuditLog(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            AuditLogServicesClient auditLogServicesClient = this.getAuditLogServicesClient(userId, serverName, platformRootURL);
            return auditLogServicesClient.getAuditLog(userId);
        }
        catch (RepositoryErrorException exc) {
            return null;
        }
        catch (InvalidParameterException e) {
            throw DinoExceptionHandler.mapOMRSInvalidParameterException((String)this.getClass().getName(), (String)methodName, (InvalidParameterException)e);
        }
        catch (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMRSUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.repositoryservices.ffdc.exception.UserNotAuthorizedException)e);
        }
    }

    public List<RegisteredOMAGService> serverGetIntegrationServices(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            IntegrationDaemonConfigurationClient integrationDaemonConfigurationClient = this.getIntegrationDaemonConfigurationClient(userId, serverName, platformRootURL);
            List serviceList = integrationDaemonConfigurationClient.getConfiguredIntegrationServices();
            return serviceList;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public List<RegisteredOMAGService> serverGetEngineServices(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            EngineHostConfigurationClient engineHostConfigurationClient = this.getEngineHostConfigurationClient(userId, serverName, platformRootURL);
            List serviceList = engineHostConfigurationClient.getConfiguredEngineServices();
            return serviceList;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public List<RegisteredOMAGService> serverGetAccessServices(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            MetadataAccessPointConfigurationClient metadataAccessPointConfigurationClient = this.getMetadataAccessPointConfigurationClient(userId, serverName, platformRootURL);
            List serviceList = metadataAccessPointConfigurationClient.getConfiguredAccessServices();
            return serviceList;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public List<RegisteredOMAGService> serverGetViewServices(String userId, String serverName, String platformName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            ViewServerConfigurationClient viewServerConfigurationClient = this.getViewServerConfigurationClient(userId, serverName, platformRootURL);
            List serviceList = viewServerConfigurationClient.getConfiguredViewServices();
            return serviceList;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public ServiceDetails serverGetIntegrationServiceDetails(String userId, String serverName, String platformName, String serviceURLMarker, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            IntegrationDaemonConfigurationClient integrationDaemonConfigurationClient = this.getIntegrationDaemonConfigurationClient(userId, serverName, platformRootURL);
            IntegrationServiceConfig serviceConfig = integrationDaemonConfigurationClient.getIntegrationServiceConfiguration(serviceURLMarker);
            ServiceDetails serviceDetails = new ServiceDetails();
            serviceDetails.setServiceCat(ServiceDetails.ServiceCat.IntegrationService);
            serviceDetails.setIntegrationServiceConfig(serviceConfig);
            return serviceDetails;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public ServiceDetails serverGetEngineServiceDetails(String userId, String serverName, String platformName, String serviceURLMarker, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            EngineHostConfigurationClient engineHostConfigurationClient = this.getEngineHostConfigurationClient(userId, serverName, platformRootURL);
            EngineServiceConfig serviceConfig = engineHostConfigurationClient.getEngineServiceConfiguration(serviceURLMarker);
            ServiceDetails serviceDetails = new ServiceDetails();
            serviceDetails.setServiceCat(ServiceDetails.ServiceCat.EngineService);
            serviceDetails.setEngineServiceConfig(serviceConfig);
            return serviceDetails;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public ServiceDetails serverGetAccessServiceDetails(String userId, String serverName, String platformName, String serviceFullName, String serviceURLMarker, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            MetadataAccessPointConfigurationClient metadataAccessPointConfigurationClient = this.getMetadataAccessPointConfigurationClient(userId, serverName, platformRootURL);
            List accessServices = metadataAccessPointConfigurationClient.getAccessServicesConfiguration();
            AccessServiceConfig serviceConfig = null;
            for (int i = 0; i < accessServices.size(); ++i) {
                AccessServiceConfig svc = (AccessServiceConfig)accessServices.get(i);
                if (!serviceFullName.equals(svc.getAccessServiceFullName()) && !serviceURLMarker.equals(svc.getAccessServiceURLMarker())) continue;
                serviceConfig = svc;
            }
            if (serviceConfig == null) {
                throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_RETRIEVE_SERVER_CONFIGURATION.getMessageDefinition(new String[]{methodName, serverName}), this.getClass().getName(), methodName);
            }
            ServiceDetails serviceDetails = new ServiceDetails();
            serviceDetails.setServiceCat(ServiceDetails.ServiceCat.AccessService);
            serviceDetails.setAccessServiceConfig(serviceConfig);
            return serviceDetails;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public ServiceDetails serverGetViewServiceDetails(String userId, String serverName, String platformName, String serviceURLMarker, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            ViewServerConfigurationClient viewServerConfigurationClient = this.getViewServerConfigurationClient(userId, serverName, platformRootURL);
            List viewServices = viewServerConfigurationClient.getViewServicesConfiguration();
            ViewServiceConfig serviceConfig = null;
            for (int i = 0; i < viewServices.size(); ++i) {
                ViewServiceConfig svc = (ViewServiceConfig)viewServices.get(i);
                if (!serviceURLMarker.equals(svc.getViewServiceURLMarker())) continue;
                serviceConfig = svc;
            }
            if (serviceConfig == null) {
                throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_RETRIEVE_SERVER_CONFIGURATION.getMessageDefinition(new String[]{methodName, serverName}), this.getClass().getName(), methodName);
            }
            ServiceDetails serviceDetails = new ServiceDetails();
            serviceDetails.setServiceCat(ServiceDetails.ServiceCat.ViewService);
            serviceDetails.setViewServiceConfig(serviceConfig);
            return serviceDetails;
        }
        catch (OMAGInvalidParameterException e) {
            throw DinoExceptionHandler.mapOMAGInvalidParameterException((String)this.getClass().getName(), (String)methodName, (OMAGInvalidParameterException)e);
        }
        catch (OMAGNotAuthorizedException e) {
            throw DinoExceptionHandler.mapOMAGNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (String)userId, (OMAGNotAuthorizedException)e);
        }
        catch (OMAGConfigurationErrorException e) {
            OCFCheckedExceptionBase cause;
            if (e.getCause() != null && e.getCause() instanceof OCFCheckedExceptionBase && (cause = (OCFCheckedExceptionBase)e.getCause()).getReportedErrorMessageId().equals("OMAG-MULTI-TENANT-404-001")) {
                return null;
            }
            throw DinoExceptionHandler.mapOMAGConfigurationErrorException((String)this.getClass().getName(), (String)methodName, (String)serverName, (OMAGConfigurationErrorException)e);
        }
    }

    public EngineDetails serverGetEngineDetails(String userId, String serverName, String platformName, String engineQualifiedName, String methodName) throws DinoViewServiceException {
        try {
            String platformRootURL = this.resolvePlatformRootURL(platformName, methodName);
            GovernanceEngineConfigurationClient gecc = this.getGovernanceEngineConfigurationClient(userId, serverName, platformRootURL);
            GovernanceEngineElement governanceEngineElement = gecc.getGovernanceEngineByName(userId, engineQualifiedName);
            if (governanceEngineElement == null) {
                throw new DinoViewServiceException(DinoViewErrorCode.COULD_NOT_RETRIEVE_GOVERNANCE_ENGINE.getMessageDefinition(new String[]{methodName, engineQualifiedName}), this.getClass().getName(), methodName);
            }
            EngineDetails engineDetails = new EngineDetails();
            engineDetails.setEngineDisplayName(governanceEngineElement.getProperties().getDisplayName());
            engineDetails.setEngineQualifiedName(governanceEngineElement.getProperties().getQualifiedName());
            engineDetails.setEngineDescription(governanceEngineElement.getProperties().getDescription());
            engineDetails.setEngineTypeDescription(governanceEngineElement.getProperties().getTypeDescription());
            engineDetails.setEngineVersion(governanceEngineElement.getProperties().getVersion());
            engineDetails.setEngineGUID(governanceEngineElement.getElementHeader().getGUID());
            String governanceEngineGUID = governanceEngineElement.getElementHeader().getGUID();
            List governanceServices = gecc.getRegisteredGovernanceServices(userId, governanceEngineGUID, 0, 100);
            if (governanceServices != null && governanceServices.size() > 0) {
                HashMap<String, ServicePropertiesAndRequests> serviceMap = new HashMap<String, ServicePropertiesAndRequests>();
                for (int i = 0; i < governanceServices.size(); ++i) {
                    String governanceServiceGUID = (String)governanceServices.get(i);
                    GovernanceServiceElement gse = gecc.getGovernanceServiceByGUID(userId, governanceServiceGUID);
                    GovernanceServiceProperties gsp = gse.getProperties();
                    String governanceServiceQualifiedName = gsp.getQualifiedName();
                    RegisteredGovernanceServiceElement rgse = gecc.getRegisteredGovernanceService(userId, governanceEngineGUID, governanceServiceGUID);
                    RegisteredGovernanceService rgs = rgse.getProperties();
                    Map requestTypes = rgs.getRequestTypes();
                    ServicePropertiesAndRequests spar = new ServicePropertiesAndRequests(gsp, requestTypes);
                    serviceMap.put(governanceServiceQualifiedName, spar);
                }
                engineDetails.setServiceMap(serviceMap);
            }
            return engineDetails;
        }
        catch (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException e) {
            throw DinoExceptionHandler.mapInvalidParameterException((String)this.getClass().getName(), (String)methodName, (org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException)e);
        }
        catch (UserNotAuthorizedException e) {
            throw DinoExceptionHandler.mapUserNotAuthorizedException((String)this.getClass().getName(), (String)methodName, (UserNotAuthorizedException)e);
        }
        catch (PropertyServerException e) {
            throw DinoExceptionHandler.mapOCFPropertyServerException((String)this.getClass().getName(), (String)methodName, (String)platformName, (PropertyServerException)e);
        }
    }
}

