/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.dino.server;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoEngineDetailsResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoEngineRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoPlatformOverviewResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoPlatformRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoResourceEndpointListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerAuditLogResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerConfigResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerDoubleConfigResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerOverviewResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServerTypeResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServiceDetailsResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServiceListResponse;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoServiceRequestBody;
import org.odpi.openmetadata.viewservices.dino.api.rest.DinoStringResponse;
import org.odpi.openmetadata.viewservices.dino.server.DinoViewRESTServices;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{viewServerName}/open-metadata/view-services/dino/users/{userId}"})
@Tag(name="Dino OMVS", description="Explore topology information in an Egeria deployment of platforms, servers, services and cohorts for graph visualization.", externalDocs=@ExternalDocumentation(description="Dino View Service (OMVS)", url="https://egeria-project.org/services/omvs/dino/overview/"))
public class DinoViewRESTResource {
    private DinoViewRESTServices restAPI = new DinoViewRESTServices();

    @GetMapping(value={"/resource-endpoints"})
    public DinoResourceEndpointListResponse getResourceEndpoints(@PathVariable String viewServerName, @PathVariable String userId) {
        return this.restAPI.getResourceEndpointList(viewServerName, userId);
    }

    @PostMapping(value={"/platform/{platformName}"})
    public DinoPlatformOverviewResponse getPlatformOverview(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetOverview(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/platform/{platformName}/origin"})
    public DinoStringResponse getPlatformOrigin(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetOrigin(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/platform/{platformName}/servers/active"})
    public DinoServerListResponse getActiveServers(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetActiveServers(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/platform/{platformName}/servers"})
    public DinoServerListResponse getKnownServers(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetKnownServers(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/platform/{platformName}/registered-services/access-services"})
    public DinoServiceListResponse getAccessServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetAccessServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/platform/{platformName}/registered-services/view-services"})
    public DinoServiceListResponse getViewServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetViewServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/platform/{platformName}/registered-services/governance-services"})
    public DinoServiceListResponse getGovernanceServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetGovernanceServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/platform/{platformName}/registered-services/common-services"})
    public DinoServiceListResponse getCommonServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String platformName, @RequestBody DinoPlatformRequestBody requestBody) {
        return this.restAPI.platformGetCommonServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}"})
    public DinoServerOverviewResponse getServerOverview(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServerRequestBody requestBody) {
        return this.restAPI.serverGetOverview(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/origin"})
    public DinoStringResponse getServerOrigin(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServerRequestBody requestBody) {
        return this.restAPI.serverGetOrigin(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/server-type-classification"})
    public DinoServerTypeResponse getServerTypeClassification(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServerRequestBody requestBody) {
        return this.restAPI.serverGetTypeClassification(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/configuration"})
    public DinoServerConfigResponse getServerStoredConfiguration(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServerRequestBody requestBody) {
        return this.restAPI.serverGetStoredConfiguration(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/instance/configuration"})
    public DinoServerConfigResponse getServerInstanceConfiguration(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServerRequestBody requestBody) {
        return this.restAPI.serverGetInstanceConfiguration(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/stored-and-active-configuration"})
    public DinoServerDoubleConfigResponse getServerStoredAndActiveConfiguration(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServerRequestBody requestBody) {
        return this.restAPI.serverGetStoredAndActiveConfiguration(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/audit-log"})
    public DinoServerAuditLogResponse getServerAuditLog(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServerRequestBody requestBody) {
        return this.restAPI.serverGetAuditLog(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/integration-services"})
    public DinoServiceListResponse getServerIntegrationServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetIntegrationServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/engine-services"})
    public DinoServiceListResponse getServerEngineServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetEngineServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/access-services"})
    public DinoServiceListResponse getServerAccessServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetAccessServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/view-services"})
    public DinoServiceListResponse getServerViewServices(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetViewServices(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/integration-service-details"})
    public DinoServiceDetailsResponse getServerIntegrationServiceDetails(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetIntegrationServiceDetails(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/engine-service-details"})
    public DinoServiceDetailsResponse getServerEngineServiceDetails(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetEngineServiceDetails(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/access-service-details"})
    public DinoServiceDetailsResponse getServerAccessServiceDetails(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetAccessServiceDetails(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/view-service-details"})
    public DinoServiceDetailsResponse getServerViewServiceDetails(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoServiceRequestBody requestBody) {
        return this.restAPI.serverGetViewServiceDetails(viewServerName, userId, requestBody);
    }

    @PostMapping(value={"/server/{serverName}/engine-details"})
    public DinoEngineDetailsResponse getServerEngineServiceDetails(@PathVariable String viewServerName, @PathVariable String userId, @PathVariable String serverName, @RequestBody DinoEngineRequestBody requestBody) {
        return this.restAPI.serverGetEngineDetails(viewServerName, userId, requestBody);
    }
}

