/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineConfigurationEvent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DiscoveryServiceConfigurationEvent
extends DiscoveryEngineConfigurationEvent {
    private static final long serialVersionUID = 1L;
    private String registeredDiscoveryServiceGUID = null;
    private List<String> discoveryRequestTypes = null;
    private Map<String, String> defaultAnalysisParameters = null;

    public DiscoveryServiceConfigurationEvent() {
    }

    public DiscoveryServiceConfigurationEvent(DiscoveryServiceConfigurationEvent template) {
        super(template);
        if (template != null) {
            this.registeredDiscoveryServiceGUID = template.getRegisteredDiscoveryServiceGUID();
            this.discoveryRequestTypes = template.getDiscoveryRequestTypes();
            this.defaultAnalysisParameters = template.getDefaultAnalysisParameters();
        }
    }

    public String getRegisteredDiscoveryServiceGUID() {
        return this.registeredDiscoveryServiceGUID;
    }

    public void setRegisteredDiscoveryServiceGUID(String registeredDiscoveryServiceGUID) {
        this.registeredDiscoveryServiceGUID = registeredDiscoveryServiceGUID;
    }

    public List<String> getDiscoveryRequestTypes() {
        if (this.discoveryRequestTypes == null) {
            return null;
        }
        if (this.discoveryRequestTypes.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.discoveryRequestTypes);
    }

    public void setDiscoveryRequestTypes(List<String> discoveryRequestTypes) {
        this.discoveryRequestTypes = discoveryRequestTypes;
    }

    public Map<String, String> getDefaultAnalysisParameters() {
        if (this.defaultAnalysisParameters == null) {
            return null;
        }
        if (this.defaultAnalysisParameters.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.defaultAnalysisParameters);
    }

    public void setDefaultAnalysisParameters(Map<String, String> defaultAnalysisParameters) {
        this.defaultAnalysisParameters = defaultAnalysisParameters;
    }

    @Override
    public String toString() {
        return "DiscoveryServiceConfigurationEvent{registeredDiscoveryServiceGUID='" + this.registeredDiscoveryServiceGUID + '\'' + ", discoveryRequestTypes=" + this.discoveryRequestTypes + ", defaultAnalysisParameters=" + this.defaultAnalysisParameters + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DiscoveryServiceConfigurationEvent that = (DiscoveryServiceConfigurationEvent)objectToCompare;
        return Objects.equals(this.registeredDiscoveryServiceGUID, that.registeredDiscoveryServiceGUID) && Objects.equals(this.discoveryRequestTypes, that.discoveryRequestTypes) && Objects.equals(this.defaultAnalysisParameters, that.defaultAnalysisParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.registeredDiscoveryServiceGUID, this.discoveryRequestTypes, this.defaultAnalysisParameters);
    }
}

