/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.ODFOMASAPIRequestBody;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DiscoveryServiceRegistrationRequestBody
extends ODFOMASAPIRequestBody {
    private static final long serialVersionUID = 1L;
    private String discoveryServiceGUID = null;
    private String discoveryRequestType = null;
    private Map<String, String> defaultAnalysisParameters = null;

    public DiscoveryServiceRegistrationRequestBody() {
    }

    public DiscoveryServiceRegistrationRequestBody(DiscoveryServiceRegistrationRequestBody template) {
        super(template);
        if (template != null) {
            this.discoveryServiceGUID = template.getDiscoveryServiceGUID();
            this.discoveryRequestType = template.getDiscoveryRequestType();
            this.defaultAnalysisParameters = template.getDefaultAnalysisParameters();
        }
    }

    public String getDiscoveryServiceGUID() {
        return this.discoveryServiceGUID;
    }

    public void setDiscoveryServiceGUID(String discoveryServiceGUID) {
        this.discoveryServiceGUID = discoveryServiceGUID;
    }

    public String getDiscoveryRequestType() {
        return this.discoveryRequestType;
    }

    public void setDiscoveryRequestType(String discoveryRequestType) {
        this.discoveryRequestType = discoveryRequestType;
    }

    public Map<String, String> getDefaultAnalysisParameters() {
        if (this.defaultAnalysisParameters == null) {
            return null;
        }
        if (this.defaultAnalysisParameters.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.defaultAnalysisParameters);
    }

    public void setDefaultAnalysisParameters(Map<String, String> defaultAnalysisParameters) {
        this.defaultAnalysisParameters = defaultAnalysisParameters;
    }

    @Override
    public String toString() {
        return "DiscoveryServiceRegistrationRequestBody{discoveryServiceGUID='" + this.discoveryServiceGUID + '\'' + ", discoveryRequestType=" + this.discoveryRequestType + ", defaultAnalysisParameters=" + this.defaultAnalysisParameters + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        DiscoveryServiceRegistrationRequestBody that = (DiscoveryServiceRegistrationRequestBody)objectToCompare;
        return Objects.equals(this.discoveryServiceGUID, that.discoveryServiceGUID) && Objects.equals(this.discoveryRequestType, that.discoveryRequestType) && Objects.equals(this.defaultAnalysisParameters, that.defaultAnalysisParameters);
    }

    public int hashCode() {
        return Objects.hash(this.discoveryServiceGUID, this.discoveryRequestType, this.defaultAnalysisParameters);
    }
}

