/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineConfigurationEvent;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DiscoveryServiceConfigurationEvent
extends DiscoveryEngineConfigurationEvent {
    private static final long serialVersionUID = 1L;
    private String registeredDiscoveryServiceGUID = null;
    private String discoveryRequestType = null;
    private Map<String, String> defaultAnalysisParameters = null;

    public DiscoveryServiceConfigurationEvent() {
    }

    public DiscoveryServiceConfigurationEvent(DiscoveryServiceConfigurationEvent template) {
        super(template);
        if (template != null) {
            this.registeredDiscoveryServiceGUID = template.getRegisteredDiscoveryServiceGUID();
            this.discoveryRequestType = template.getDiscoveryRequestType();
            this.defaultAnalysisParameters = template.getDefaultAnalysisParameters();
        }
    }

    public String getRegisteredDiscoveryServiceGUID() {
        return this.registeredDiscoveryServiceGUID;
    }

    public void setRegisteredDiscoveryServiceGUID(String registeredDiscoveryServiceGUID) {
        this.registeredDiscoveryServiceGUID = registeredDiscoveryServiceGUID;
    }

    public String getDiscoveryRequestType() {
        return this.discoveryRequestType;
    }

    public void setDiscoveryRequestType(String discoveryRequestType) {
        this.discoveryRequestType = discoveryRequestType;
    }

    public Map<String, String> getDefaultAnalysisParameters() {
        if (this.defaultAnalysisParameters == null) {
            return null;
        }
        if (this.defaultAnalysisParameters.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.defaultAnalysisParameters);
    }

    public void setDefaultAnalysisParameters(Map<String, String> defaultAnalysisParameters) {
        this.defaultAnalysisParameters = defaultAnalysisParameters;
    }

    @Override
    public String toString() {
        return "DiscoveryServiceConfigurationEvent{registeredDiscoveryServiceGUID='" + this.registeredDiscoveryServiceGUID + "', discoveryRequestType=" + this.discoveryRequestType + ", defaultAnalysisParameters=" + this.defaultAnalysisParameters + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DiscoveryServiceConfigurationEvent that = (DiscoveryServiceConfigurationEvent)objectToCompare;
        return Objects.equals(this.registeredDiscoveryServiceGUID, that.registeredDiscoveryServiceGUID) && Objects.equals(this.discoveryRequestType, that.discoveryRequestType) && Objects.equals(this.defaultAnalysisParameters, that.defaultAnalysisParameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.registeredDiscoveryServiceGUID, this.discoveryRequestType, this.defaultAnalysisParameters);
    }
}

