/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum DiscoveryEngineErrorCode implements ExceptionMessageSet
{
    NULL_LISTENER(500, "OMAS-DISCOVERY-ENGINE-400-017", "A null topic listener has been passed by user {0} on method {1}", "There is a coding error in the caller to the Discovery Engine OMAS.", "Correct the caller logic and retry the request."),
    OMRS_NOT_INITIALIZED(404, "OMAS-DISCOVERY-ENGINE-404-002", "The open metadata repository services are not initialized for the {0} operation", "The system is unable to connect to the open metadata property server.", "Check that the server where the Discovery Engine OMAS is running initialized correctly.  Correct any errors discovered and retry the request when the open metadata services are available."),
    UNABLE_TO_SEND_EVENT(500, "OMAS-DISCOVERY-ENGINE-500-004", "An unexpected exception occurred when sending an event through connector {0} to the Discovery Engine OMAS out topic.  The failing event was {1}, the exception was {2} with message {2}", "The access service has issued a call to publish an event on its Out Topic and it failed.", "Look for errors in the event bus to understand why this is failing.  When the event bus is operating correctly, the event will be able to be published again.  In the meantime, events are being lost."),
    UNEXPECTED_INITIALIZATION_EXCEPTION(503, "OMAS-DISCOVERY-ENGINE-503-005", "A {0} exception was caught during start up of service {1} for server {2}. The error message was: {3}", "The system detected an unexpected error during start up and is now in an unknown state.", "The error message should indicate the cause of the error.  Otherwise look for errors in the remote server's audit log and console to understand and correct the source of the error.");

    private final ExceptionMessageDefinition messageDefinition;

    private DiscoveryEngineErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.messageDefinition = new ExceptionMessageDefinition(httpErrorCode, errorMessageId, errorMessage, systemAction, userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return this.messageDefinition;
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        this.messageDefinition.setMessageParameters(params);
        return this.messageDefinition;
    }

    public String toString() {
        return "DiscoveryEngineErrorCode{messageDefinition=" + this.messageDefinition + "}";
    }
}

