/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;

public class DiscoveryAnnotationStoreClient
extends DiscoveryAnnotationStore {
    private DiscoveryEngineClient discoveryEngineClient;

    public DiscoveryAnnotationStoreClient(String userId, String assetGUID, String discoveryReportGUID, DiscoveryEngineClient discoveryEngineClient) {
        super(userId, assetGUID, discoveryReportGUID);
        this.discoveryEngineClient = discoveryEngineClient;
    }

    public List<Annotation> getPreviousAnnotationsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAnnotationsForAssetByStatus(this.userId, this.assetGUID, null, startingFrom, maximumResults);
    }

    public List<Annotation> getPreviousAnnotationsForAsset(AnnotationStatus status, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAnnotationsForAssetByStatus(this.userId, this.assetGUID, status, startingFrom, maximumResults);
    }

    public List<Annotation> getNewAnnotationsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNewAnnotationsForAsset";
        return this.discoveryEngineClient.getDiscoveryReportAnnotations(this.userId, this.discoveryReportGUID, startingFrom, maximumResults, "getNewAnnotationsForAsset");
    }

    public List<Annotation> getExtendedAnnotations(String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getExtendedAnnotations(this.userId, this.discoveryReportGUID, annotationGUID, startingFrom, maximumResults);
    }

    public Annotation getAnnotation(String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAnnotation(this.userId, this.discoveryReportGUID, annotationGUID);
    }

    public String addAnnotationToDiscoveryReport(Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addAnnotationToDiscoveryReport(this.userId, this.discoveryReportGUID, annotation);
    }

    public String addAnnotationToAnnotation(String anchorAnnotationGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addAnnotationToAnnotation(this.userId, this.discoveryReportGUID, anchorAnnotationGUID, annotation);
    }

    public void linkAnnotation(String anchorGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineClient.linkAnnotation(this.userId, this.discoveryReportGUID, anchorGUID, annotationGUID);
    }

    public void unlinkAnnotation(String anchorGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineClient.unlinkAnnotation(this.userId, this.discoveryReportGUID, anchorGUID, annotationGUID);
    }

    public Annotation updateAnnotation(Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.updateAnnotation(this.userId, this.discoveryReportGUID, annotation);
    }

    public void deleteAnnotation(String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineClient.deleteAnnotation(this.userId, this.discoveryReportGUID, annotationGUID);
    }

    public List<DataField> getPreviousDataFieldsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getPreviousDataFieldsForAsset(this.userId, this.discoveryReportGUID, startingFrom, maximumResults);
    }

    public List<Annotation> getNewDataFieldsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getNewDataFieldsForAsset(this.userId, this.discoveryReportGUID, startingFrom, maximumResults);
    }

    public List<DataField> getNestedDataFields(String anchorDataFieldGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getNestedDataFields(this.userId, this.discoveryReportGUID, anchorDataFieldGUID, startingFrom, maximumResults);
    }

    public DataField getDataField(String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getDataField(this.userId, this.discoveryReportGUID, dataFieldGUID);
    }

    public String addDataFieldToDiscoveryReport(String annotationGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addDataFieldToDiscoveryReport(this.userId, this.discoveryReportGUID, annotationGUID, dataField);
    }

    public String addDataFieldToDataField(String anchorDataFieldGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addDataFieldToDataField(this.userId, this.discoveryReportGUID, anchorDataFieldGUID, dataField);
    }

    public String addAnnotationToDataField(String anchorDataFieldGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addAnnotationToDataField(this.userId, this.discoveryReportGUID, anchorDataFieldGUID, annotation);
    }

    public DataField updateDataField(DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.updateDataField(this.userId, this.discoveryReportGUID, dataField);
    }

    public void deleteDataField(String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineClient.deleteDataField(this.userId, this.discoveryReportGUID, dataFieldGUID);
    }
}

