/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.client;

import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetStore;

public class DiscoveryAssetStoreClient
extends DiscoveryAssetStore {
    private DiscoveryEngineClient discoveryEngineClient;

    public DiscoveryAssetStoreClient(String assetGUID, String userId, DiscoveryEngineClient discoveryEngineClient) {
        super(assetGUID, userId);
        this.discoveryEngineClient = discoveryEngineClient;
    }

    protected Connection getConnectionForAsset() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getConnectionForAsset(this.userId, this.assetGUID);
    }

    public Connector getConnectorByConnection(Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        return this.discoveryEngineClient.getConnectorForConnection(this.userId, connection);
    }

    public AssetUniverse getAssetProperties() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.discoveryEngineClient.getAssetProperties(this.userId, this.assetGUID);
    }

    public void logAssetAuditMessage(String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.discoveryEngineClient.logAssetAuditMessage(this.userId, this.assetGUID, message);
    }
}

