/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.client.ODFRESTClient;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Classification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;

public class DiscoveryEngineClient
extends ConnectedAssetClientBase {
    private ODFRESTClient restClient;
    private static final String serviceURLName = "discovery-engine";

    public DiscoveryEngineClient(String serverName, String serverPlatformRootURL, ODFRESTClient restClient) throws InvalidParameterException {
        super(serverName, serverPlatformRootURL);
        this.restClient = restClient;
    }

    Connection getConnectionForAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionForAsset";
        String guidParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionForAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectionForAsset");
        return super.getConnectionForAsset((OCFRESTClient)this.restClient, serviceURLName, userId, assetGUID);
    }

    public Connector getConnectorForConnection(String userId, Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnectorForConnection";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorForConnection");
        return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connection, "getConnectorForConnection");
    }

    AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    public void logAssetAuditMessage(String userId, String assetGUID, String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }

    public DiscoveryAnalysisReport createDiscoveryAnalysisReport(String userId, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, DiscoveryRequestStatus discoveryRequestStatus, String assetGUID, String discoveryEngineGUID, String discoveryServiceGUID, Map<String, String> additionalProperties, List<Classification> classifications) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDiscoveryAnalysisReport";
        String nameParameterName = "qualifiedName";
        String assetGUIDParameterName = "assetGUID";
        String discoveryEngineGUIDParameterName = "discoveryEngineGUID";
        String discoveryServiceGUIDParameterName = "discoveryServiceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/discovery-analysis-reports";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateUserId(userId, "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "createDiscoveryAnalysisReport");
        DiscoveryAnalysisReportRequestBody requestBody = new DiscoveryAnalysisReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setCreationDate(creationDate);
        requestBody.setAnalysisParameters(analysisParameters);
        requestBody.setDiscoveryRequestStatus(discoveryRequestStatus);
        requestBody.setDiscoveryEngineGUID(discoveryEngineGUID);
        requestBody.setDiscoveryServiceGUID(discoveryServiceGUID);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setClassifications(classifications);
        DiscoveryAnalysisReportResponse restResult = this.restClient.callDiscoveryAnalysisReportPostRESTCall("createDiscoveryAnalysisReport", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/discovery-analysis-reports", (Object)requestBody, new Object[]{this.serverName, userId, assetGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("createDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("createDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("createDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        return restResult.getAnalysisReport();
    }

    public DiscoveryAnalysisReport updateDiscoveryAnalysisReport(String userId, DiscoveryAnalysisReport updatedReport) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryAnalysisReport";
        String reportParameterName = "updatedReport";
        String reportGUIDParameterName = "updatedReport.getGUID()";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateObject((Object)updatedReport, "updatedReport", "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(updatedReport.getGUID(), "updatedReport.getGUID()", "updateDiscoveryAnalysisReport");
        DiscoveryAnalysisReportResponse restResult = this.restClient.callDiscoveryAnalysisReportPostRESTCall("updateDiscoveryAnalysisReport", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}", (Object)updatedReport, new Object[]{this.serverName, userId, updatedReport.getGUID()});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        return restResult.getAnalysisReport();
    }

    public DiscoveryRequestStatus getDiscoveryStatus(String userId, String discoveryReportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DiscoveryAnalysisReport report = this.getDiscoveryAnalysisReport(userId, discoveryReportGUID);
        if (report != null) {
            return report.getDiscoveryRequestStatus();
        }
        return null;
    }

    public void setDiscoveryStatus(String userId, String discoveryReportGUID, DiscoveryRequestStatus newStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DiscoveryAnalysisReport report = this.getDiscoveryAnalysisReport(userId, discoveryReportGUID);
        if (report != null) {
            report.setDiscoveryRequestStatus(newStatus);
            this.updateDiscoveryAnalysisReport(userId, report);
        }
    }

    public DiscoveryAnalysisReport getDiscoveryAnalysisReport(String userId, String discoveryReportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryAnalysisReport";
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "getDiscoveryAnalysisReport");
        DiscoveryAnalysisReportResponse restResult = this.restClient.callDiscoveryAnalysisReportGetRESTCall("getDiscoveryAnalysisReport", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}", new Object[]{this.serverName, userId, discoveryReportGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getDiscoveryAnalysisReport", (FFDCResponseBase)restResult);
        return restResult.getAnalysisReport();
    }

    List<Annotation> getAnnotationsForAssetByStatus(String userId, String assetGUID, AnnotationStatus status, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnnotationsForAssetByStatus";
        String assetGUIDParameterName = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/annotations?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAnnotationsForAssetByStatus");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAnnotationsForAssetByStatus");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAnnotationsForAssetByStatus");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(status);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getAnnotationsForAssetByStatus", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/annotations?startingFrom={3}&maximumResults={4}", (Object)requestBody, new Object[]{this.serverName, userId, assetGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getAnnotationsForAssetByStatus", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getAnnotationsForAssetByStatus", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getAnnotationsForAssetByStatus", (FFDCResponseBase)restResult);
        return restResult.getAnnotations();
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryReportAnnotations";
        return this.getDiscoveryReportAnnotations(userId, discoveryReportGUID, startingFrom, maximumResults, "getDiscoveryReportAnnotations");
    }

    List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall(methodName, this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations?startingFrom={3}&maximumResults={4}", new Object[]{this.serverName, userId, discoveryReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException(methodName, (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException(methodName, (FFDCResponseBase)restResult);
        return restResult.getAnnotations();
    }

    public List<Annotation> getExtendedAnnotations(String userId, String discoveryReportGUID, String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/extended-annotations?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall("getExtendedAnnotations", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/extended-annotations?startingFrom={3}&maximumResults={4}", new Object[]{this.serverName, userId, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getExtendedAnnotations", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getExtendedAnnotations", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getExtendedAnnotations", (FFDCResponseBase)restResult);
        return restResult.getAnnotations();
    }

    public Annotation getAnnotation(String userId, String discoveryReportGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnnotation";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getAnnotation");
        AnnotationResponse restResult = this.restClient.callAnnotationGetRESTCall("getAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}", new Object[]{this.serverName, userId, annotationGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("getAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("getAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("getAnnotation", (FFDCResponseBase)restResult);
        return restResult.getAnnotation();
    }

    String addAnnotationToDiscoveryReport(String userId, String discoveryReportGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAnnotationToDiscoveryReport";
        String annotationParameterName = "annotation";
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations";
        this.invalidParameterHandler.validateUserId(userId, "addAnnotationToDiscoveryReport");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "addAnnotationToDiscoveryReport");
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", "addAnnotationToDiscoveryReport");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAnnotationToDiscoveryReport", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations", (Object)annotation, new Object[]{this.serverName, userId, discoveryReportGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addAnnotationToDiscoveryReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addAnnotationToDiscoveryReport", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addAnnotationToDiscoveryReport", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    String addAnnotationToAnnotation(String userId, String discoveryReportGUID, String anchorAnnotationGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAnnotationToAnnotation";
        String annotationGUIDParameterName = "anchorAnnotationGUID";
        String annotationParameterName = "annotation";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/extended-annotations";
        this.invalidParameterHandler.validateUserId(userId, "addAnnotationToAnnotation");
        this.invalidParameterHandler.validateGUID(anchorAnnotationGUID, "anchorAnnotationGUID", "addAnnotationToAnnotation");
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", "addAnnotationToAnnotation");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAnnotationToAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/extended-annotations", (Object)annotation, new Object[]{this.serverName, userId, discoveryReportGUID, anchorAnnotationGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("addAnnotationToAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("addAnnotationToAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("addAnnotationToAnnotation", (FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    void linkAnnotation(String userId, String discoveryReportGUID, String anchorGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkAnnotation";
        String anchorGUIDParameterName = "anchorGUID";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/related-instances/{4}";
        this.invalidParameterHandler.validateUserId(userId, "linkAnnotation");
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", "linkAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "linkAnnotation");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("linkAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/related-instances/{4}", (Object)this.nullRequestBody, new Object[]{this.serverName, userId, discoveryReportGUID, annotationGUID, anchorGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("linkAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("linkAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("linkAnnotation", (FFDCResponseBase)restResult);
    }

    void unlinkAnnotation(String userId, String discoveryReportGUID, String anchorGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkAnnotation";
        String anchorGUIDParameterName = "anchorGUID";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/related-instances{4}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkAnnotation");
        this.invalidParameterHandler.validateGUID(anchorGUID, "anchorGUID", "unlinkAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "unlinkAnnotation");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("unlinkAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/related-instances{4}/delete", (Object)this.nullRequestBody, new Object[]{this.serverName, userId, discoveryReportGUID, annotationGUID, anchorGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("unlinkAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("unlinkAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("unlinkAnnotation", (FFDCResponseBase)restResult);
    }

    Annotation updateAnnotation(String userId, String discoveryReportGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAnnotation";
        String annotationParameterName = "annotation";
        String annotationGUIDParameterName = "annotation.getGUID()";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}";
        this.invalidParameterHandler.validateUserId(userId, "updateAnnotation");
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", "updateAnnotation");
        this.invalidParameterHandler.validateGUID(annotation.getGUID(), "annotation.getGUID()", "updateAnnotation");
        AnnotationResponse restResult = this.restClient.callAnnotationPostRESTCall("updateAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}", (Object)annotation, new Object[]{this.serverName, userId, discoveryReportGUID, annotation.getGUID()});
        this.exceptionHandler.detectAndThrowInvalidParameterException("updateAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("updateAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("updateAnnotation", (FFDCResponseBase)restResult);
        return restResult.getAnnotation();
    }

    void deleteAnnotation(String userId, String discoveryReportGUID, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAnnotation";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "deleteAnnotation");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteAnnotation", this.serverPlatformRootURL + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations/{3}/delete", (Object)this.nullRequestBody, new Object[]{this.serverName, userId, discoveryReportGUID, annotationGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException("deleteAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException("deleteAnnotation", (FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException("deleteAnnotation", (FFDCResponseBase)restResult);
    }

    List<DataField> getPreviousDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    List<Annotation> getNewDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    List<DataField> getNestedDataFields(String userId, String discoveryReportGUID, String anchorDataFieldGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    DataField getDataField(String userId, String discoveryReportGUID, String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    String addDataFieldToDiscoveryReport(String userId, String discoveryReportGUID, String annotationGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    String addDataFieldToDataField(String userId, String discoveryReportGUID, String anchorDataFieldGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    String addAnnotationToDataField(String userId, String discoveryReportGUID, String anchorDataFieldGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    DataField updateDataField(String userId, String discoveryReportGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    void deleteDataField(String userId, String discoveryReportGUID, String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }
}

