/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAnalysisReportClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnalysisReportStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;

public class DiscoveryAnnotationStoreClient
extends DiscoveryAnnotationStore {
    private DiscoveryEngineClient discoveryEngineClient;

    public DiscoveryAnnotationStoreClient(String userId, String assetGUID, DiscoveryAnalysisReportClient discoveryAnalysisReportClient, DiscoveryEngineClient discoveryEngineClient) {
        super(userId, assetGUID, (DiscoveryAnalysisReportStore)discoveryAnalysisReportClient);
        this.discoveryEngineClient = discoveryEngineClient;
    }

    public List<String> getTypesOfAnnotation() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getTypesOfAnnotation(this.userId);
    }

    public Map<String, String> getTypesOfAnnotationWithDescriptions() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getTypesOfAnnotationWithDescriptions(this.userId);
    }

    public List<Annotation> getPreviousAnnotationsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAnnotationsForAssetByStatus(this.userId, this.assetGUID, null, startingFrom, maximumResults);
    }

    public List<Annotation> getPreviousAnnotationsForAsset(AnnotationStatus status, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAnnotationsForAssetByStatus(this.userId, this.assetGUID, status, startingFrom, maximumResults);
    }

    public List<Annotation> getNewAnnotationsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNewAnnotationsForAsset";
        return this.discoveryEngineClient.getDiscoveryReportAnnotations(this.userId, this.discoveryReport.getDiscoveryReportGUID(), startingFrom, maximumResults, "getNewAnnotationsForAsset");
    }

    public List<Annotation> getExtendedAnnotations(String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getExtendedAnnotations(this.userId, this.discoveryReport.getDiscoveryReportGUID(), annotationGUID, startingFrom, maximumResults);
    }

    public Annotation getAnnotation(String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAnnotation(this.userId, this.discoveryReport.getDiscoveryReportGUID(), annotationGUID);
    }

    public String addAnnotationToDiscoveryReport(Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addAnnotationToDiscoveryReport(this.userId, this.discoveryReport.getDiscoveryReportGUID(), annotation);
    }

    public String addAnnotationToAnnotation(String anchorAnnotationGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addAnnotationToAnnotation(this.userId, this.discoveryReport.getDiscoveryReportGUID(), anchorAnnotationGUID, annotation);
    }

    public void updateAnnotation(Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineClient.updateAnnotation(this.userId, this.discoveryReport.getDiscoveryReportGUID(), annotation);
    }

    public void deleteAnnotation(String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineClient.deleteAnnotation(this.userId, this.discoveryReport.getDiscoveryReportGUID(), annotationGUID);
    }

    public List<DataField> getPreviousDataFieldsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getPreviousDataFieldsForAsset(this.userId, this.discoveryReport.getDiscoveryReportGUID(), startingFrom, maximumResults);
    }

    public List<Annotation> getNewDataFieldsForAsset(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getNewDataFieldsForAsset(this.userId, this.discoveryReport.getDiscoveryReportGUID(), startingFrom, maximumResults);
    }

    public List<DataField> getNestedDataFields(String anchorDataFieldGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getNestedDataFields(this.userId, this.discoveryReport.getDiscoveryReportGUID(), anchorDataFieldGUID, startingFrom, maximumResults);
    }

    public DataField getDataField(String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getDataField(this.userId, this.discoveryReport.getDiscoveryReportGUID(), dataFieldGUID);
    }

    public String addDataFieldToDiscoveryReport(String annotationGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addDataFieldToDiscoveryReport(this.userId, this.discoveryReport.getDiscoveryReportGUID(), annotationGUID, dataField);
    }

    public String addDataFieldToDataField(String anchorDataFieldGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addDataFieldToDataField(this.userId, this.discoveryReport.getDiscoveryReportGUID(), anchorDataFieldGUID, dataField);
    }

    public String addAnnotationToDataField(String anchorDataFieldGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.addAnnotationToDataField(this.userId, this.discoveryReport.getDiscoveryReportGUID(), anchorDataFieldGUID, annotation);
    }

    public DataField updateDataField(DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.updateDataField(this.userId, this.discoveryReport.getDiscoveryReportGUID(), dataField);
    }

    public void deleteDataField(String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.discoveryEngineClient.deleteDataField(this.userId, this.discoveryReport.getDiscoveryReportGUID(), dataFieldGUID);
    }
}

