/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetCatalogStore;

public class DiscoveryAssetCatalogStoreClient
extends DiscoveryAssetCatalogStore {
    private DiscoveryEngineClient discoveryEngineClient;

    public DiscoveryAssetCatalogStoreClient(String userId, DiscoveryEngineClient discoveryEngineClient, int maxPageSize) {
        super(userId, maxPageSize);
        this.discoveryEngineClient = discoveryEngineClient;
    }

    public List<String> getAssets(int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAssets(this.userId, startFrom, pageSize);
    }

    public List<String> getAssetsByQualifiedName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAssetsByQualifiedName(this.userId, name, startFrom, pageSize);
    }

    public List<String> getAssetsByName(String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.getAssetsByName(this.userId, name, startFrom, pageSize);
    }

    public List<String> findAssets(String searchString, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.findAssets(this.userId, searchString, startFrom, pageSize);
    }

    public List<String> getAssetsByEndpoint(String networkAddress, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.discoveryEngineClient.findAssetsByEndpoint(this.userId, networkAddress, startFrom, pageSize);
    }
}

