/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.client;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.api.DiscoveryEngineEventInterface;
import org.odpi.openmetadata.accessservices.discoveryengine.api.DiscoveryEngineEventListener;
import org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic.DiscoveryEngineOutTopicClientConnector;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.ffdc.OMAGOCFErrorCode;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.rest.ConnectionResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.client.ODFRESTClient;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEngineListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEnginePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServicePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceRegistrationRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryServiceRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.RegisteredDiscoveryServiceResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryServiceRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBroker;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryConfigurationServer;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.RegisteredDiscoveryService;

public class DiscoveryConfigurationClient
extends DiscoveryConfigurationServer
implements DiscoveryEngineEventInterface {
    private static final String serviceName = "Discovery Engine OMAS";
    private String serverName;
    private String serverPlatformURLRoot;
    private ODFRESTClient restClient;
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private RESTExceptionHandler exceptionHandler = new RESTExceptionHandler();
    private NullRequestBody nullRequestBody = new NullRequestBody();
    private DiscoveryEngineOutTopicClientConnector configurationEventTopicConnector = null;
    private AuditLog auditLog = null;

    public DiscoveryConfigurationClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Constructor (no security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (no security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ODFRESTClient(serverName, serverPlatformURLRoot);
    }

    public DiscoveryConfigurationClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new ODFRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public DiscoveryConfigurationClient(String serverName, String serverPlatformURLRoot, ODFRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Constructor (with security)";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Constructor (with security)");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = restClient;
        this.auditLog = auditLog;
    }

    public String getConfigurationServerName() {
        return this.serverName;
    }

    public void registerListener(String userId, DiscoveryEngineEventListener listener) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "registerListener";
        String nameParameter = "listener";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/topics/out-topic-connection";
        this.invalidParameterHandler.validateUserId(userId, "registerListener");
        this.invalidParameterHandler.validateObject((Object)listener, "listener", "registerListener");
        if (this.configurationEventTopicConnector == null) {
            ConnectorBroker connectorBroker = new ConnectorBroker();
            ConnectionResponse restResult = this.restClient.callConnectionGetRESTCall("registerListener", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/topics/out-topic-connection", new Object[]{this.serverName, userId});
            Connection topicConnection = restResult.getConnection();
            Connector connector = connectorBroker.getConnector(topicConnection);
            if (connector == null) {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.NULL_CONNECTOR_RETURNED.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot}), ((Object)((Object)this)).getClass().getName(), "registerListener");
            }
            if (connector instanceof DiscoveryEngineOutTopicClientConnector) {
                this.configurationEventTopicConnector = (DiscoveryEngineOutTopicClientConnector)connector;
                this.configurationEventTopicConnector.setAuditLog(this.auditLog);
                this.configurationEventTopicConnector.start();
            } else {
                throw new ConnectorCheckedException(OMAGOCFErrorCode.WRONG_TYPE_OF_CONNECTOR.getMessageDefinition(new String[]{topicConnection.getQualifiedName(), serviceName, this.serverName, this.serverPlatformURLRoot, DiscoveryEngineOutTopicClientConnector.class.getName()}), ((Object)((Object)this)).getClass().getName(), "registerListener");
            }
        }
        this.configurationEventTopicConnector.registerListener(userId, listener);
    }

    public String createDiscoveryEngine(String userId, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDiscoveryEngine";
        String nameParameterName = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines";
        this.invalidParameterHandler.validateUserId(userId, "createDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createDiscoveryEngine");
        NewDiscoveryEngineRequestBody requestBody = new NewDiscoveryEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDiscoveryEngine", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines", (Object)requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public DiscoveryEngineProperties getDiscoveryEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryEngineByGUID";
        String guidParameterName = "guid";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryEngineByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDiscoveryEngineByGUID");
        DiscoveryEnginePropertiesResponse restResult = this.restClient.callDiscoveryEnginePropertiesGetRESTCall("getDiscoveryEngineByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}", new Object[]{this.serverName, userId, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getDiscoveryEngineProperties();
    }

    public DiscoveryEngineProperties getDiscoveryEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryEngineByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryEngineByName");
        this.invalidParameterHandler.validateName(name, "name", "getDiscoveryEngineByName");
        DiscoveryEnginePropertiesResponse restResult = this.restClient.callDiscoveryEnginePropertiesGetRESTCall("getDiscoveryEngineByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/by-name/{2}", new Object[]{this.serverName, userId, name});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getDiscoveryEngineProperties();
    }

    public List<DiscoveryEngineProperties> getAllDiscoveryEngines(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryEngines";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines?startingFrom={2}&maximumResults={3}";
        this.invalidParameterHandler.validateUserId(userId, "getAllDiscoveryEngines");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllDiscoveryEngines");
        DiscoveryEngineListResponse restResult = this.restClient.callDiscoveryEngineListGetRESTCall("getAllDiscoveryEngines", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines?startingFrom={2}&maximumResults={3}", new Object[]{this.serverName, userId, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getDiscoveryEngines();
    }

    public void updateDiscoveryEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateDiscoveryEngine");
        UpdateDiscoveryEngineRequestBody requestBody = new UpdateDiscoveryEngineRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setTypeDescription(typeDescription);
        requestBody.setVersion(version);
        requestBody.setPatchLevel(patchLevel);
        requestBody.setSource(source);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateDiscoveryEngine", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}", (Object)requestBody, new Object[]{this.serverName, userId, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public void deleteDiscoveryEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDiscoveryEngine";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}";
        this.invalidParameterHandler.validateUserId(userId, "deleteDiscoveryEngine");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteDiscoveryEngine");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteDiscoveryEngine", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}", (Object)requestBody, new Object[]{this.serverName, userId, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public String createDiscoveryService(String userId, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDiscoveryService";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services";
        this.invalidParameterHandler.validateUserId(userId, "createDiscoveryService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createDiscoveryService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "createDiscoveryService");
        NewDiscoveryServiceRequestBody requestBody = new NewDiscoveryServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setConnection(connection);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDiscoveryService", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services", (Object)requestBody, new Object[]{this.serverName, userId});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGUID();
    }

    public DiscoveryServiceProperties getDiscoveryServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryServiceByGUID";
        String guidParameterName = "guid";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryServiceByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDiscoveryServiceByGUID");
        DiscoveryServicePropertiesResponse restResult = this.restClient.callDiscoveryServicePropertiesGetRESTCall("getDiscoveryServiceByGUID", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}", new Object[]{this.serverName, userId, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getDiscoveryServiceProperties();
    }

    public DiscoveryServiceProperties getDiscoveryServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryServiceByName";
        String nameParameterName = "name";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/by-name/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryServiceByName");
        this.invalidParameterHandler.validateName(name, "name", "getDiscoveryServiceByName");
        DiscoveryServicePropertiesResponse restResult = this.restClient.callDiscoveryServicePropertiesGetRESTCall("getDiscoveryServiceByName", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/by-name/{2}", new Object[]{this.serverName, userId, name});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getDiscoveryServiceProperties();
    }

    public List<DiscoveryServiceProperties> getAllDiscoveryServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryServices";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services?startingFrom={2}&maximumResults={3}";
        this.invalidParameterHandler.validateUserId(userId, "getAllDiscoveryServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllDiscoveryServices");
        DiscoveryServiceListResponse restResult = this.restClient.callDiscoveryServiceListGetRESTCall("getAllDiscoveryServices", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services?startingFrom={2}&maximumResults={3}", new Object[]{this.serverName, userId, Integer.toString(startingFrom), Integer.toString(maximumResults)});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getDiscoveryServices();
    }

    public List<String> getDiscoveryServiceRegistrations(String userId, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryServices";
        String guidParameter = "discoveryServiceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}/registrations";
        this.invalidParameterHandler.validateUserId(userId, "getAllDiscoveryServices");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "getAllDiscoveryServices");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getAllDiscoveryServices", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}/registrations", new Object[]{this.serverName, userId, discoveryServiceGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public void updateDiscoveryService(String userId, String guid, String qualifiedName, String displayName, String shortDescription, String description, String owner, OwnerType ownerType, List<String> zoneMembership, Map<String, String> origin, String latestChange, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String connectionParameterName = "connection";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "updateDiscoveryService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateDiscoveryService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "updateDiscoveryService");
        UpdateDiscoveryServiceRequestBody requestBody = new UpdateDiscoveryServiceRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setShortDescription(shortDescription);
        requestBody.setDescription(description);
        requestBody.setOwner(owner);
        requestBody.setOwnerType(ownerType);
        requestBody.setZoneMembership(zoneMembership);
        requestBody.setOrigin(origin);
        requestBody.setLatestChange(latestChange);
        requestBody.setConnection(connection);
        requestBody.setAdditionalProperties(additionalProperties);
        requestBody.setExtendedProperties(extendedProperties);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("updateDiscoveryService", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}", (Object)requestBody, new Object[]{this.serverName, userId, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public void deleteDiscoveryService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDiscoveryService";
        String guidParameterName = "guid";
        String nameParameterName = "qualifiedName";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}";
        this.invalidParameterHandler.validateUserId(userId, "deleteDiscoveryService");
        this.invalidParameterHandler.validateGUID(guid, "guid", "deleteDiscoveryService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteDiscoveryService");
        DeleteRequestBody requestBody = new DeleteRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("deleteDiscoveryService", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-services/{2}", (Object)requestBody, new Object[]{this.serverName, userId, guid});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public void registerDiscoveryServiceWithEngine(String userId, String discoveryEngineGUID, String discoveryServiceGUID, List<String> discoveryRequestTypes, Map<String, String> defaultAnalysisParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerDiscoveryServiceWithEngine";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        String discoveryRequestTypesParameter = "discoveryRequestTypes";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services";
        this.invalidParameterHandler.validateUserId(userId, "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateStringArray(discoveryRequestTypes, "discoveryRequestTypes", "registerDiscoveryServiceWithEngine");
        DiscoveryServiceRegistrationRequestBody requestBody = new DiscoveryServiceRegistrationRequestBody();
        requestBody.setDiscoveryServiceGUID(discoveryServiceGUID);
        requestBody.setDiscoveryRequestTypes(discoveryRequestTypes);
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("registerDiscoveryServiceWithEngine", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services", (Object)requestBody, new Object[]{this.serverName, userId, discoveryEngineGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }

    public RegisteredDiscoveryService getRegisteredDiscoveryService(String userId, String discoveryEngineGUID, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredDiscoveryService";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services/{3}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredDiscoveryService");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "getRegisteredDiscoveryService");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "getRegisteredDiscoveryService");
        RegisteredDiscoveryServiceResponse restResult = this.restClient.callRegisteredDiscoveryServiceGetRESTCall("getRegisteredDiscoveryService", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services/{3}", new Object[]{this.serverName, userId, discoveryEngineGUID, discoveryServiceGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getRegisteredDiscoveryService();
    }

    public List<String> getRegisteredDiscoveryServices(String userId, String discoveryEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredDiscoveryServices";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredDiscoveryServices");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "getRegisteredDiscoveryServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredDiscoveryServices");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getRegisteredDiscoveryServices", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services?startingFrom={3}&maximumResults={4}", new Object[]{this.serverName, userId, discoveryEngineGUID, startingFrom, maximumResults});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
        return restResult.getGUIDs();
    }

    public void unregisterDiscoveryServiceFromEngine(String userId, String discoveryEngineGUID, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterDiscoveryServiceFromEngine";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unregisterDiscoveryServiceFromEngine");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "unregisterDiscoveryServiceFromEngine");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "unregisterDiscoveryServiceFromEngine");
        VoidResponse restResult = this.restClient.callVoidPostRESTCall("unregisterDiscoveryServiceFromEngine", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-engines/{2}/discovery-services/{3}/delete", (Object)this.nullRequestBody, new Object[]{this.serverName, userId, discoveryEngineGUID, discoveryServiceGUID});
        this.exceptionHandler.detectAndThrowInvalidParameterException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowUserNotAuthorizedException((FFDCResponseBase)restResult);
        this.exceptionHandler.detectAndThrowPropertyServerException((FFDCResponseBase)restResult);
    }
}

