/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.client;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.client.rest.ODFRESTClient;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationListResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.AnnotationResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DataFieldListResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DataFieldResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryAnalysisReportRequestBody;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.accessservices.discoveryengine.rest.StatusRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NameListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.StringMapResponse;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.OCFRESTClient;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DataField;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementHeader;

public class DiscoveryEngineClient
extends ConnectedAssetClientBase {
    private ODFRESTClient restClient;
    private static final String serviceURLName = "discovery-engine";

    public DiscoveryEngineClient(String serverName, String serverPlatformURLRoot, ODFRESTClient restClient, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = restClient;
    }

    public DiscoveryEngineClient(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new ODFRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public DiscoveryEngineClient(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new ODFRESTClient(serverName, serverPlatformURLRoot);
    }

    public DiscoveryEngineClient(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new ODFRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public DiscoveryEngineClient(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new ODFRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public DiscoveryEngineClient(String serverName, String serverPlatformURLRoot, ODFRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, maxPageSize, auditLog);
        this.restClient = restClient;
    }

    public List<String> getAssets(String userId, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets?startFrom={2}&pageSize={3}";
        String methodName = "getAssets";
        this.invalidParameterHandler.validateUserId(userId, "getAssets");
        GUIDListResponse restResult = this.restClient.callGUIDListGetRESTCall("getAssets", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets?startFrom={2}&pageSize={3}", new Object[]{this.serverName, userId, startFrom, pageSize});
        return restResult.getGUIDs();
    }

    private List<String> retrieveAssetGUIDList(String userId, String urlTemplate, String searchParameter, String searchParameterName, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchParameter, searchParameterName, methodName);
        GUIDListResponse restResult = this.restClient.callGUIDListPostRESTCall(methodName, this.serverPlatformURLRoot + urlTemplate, searchParameter, new Object[]{this.serverName, userId, startFrom, pageSize});
        return restResult.getGUIDs();
    }

    public List<String> getAssetsByQualifiedName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-qualified-name?startFrom={2}&pageSize={3}";
        String methodName = "getAssetsByQualifiedName";
        String searchParameterName = "name";
        return this.retrieveAssetGUIDList(userId, "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-qualified-name?startFrom={2}&pageSize={3}", name, "name", startFrom, pageSize, "getAssetsByQualifiedName");
    }

    public List<String> getAssetsByName(String userId, String name, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-name?startFrom={2}&pageSize={3}";
        String methodName = "getAssetsByName";
        String searchParameterName = "name";
        return this.retrieveAssetGUIDList(userId, "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-name?startFrom={2}&pageSize={3}", name, "name", startFrom, pageSize, "getAssetsByName");
    }

    public List<String> findAssets(String userId, String searchString, int startFrom, int pageSize) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}";
        String methodName = "findAssets";
        String searchParameterName = "searchString";
        return this.retrieveAssetGUIDList(userId, "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-search-string?startFrom={2}&pageSize={3}", searchString, "searchString", startFrom, pageSize, "findAssets");
    }

    public List<String> findAssetsByEndpoint(String userId, String networkAddress, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-endpoint-address?startFrom={2}&pageSize={3}";
        String methodName = "findAssetsByEndpoint";
        String searchParameterName = "networkAddress";
        return this.retrieveAssetGUIDList(userId, "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/by-endpoint-address?startFrom={2}&pageSize={3}", networkAddress, "networkAddress", startFrom, pageSize, "findAssetsByEndpoint");
    }

    Connection getConnectionForAsset(String userId, String assetGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConnectionForAsset";
        String guidParameterName = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getConnectionForAsset");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getConnectionForAsset");
        return super.getConnectionForAsset((OCFRESTClient)this.restClient, serviceURLName, userId, assetGUID);
    }

    public Connector getConnectorForConnection(String userId, Connection connection) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException {
        String methodName = "getConnectorForConnection";
        this.invalidParameterHandler.validateUserId(userId, "getConnectorForConnection");
        return super.getConnectorForConnection((OCFRESTClient)this.restClient, serviceURLName, userId, connection, "getConnectorForConnection");
    }

    AssetUniverse getAssetProperties(String userId, String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return super.getAssetProperties(serviceURLName, userId, assetGUID);
    }

    public void logAssetAuditMessage(String userId, String assetGUID, String discoveryService, String message) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "logAssetAuditMessage";
        String guidParameter = "assetGUID";
        String discoveryServiceParameter = "discoveryService";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/log-records/{3}";
        this.invalidParameterHandler.validateUserId(userId, "logAssetAuditMessage");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "logAssetAuditMessage");
        this.invalidParameterHandler.validateName(discoveryService, "discoveryService", "logAssetAuditMessage");
        this.restClient.callVoidPostRESTCall("logAssetAuditMessage", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/log-records/{3}", message, new Object[]{this.serverName, userId, assetGUID, discoveryService});
    }

    public String createDiscoveryAnalysisReport(String userId, String qualifiedName, String displayName, String description, Date creationDate, Map<String, String> analysisParameters, DiscoveryRequestStatus discoveryRequestStatus, String assetGUID, String discoveryEngineGUID, String discoveryServiceGUID, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDiscoveryAnalysisReport";
        String nameParameterName = "qualifiedName";
        String assetGUIDParameterName = "assetGUID";
        String discoveryEngineGUIDParameterName = "discoveryEngineGUID";
        String discoveryServiceGUIDParameterName = "discoveryServiceGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/discovery-analysis-reports";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateUserId(userId, "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "createDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "createDiscoveryAnalysisReport");
        DiscoveryAnalysisReportRequestBody requestBody = new DiscoveryAnalysisReportRequestBody();
        requestBody.setQualifiedName(qualifiedName);
        requestBody.setDisplayName(displayName);
        requestBody.setDescription(description);
        requestBody.setCreationDate(creationDate);
        requestBody.setAnalysisParameters(analysisParameters);
        requestBody.setDiscoveryRequestStatus(discoveryRequestStatus);
        requestBody.setDiscoveryEngineGUID(discoveryEngineGUID);
        requestBody.setDiscoveryServiceGUID(discoveryServiceGUID);
        requestBody.setAdditionalProperties(additionalProperties);
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("createDiscoveryAnalysisReport", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/discovery-analysis-reports", requestBody, new Object[]{this.serverName, userId, assetGUID});
        return restResult.getGUID();
    }

    public void updateDiscoveryAnalysisReport(String userId, DiscoveryAnalysisReport updatedReport) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryAnalysisReport";
        String reportParameterName = "updatedReport";
        String reportHeaderParameterName = "updatedReport.getElementHeader";
        String reportGUIDParameterName = "updatedReport.getGUID()";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateObject((Object)updatedReport, "updatedReport", "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateObject((Object)updatedReport.getElementHeader(), "updatedReport.getElementHeader", "updateDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(updatedReport.getElementHeader().getGUID(), "updatedReport.getGUID()", "updateDiscoveryAnalysisReport");
        this.restClient.callVoidPostRESTCall("updateDiscoveryAnalysisReport", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}", updatedReport, new Object[]{this.serverName, userId, updatedReport.getElementHeader().getGUID()});
    }

    public DiscoveryRequestStatus getDiscoveryStatus(String userId, String discoveryReportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DiscoveryAnalysisReport report = this.getDiscoveryAnalysisReport(userId, discoveryReportGUID);
        if (report != null) {
            return report.getDiscoveryRequestStatus();
        }
        return null;
    }

    public void setDiscoveryStatus(String userId, String discoveryReportGUID, DiscoveryRequestStatus newStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        DiscoveryAnalysisReport report = this.getDiscoveryAnalysisReport(userId, discoveryReportGUID);
        if (report != null) {
            report.setDiscoveryRequestStatus(newStatus);
            this.updateDiscoveryAnalysisReport(userId, report);
        }
    }

    public DiscoveryAnalysisReport getDiscoveryAnalysisReport(String userId, String discoveryReportGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryAnalysisReport";
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryAnalysisReport");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "getDiscoveryAnalysisReport");
        DiscoveryAnalysisReportResponse restResult = this.restClient.callDiscoveryAnalysisReportGetRESTCall("getDiscoveryAnalysisReport", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}", this.serverName, userId, discoveryReportGUID);
        return restResult.getAnalysisReport();
    }

    List<String> getTypesOfAnnotation(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotation";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/sub-types";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotation");
        NameListResponse restResult = this.restClient.callNameListGetRESTCall("getTypesOfAnnotation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/sub-types", new Object[]{this.serverName, userId});
        return restResult.getNames();
    }

    Map<String, String> getTypesOfAnnotationWithDescriptions(String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getTypesOfAnnotationWithDescriptions";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/sub-types/descriptions";
        this.invalidParameterHandler.validateUserId(userId, "getTypesOfAnnotationWithDescriptions");
        StringMapResponse restResult = this.restClient.callStringMapGetRESTCall("getTypesOfAnnotationWithDescriptions", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/sub-types/descriptions", new Object[]{this.serverName, userId});
        return restResult.getStringMap();
    }

    List<Annotation> getAnnotationsForAssetByStatus(String userId, String assetGUID, AnnotationStatus status, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnnotationsForAssetByStatus";
        String assetGUIDParameterName = "assetGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/annotations?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getAnnotationsForAssetByStatus");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getAnnotationsForAssetByStatus");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAnnotationsForAssetByStatus");
        StatusRequestBody requestBody = new StatusRequestBody();
        requestBody.setAnnotationStatus(status);
        AnnotationListResponse restResult = this.restClient.callAnnotationListPostRESTCall("getAnnotationsForAssetByStatus", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/assets/{2}/annotations?startingFrom={3}&maximumResults={4}", requestBody, this.serverName, userId, assetGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getAnnotations();
    }

    public List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryReportAnnotations";
        return this.getDiscoveryReportAnnotations(userId, discoveryReportGUID, startingFrom, maximumResults, "getDiscoveryReportAnnotations");
    }

    List<Annotation> getDiscoveryReportAnnotations(String userId, String discoveryReportGUID, int startingFrom, int maximumResults, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", methodName);
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, methodName);
        AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall(methodName, this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations?startingFrom={3}&maximumResults={4}", this.serverName, userId, discoveryReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getAnnotations();
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getExtendedAnnotations";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/extended-annotations?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getExtendedAnnotations");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getExtendedAnnotations");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getExtendedAnnotations");
        AnnotationListResponse restResult = this.restClient.callAnnotationListGetRESTCall("getExtendedAnnotations", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/extended-annotations?startingFrom={3}&maximumResults={4}", this.serverName, userId, annotationGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getAnnotations();
    }

    public Annotation getAnnotation(String userId, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnnotation";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "getAnnotation");
        AnnotationResponse restResult = this.restClient.callAnnotationGetRESTCall("getAnnotation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}", this.serverName, userId, annotationGUID);
        return restResult.getAnnotation();
    }

    String addAnnotationToDiscoveryReport(String userId, String discoveryReportGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAnnotationToDiscoveryReport";
        String annotationParameterName = "annotation";
        String reportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations";
        this.invalidParameterHandler.validateUserId(userId, "addAnnotationToDiscoveryReport");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "addAnnotationToDiscoveryReport");
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", "addAnnotationToDiscoveryReport");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAnnotationToDiscoveryReport", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/annotations", annotation, new Object[]{this.serverName, userId, discoveryReportGUID});
        return restResult.getGUID();
    }

    String addAnnotationToAnnotation(String userId, String parentAnnotationGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAnnotationToAnnotation";
        String annotationGUIDParameterName = "parentAnnotationGUID";
        String annotationParameterName = "annotation";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/extended-annotations";
        this.invalidParameterHandler.validateUserId(userId, "addAnnotationToAnnotation");
        this.invalidParameterHandler.validateGUID(parentAnnotationGUID, "parentAnnotationGUID", "addAnnotationToAnnotation");
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", "addAnnotationToAnnotation");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAnnotationToAnnotation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/extended-annotations", annotation, new Object[]{this.serverName, userId, parentAnnotationGUID});
        return restResult.getGUID();
    }

    void updateAnnotation(String userId, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateAnnotation";
        String annotationParameterName = "annotation";
        String headerParameterName = "annotation.getElementHeader()";
        String annotationGUIDParameterName = "annotation.getElementHeader().getGUID()";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateAnnotation");
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", "updateAnnotation");
        this.invalidParameterHandler.validateObject((Object)annotation.getElementHeader(), "annotation.getElementHeader()", "updateAnnotation");
        ElementHeader elementHeader = annotation.getElementHeader();
        this.invalidParameterHandler.validateGUID(elementHeader.getGUID(), "annotation.getElementHeader().getGUID()", "updateAnnotation");
        this.restClient.callVoidPostRESTCall("updateAnnotation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/update", annotation, new Object[]{this.serverName, userId, elementHeader.getGUID()});
    }

    void deleteAnnotation(String userId, String annotationGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteAnnotation";
        String annotationGUIDParameterName = "annotationGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteAnnotation");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "deleteAnnotation");
        this.restClient.callVoidPostRESTCall("deleteAnnotation", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/delete", nullRequestBody, new Object[]{this.serverName, userId, annotationGUID});
    }

    List<DataField> getPreviousDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPreviousDataFieldsForAsset";
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/data-fields/previous?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getPreviousDataFieldsForAsset");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "getPreviousDataFieldsForAsset");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getPreviousDataFieldsForAsset");
        DataFieldListResponse restResult = this.restClient.callDataFieldListGetRESTCall("getPreviousDataFieldsForAsset", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/data-fields/previous?startingFrom={3}&maximumResults={4}", this.serverName, userId, discoveryReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getDataFields();
    }

    List<DataField> getNewDataFieldsForAsset(String userId, String discoveryReportGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNewDataFieldsForAsset";
        String discoveryReportGUIDParameterName = "discoveryReportGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/data-fields?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getNewDataFieldsForAsset");
        this.invalidParameterHandler.validateGUID(discoveryReportGUID, "discoveryReportGUID", "getNewDataFieldsForAsset");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getNewDataFieldsForAsset");
        DataFieldListResponse restResult = this.restClient.callDataFieldListGetRESTCall("getNewDataFieldsForAsset", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/discovery-analysis-reports/{2}/data-fields?startingFrom={3}&maximumResults={4}", this.serverName, userId, discoveryReportGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getDataFields();
    }

    List<DataField> getNestedDataFields(String userId, String parentDataFieldGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getNestedDataFields";
        String dataFieldGUIDParameterName = "parentDataFieldGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/nested-data-fields?startingFrom={3}&maximumResults={4}";
        this.invalidParameterHandler.validateUserId(userId, "getNestedDataFields");
        this.invalidParameterHandler.validateGUID(parentDataFieldGUID, "parentDataFieldGUID", "getNestedDataFields");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getNestedDataFields");
        DataFieldListResponse restResult = this.restClient.callDataFieldListGetRESTCall("getNestedDataFields", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/nested-data-fields?startingFrom={3}&maximumResults={4}", this.serverName, userId, parentDataFieldGUID, Integer.toString(startingFrom), Integer.toString(maximumResults));
        return restResult.getDataFields();
    }

    DataField getDataField(String userId, String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDataField";
        String dataFieldGUIDParameterName = "dataFieldGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}";
        this.invalidParameterHandler.validateUserId(userId, "getDataField");
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", "getDataField");
        DataFieldResponse restResult = this.restClient.callDataFieldGetRESTCall("getDataField", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}", this.serverName, userId, dataFieldGUID);
        return restResult.getDataField();
    }

    String addDataFieldToDiscoveryReport(String userId, String annotationGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFieldToDiscoveryReport";
        String annotationGUIDParameterName = "annotationGUID";
        String dataFieldParameterName = "dataField";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/data-fields";
        this.invalidParameterHandler.validateUserId(userId, "addDataFieldToDiscoveryReport");
        this.invalidParameterHandler.validateGUID(annotationGUID, "annotationGUID", "addDataFieldToDiscoveryReport");
        this.invalidParameterHandler.validateObject((Object)dataField, "dataField", "addDataFieldToDiscoveryReport");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addDataFieldToDiscoveryReport", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/annotations/{2}/data-fields", dataField, new Object[]{this.serverName, userId, annotationGUID});
        return restResult.getGUID();
    }

    String addDataFieldToDataField(String userId, String parentDataFieldGUID, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addDataFieldToDataField";
        String dataFieldGUIDParameterName = "parentDataFieldGUID";
        String dataFieldParameterName = "dataField";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/nested-data-fields";
        this.invalidParameterHandler.validateUserId(userId, "addDataFieldToDataField");
        this.invalidParameterHandler.validateGUID(parentDataFieldGUID, "parentDataFieldGUID", "addDataFieldToDataField");
        this.invalidParameterHandler.validateObject((Object)dataField, "dataField", "addDataFieldToDataField");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addDataFieldToDataField", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/nested-data-fields", dataField, new Object[]{this.serverName, userId, parentDataFieldGUID});
        return restResult.getGUID();
    }

    String addAnnotationToDataField(String userId, String parentDataFieldGUID, Annotation annotation) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "addAnnotationToDataField";
        String dataFieldGUIDParameterName = "parentDataFieldGUID";
        String annotationParameterName = "annotation";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/annotations";
        this.invalidParameterHandler.validateUserId(userId, "addAnnotationToDataField");
        this.invalidParameterHandler.validateGUID(parentDataFieldGUID, "parentDataFieldGUID", "addAnnotationToDataField");
        this.invalidParameterHandler.validateObject((Object)annotation, "annotation", "addAnnotationToDataField");
        GUIDResponse restResult = this.restClient.callGUIDPostRESTCall("addAnnotationToDataField", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/annotations", annotation, new Object[]{this.serverName, userId, parentDataFieldGUID});
        return restResult.getGUID();
    }

    void updateDataField(String userId, DataField dataField) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDataField";
        String dataFieldParameterName = "dataField";
        String headerParameterName = "dataField.getElementHeader()";
        String annotationGUIDParameterName = "dataField.getElementHeader().getGUID()";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/update";
        this.invalidParameterHandler.validateUserId(userId, "updateDataField");
        this.invalidParameterHandler.validateObject((Object)dataField, "dataField", "updateDataField");
        this.invalidParameterHandler.validateObject((Object)dataField.getElementHeader(), "dataField.getElementHeader()", "updateDataField");
        ElementHeader elementHeader = dataField.getElementHeader();
        this.invalidParameterHandler.validateGUID(elementHeader.getGUID(), "dataField.getElementHeader().getGUID()", "updateDataField");
        this.restClient.callVoidPostRESTCall("updateDataField", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/update", dataField, new Object[]{this.serverName, userId, elementHeader.getGUID()});
    }

    void deleteDataField(String userId, String dataFieldGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDataField";
        String dataFieldGUIDParameterName = "dataFieldGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/delete";
        this.invalidParameterHandler.validateUserId(userId, "deleteDataField");
        this.invalidParameterHandler.validateGUID(dataFieldGUID, "dataFieldGUID", "deleteDataField");
        this.restClient.callVoidPostRESTCall("deleteDataField", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/discovery-engine/users/{1}/data-fields/{2}/delete", nullRequestBody, new Object[]{this.serverName, userId, dataFieldGUID});
    }
}

