/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.connectors.outtopic;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.odpi.openmetadata.accessservices.discoveryengine.auditlog.DiscoveryEngineAuditCode;
import org.odpi.openmetadata.accessservices.discoveryengine.events.DiscoveryEngineEvent;
import org.odpi.openmetadata.accessservices.discoveryengine.ffdc.DiscoveryEngineErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicSenderConnectorBase;

public class DiscoveryEngineOutTopicServerConnector
extends OpenMetadataTopicSenderConnectorBase {
    public void sendEvent(DiscoveryEngineEvent event) throws InvalidParameterException, ConnectorCheckedException {
        String methodName = "sendEvent";
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            String eventString = objectMapper.writeValueAsString((Object)event);
            super.sendEvent(eventString);
            if (this.auditLog != null) {
                DiscoveryEngineAuditCode auditCode = DiscoveryEngineAuditCode.OUT_TOPIC_EVENT;
                this.auditLog.logRecord("sendEvent", auditCode.getLogMessageId(), auditCode.getSeverity(), auditCode.getFormattedLogMessage(new String[]{eventString}), null, auditCode.getSystemAction(), auditCode.getUserAction());
            }
        }
        catch (ConnectorCheckedException | InvalidParameterException error) {
            throw error;
        }
        catch (Throwable error) {
            DiscoveryEngineErrorCode errorCode = DiscoveryEngineErrorCode.UNABLE_TO_SEND_EVENT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{this.connectionName, event.toString(), error.getClass().getName(), error.getMessage()});
            throw new ConnectorCheckedException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "sendEvent", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }
}

