/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.fvt.discovery;

import java.util.HashMap;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.accessservices.assetowner.properties.SchemaTypeProperties;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryAnalysisReportClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.DiscoveryEngineClient;
import org.odpi.openmetadata.accessservices.discoveryengine.client.rest.ODFRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryRequestStatus;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class CreateDiscoveryReportTest {
    private static final String testCaseName = "CreateDiscoveryReportTest";
    private static final int maxPageSize = 100;
    private static final String discoveryReportName = "TestDiscoveryReport";
    private static final String discoveryReportDisplayName = "DiscoveryReport displayName";
    private static final String discoveryReportDescription = "DiscoveryReport description";
    private static final String discoveryReportStepOne = "DiscoveryReport stepOne";
    private static final String discoveryReportStepTwo = "DiscoveryReport stepTwo";
    private static final String discoveryReportAnalysisParam1Name = "Analysis Parameter 1";
    private static final String discoveryReportAnalysisParam1Value = "Analysis Parameter 1 Value";
    private static final String discoveryReportAnalysisParam2Name = "Analysis Parameter 2";
    private static final String discoveryReportAnalysisParam2Value = "Analysis Parameter 2 Value";
    private static final String discoveryReportVersion = "DiscoveryReport version";
    private static final String assetName = "TestAsset qualifiedName";
    private static final String assetDisplayName = "Asset displayName";
    private static final String assetDescription = "Asset description";
    private static final String assetAdditionalPropertyName = "TestAsset additionalPropertyName";
    private static final String assetAdditionalPropertyValue = "TestAsset additionalPropertyValue";
    private static final String schemaTypeName = "SchemaType qualifiedNAme";
    private static final String schemaTypeDisplayName = "SchemaType displayName";
    private static final String schemaTypeDescription = "SchemaType description";
    private static final String schemaTypeType = "SchemaType type";
    private static final String schemaTypeDefaultValue = "SchemaType defaultValue";
    private static final String databaseManagerName = "TestDatabaseManager";
    private static final String databaseManagerDisplayName = "DatabaseManager displayName";
    private static final String databaseManagerDescription = "DatabaseManager description";
    private static final String databaseManagerTypeDescription = "DatabaseManager type";
    private static final String databaseManagerVersion = "DatabaseManager version";
    private static final String databaseName = "TestDatabase";
    private static final String databaseDisplayName = "Database displayName";
    private static final String databaseDescription = "Database description";
    private static final String databaseType = "Database type";
    private static final String databaseVersion = "Database version";
    private static final String databaseSchemaName = "TestDatabaseSchema";
    private static final String databaseSchemaDisplayName = "DatabaseSchema displayName";
    private static final String databaseSchemaDescription = "DatabaseSchema description";
    private static final String databaseSchemaZone = "DatabaseSchema Zone";
    private static final String databaseSchemaOwner = "DatabaseSchema Owner";
    private static final String databaseTableName = "TestDatabaseTable";
    private static final String databaseTableDisplayName = "DatabaseTable displayName";
    private static final String databaseTableDescription = "DatabaseTable description";
    private static final String databaseTableType = "DatabaseTable type";
    private static final String databaseTableVersion = "DatabaseTable version";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            CreateDiscoveryReportTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        CreateDiscoveryReportTest thisTest = new CreateDiscoveryReportTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceCode(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceName(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceDescription(), AccessServiceDescription.DISCOVERY_ENGINE_OMAS.getAccessServiceWiki());
        AssetOwner assetOwnerClient = thisTest.getAssetOwnerClient(serverName, serverPlatformRootURL, auditLog);
        String assetGUID = thisTest.getAsset(assetOwnerClient, userId);
        String schemaTypeGUID = thisTest.getSchemaType(assetOwnerClient, assetGUID, userId);
        DiscoveryEngineClient client = thisTest.getDiscoveryEngineClient(serverName, serverPlatformRootURL, auditLog);
    }

    private AssetOwner getAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetOwnerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            return new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetOwnerClient", (Throwable)unexpectedError);
        }
    }

    private String getAsset(AssetOwner client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getAsset";
        try {
            HashMap<String, String> additionalProperties = new HashMap<String, String>();
            additionalProperties.put(assetAdditionalPropertyName, assetAdditionalPropertyValue);
            AssetProperties properties = new AssetProperties();
            properties.setTypeName("Asset");
            properties.setQualifiedName(assetName);
            properties.setDisplayName(assetDisplayName);
            properties.setDescription(assetDescription);
            properties.setAdditionalProperties(additionalProperties);
            String assetGUID = client.addAssetToCatalog(userId, properties);
            if (assetGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getAsset(no GUID for Create)");
            }
            return assetGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAsset", (Throwable)unexpectedError);
        }
    }

    private String getSchemaType(AssetOwner client, String assetGUID, String userId) throws FVTUnexpectedCondition {
        String activityName = "getSchemaType";
        try {
            PrimitiveSchemaTypeProperties properties = new PrimitiveSchemaTypeProperties();
            properties.setQualifiedName(schemaTypeName);
            properties.setDisplayName(schemaTypeDisplayName);
            properties.setDescription(schemaTypeDescription);
            properties.setDataType(schemaTypeType);
            properties.setDefaultValue(schemaTypeDefaultValue);
            properties.setTypeName("PrimitiveSchemaType");
            String schemaTypeGUID = client.addSchemaTypeToAsset(userId, assetGUID, (SchemaTypeProperties)properties);
            if (schemaTypeGUID == null) {
                throw new FVTUnexpectedCondition(testCaseName, "getSchemaType(no GUID for Create)");
            }
            return schemaTypeGUID;
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getSchemaType", (Throwable)unexpectedError);
        }
    }

    private DiscoveryEngineClient getDiscoveryEngineClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getDiscoveryEngineClient";
        try {
            ODFRESTClient restClient = new ODFRESTClient(serverName, serverPlatformRootURL);
            return new DiscoveryEngineClient(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDiscoveryEngineClient", (Throwable)unexpectedError);
        }
    }

    private String getDiscoveryReport(DiscoveryEngineClient client, String userId, String assetGUID, String governanceEngineGUID, String governanceServiceGUID) throws FVTUnexpectedCondition {
        String activityName = "getDiscoveryReport";
        HashMap<String, String> analysisParameters = new HashMap<String, String>();
        analysisParameters.put(discoveryReportAnalysisParam1Name, discoveryReportAnalysisParam1Value);
        analysisParameters.put(discoveryReportAnalysisParam2Name, discoveryReportAnalysisParam2Value);
        try {
            DiscoveryAnalysisReportClient discoveryReport = new DiscoveryAnalysisReportClient(userId, DiscoveryRequestStatus.WAITING, assetGUID, analysisParameters, discoveryReportStepOne, discoveryReportName, discoveryReportDisplayName, discoveryReportDescription, governanceEngineGUID, governanceServiceGUID, client);
            DiscoveryRequestStatus discoveryRequestStatus = discoveryReport.getDiscoveryRequestStatus();
            if (discoveryRequestStatus == DiscoveryRequestStatus.WAITING) {
                discoveryReport.setDiscoveryRequestStatus(DiscoveryRequestStatus.ACTIVATING);
                discoveryRequestStatus = discoveryReport.getDiscoveryRequestStatus();
                if (discoveryRequestStatus != DiscoveryRequestStatus.ACTIVATING) {
                    throw new FVTUnexpectedCondition(testCaseName, "getDiscoveryReport(status " + discoveryRequestStatus + " not ACTIVATING)");
                }
            } else {
                throw new FVTUnexpectedCondition(testCaseName, "getDiscoveryReport(status " + discoveryRequestStatus + " not WAITING)");
            }
            if (!discoveryReportName.equals(discoveryReport.getReportQualifiedName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDiscoveryReport(qualified name " + discoveryReport.getReportQualifiedName() + " not TestDiscoveryReport)");
            }
            if (!discoveryReportDisplayName.equals(discoveryReport.getReportDisplayName())) {
                throw new FVTUnexpectedCondition(testCaseName, "getDiscoveryReport(display name " + discoveryReport.getReportDisplayName() + " not DiscoveryReport displayName)");
            }
            return discoveryReport.getDiscoveryReportGUID();
        }
        catch (FVTUnexpectedCondition testCaseError) {
            throw testCaseError;
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getDiscoveryReport", (Throwable)unexpectedError);
        }
    }
}

