/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.discoveryengine.fvt.clientconstructors.ClientConstructorTest;
import org.odpi.openmetadata.accessservices.discoveryengine.fvt.discovery.CreateDiscoveryReportTest;
import org.odpi.openmetadata.accessservices.discoveryengine.fvt.errorhandling.InvalidParameterTest;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.FVTSuiteBase;
import org.odpi.openmetadata.http.HttpHelper;

public class DiscoveryEngineOMASFVTSuite
extends FVTSuiteBase {
    public static void main(String[] args) {
        int exitCode;
        try {
            String url = DiscoveryEngineOMASFVTSuite.getUrl((String[])args);
            String serverName = DiscoveryEngineOMASFVTSuite.getServerName((String[])args);
            String userId = DiscoveryEngineOMASFVTSuite.getUserId((String[])args);
            DiscoveryEngineOMASFVTSuite fvtSuite = new DiscoveryEngineOMASFVTSuite();
            exitCode = fvtSuite.performFVT(serverName, url, userId);
        }
        catch (IOException error) {
            System.out.println("Error getting user input");
            error.printStackTrace();
            exitCode = -99;
        }
        System.exit(exitCode);
    }

    public int performFVT(String serverName, String serverPlatformRootURL, String userId) {
        HttpHelper.noStrictSSL();
        int returnCode = 0;
        FVTResults results = ClientConstructorTest.performFVT(serverName, serverPlatformRootURL);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = InvalidParameterTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        results = CreateDiscoveryReportTest.performFVT(serverName, serverPlatformRootURL, userId);
        if (!results.isSuccessful()) {
            --returnCode;
        }
        results.printResults(serverName);
        return returnCode;
    }
}

