/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.builders.DiscoveryEngineBuilder;
import org.odpi.openmetadata.accessservices.discoveryengine.builders.DiscoveryServiceBuilder;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DiscoveryEnginePropertiesConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.DiscoveryServicePropertiesConverter;
import org.odpi.openmetadata.accessservices.discoveryengine.converters.RegisteredDiscoveryServiceConverter;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.handlers.ConnectionHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryConfigurationServer;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryEngineProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;
import org.odpi.openmetadata.frameworks.discovery.properties.RegisteredDiscoveryService;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class DiscoveryConfigurationHandler
extends DiscoveryConfigurationServer {
    private String serviceName;
    private String serverName;
    private RepositoryErrorHandler errorHandler;
    private RepositoryHandler repositoryHandler;
    private OMRSRepositoryHelper repositoryHelper;
    private ConnectionHandler connectionHandler;
    private InvalidParameterHandler invalidParameterHandler;

    public DiscoveryConfigurationHandler(String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, OMRSRepositoryHelper repositoryHelper, RepositoryHandler repositoryHandler, RepositoryErrorHandler errorHandler, ConnectionHandler connectionHandler) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.errorHandler = errorHandler;
        this.repositoryHandler = repositoryHandler;
        this.connectionHandler = connectionHandler;
    }

    public String createDiscoveryEngine(String userId, String qualifiedName, String displayName, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDiscoveryEngine";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "createDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createDiscoveryEngine");
        DiscoveryEngineBuilder builder = new DiscoveryEngineBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("createDiscoveryEngine");
        return this.repositoryHandler.createEntity(userId, "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", properties, "createDiscoveryEngine");
    }

    public DiscoveryEngineProperties getDiscoveryEngineByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryEngineByGUID";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryEngineByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDiscoveryEngineByGUID");
        EntityDetail retrievedEntity = this.repositoryHandler.getEntityByGUID(userId, guid, "guid", "OpenDiscoveryEngine", "getDiscoveryEngineByGUID");
        if (retrievedEntity != null) {
            DiscoveryEnginePropertiesConverter converter = new DiscoveryEnginePropertiesConverter(retrievedEntity, this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        return null;
    }

    public DiscoveryEngineProperties getDiscoveryEngineByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryEngineByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryEngineByName");
        this.invalidParameterHandler.validateGUID(name, "name", "getDiscoveryEngineByName");
        DiscoveryEngineBuilder builder = new DiscoveryEngineBuilder(name, name, null, this.repositoryHelper, this.serviceName, this.serverName);
        List retrievedEntities = this.repositoryHandler.getEntityByName(userId, builder.getQualifiedNameInstanceProperties("getDiscoveryEngineByName"), "be650674-790b-487a-a619-0a9002488055", "getDiscoveryEngineByName");
        if (retrievedEntities != null && retrievedEntities.size() == 1) {
            DiscoveryEnginePropertiesConverter converter = new DiscoveryEnginePropertiesConverter((EntityDetail)retrievedEntities.get(0), this.repositoryHelper, this.serviceName);
            return converter.getBean();
        }
        retrievedEntities = this.repositoryHandler.getEntityByName(userId, builder.getNameInstanceProperties("getDiscoveryEngineByName"), "be650674-790b-487a-a619-0a9002488055", "getDiscoveryEngineByName");
        if (retrievedEntities != null && !retrievedEntities.isEmpty()) {
            if (retrievedEntities.size() == 1) {
                DiscoveryEnginePropertiesConverter converter = new DiscoveryEnginePropertiesConverter((EntityDetail)retrievedEntities.get(0), this.repositoryHelper, this.serviceName);
                return converter.getBean();
            }
            this.errorHandler.handleAmbiguousEntityName(name, "name", "OpenDiscoveryEngine", retrievedEntities, "getDiscoveryEngineByName");
        } else {
            this.errorHandler.handleNoEntity("be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", builder.getNameInstanceProperties("getDiscoveryEngineByName"), "getDiscoveryEngineByName");
        }
        return null;
    }

    public List<DiscoveryEngineProperties> getAllDiscoveryEngines(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryEngines";
        this.invalidParameterHandler.validateUserId(userId, "getAllDiscoveryEngines");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllDiscoveryEngines");
        List retrievedEntities = this.repositoryHandler.getEntityByType(userId, "be650674-790b-487a-a619-0a9002488055", startingFrom, maximumResults, "getAllDiscoveryEngines");
        if (retrievedEntities != null && !retrievedEntities.isEmpty()) {
            ArrayList<DiscoveryEngineProperties> results = new ArrayList<DiscoveryEngineProperties>();
            for (EntityDetail entityDetail : retrievedEntities) {
                if (entityDetail == null) continue;
                DiscoveryEnginePropertiesConverter converter = new DiscoveryEnginePropertiesConverter(entityDetail, this.repositoryHelper, this.serviceName);
                results.add(converter.getBean());
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public void updateDiscoveryEngine(String userId, String guid, String qualifiedName, String displayName, String description, String typeDescription, String version, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryEngine";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateDiscoveryEngine");
        DiscoveryEngineBuilder builder = new DiscoveryEngineBuilder(qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("updateDiscoveryEngine");
        this.repositoryHandler.updateEntity(userId, guid, "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", properties, "updateDiscoveryEngine");
    }

    public void deleteDiscoveryEngine(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDiscoveryEngine";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteDiscoveryEngine");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteDiscoveryEngine");
        this.repositoryHandler.removeEntity(userId, guid, "be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", "qualifiedName", qualifiedName, "deleteDiscoveryEngine");
    }

    public String createDiscoveryService(String userId, String qualifiedName, String displayName, String description, Connection connection) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createDiscoveryService";
        String qualifiedNameParameter = "qualifiedName";
        String connectionParameter = "connection";
        this.invalidParameterHandler.validateUserId(userId, "createDiscoveryService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "createDiscoveryService");
        this.invalidParameterHandler.validateConnection(connection, "connection", "createDiscoveryService");
        String connectionGUID = this.connectionHandler.saveConnection(userId, connection);
        DiscoveryServiceBuilder builder = new DiscoveryServiceBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("createDiscoveryService");
        String discoveryServiceGUID = this.repositoryHandler.createEntity(userId, "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", properties, "createDiscoveryService");
        this.repositoryHandler.createRelationship(userId, "e777d660-8dbe-453e-8b83-903771f054c0", connectionGUID, discoveryServiceGUID, null, "createDiscoveryService");
        return discoveryServiceGUID;
    }

    public DiscoveryServiceProperties getDiscoveryServiceByGUID(String userId, String guid) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryServiceByGUID";
        String guidParameter = "guid";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryServiceByGUID");
        this.invalidParameterHandler.validateGUID(guid, "guid", "getDiscoveryServiceByGUID");
        EntityDetail discoveryServiceEntity = this.repositoryHandler.getEntityByGUID(userId, guid, "guid", "OpenDiscoveryService", "getDiscoveryServiceByGUID");
        return this.getDiscoveryServiceBean(userId, discoveryServiceEntity, "getDiscoveryServiceByGUID");
    }

    public DiscoveryServiceProperties getDiscoveryServiceByName(String userId, String name) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getDiscoveryServiceByName";
        String nameParameter = "name";
        this.invalidParameterHandler.validateUserId(userId, "getDiscoveryServiceByName");
        this.invalidParameterHandler.validateName(name, "name", "getDiscoveryServiceByName");
        DiscoveryServiceBuilder builder = new DiscoveryServiceBuilder(name, name, null, this.repositoryHelper, this.serviceName, this.serverName);
        List retrievedEntities = this.repositoryHandler.getEntityByName(userId, builder.getQualifiedNameInstanceProperties("getDiscoveryServiceByName"), "2f278dfc-4640-4714-b34b-303e84e4fc40", "getDiscoveryServiceByName");
        if (retrievedEntities == null || retrievedEntities.isEmpty()) {
            retrievedEntities = this.repositoryHandler.getEntityByName(userId, builder.getNameInstanceProperties("getDiscoveryServiceByName"), "be650674-790b-487a-a619-0a9002488055", "getDiscoveryServiceByName");
        }
        if (retrievedEntities != null && !retrievedEntities.isEmpty()) {
            if (retrievedEntities.size() == 1) {
                return this.getDiscoveryServiceBean(userId, (EntityDetail)retrievedEntities.get(0), "getDiscoveryServiceByName");
            }
            this.errorHandler.handleAmbiguousEntityName(name, "name", "OpenDiscoveryEngine", retrievedEntities, "getDiscoveryServiceByName");
        } else {
            this.errorHandler.handleNoEntity("be650674-790b-487a-a619-0a9002488055", "OpenDiscoveryEngine", builder.getNameInstanceProperties("getDiscoveryServiceByName"), "getDiscoveryServiceByName");
        }
        return null;
    }

    private DiscoveryServiceProperties getDiscoveryServiceBean(String userId, EntityDetail discoveryServiceEntity, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityProxy end1;
        Relationship relationshipToConnection = this.repositoryHandler.getUniqueRelationshipByType(userId, discoveryServiceEntity.getGUID(), "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", methodName);
        DiscoveryServicePropertiesConverter converter = new DiscoveryServicePropertiesConverter(discoveryServiceEntity, relationshipToConnection, this.repositoryHelper, this.serviceName);
        DiscoveryServiceProperties bean = converter.getDiscoveryServiceBean();
        if (relationshipToConnection != null && (end1 = relationshipToConnection.getEntityOneProxy()) != null) {
            bean.setConnection(this.connectionHandler.getConnection(userId, end1.getGUID()));
        }
        return bean;
    }

    public List<DiscoveryServiceProperties> getAllDiscoveryServices(String userId, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryServices";
        this.invalidParameterHandler.validateUserId(userId, "getAllDiscoveryServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getAllDiscoveryServices");
        List retrievedEntities = this.repositoryHandler.getEntityByType(userId, "2f278dfc-4640-4714-b34b-303e84e4fc40", startingFrom, maximumResults, "getAllDiscoveryServices");
        if (retrievedEntities != null && !retrievedEntities.isEmpty()) {
            ArrayList<DiscoveryServiceProperties> results = new ArrayList<DiscoveryServiceProperties>();
            for (EntityDetail entityDetail : retrievedEntities) {
                if (entityDetail == null) continue;
                results.add(this.getDiscoveryServiceBean(userId, entityDetail, "getAllDiscoveryServices"));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<String> getDiscoveryServiceRegistrations(String userId, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAllDiscoveryServices";
        String guidParameter = "discoveryServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getAllDiscoveryServices");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "getAllDiscoveryServices");
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, discoveryServiceGUID, "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "getAllDiscoveryServices");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getGUID() == null) continue;
                results.add(relationship.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void updateDiscoveryService(String userId, String guid, String qualifiedName, String displayName, String shortDescription, String description, String owner, OwnerType ownerType, List<String> zoneMembership, String latestChange, Connection connection, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "updateDiscoveryService";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "updateDiscoveryService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "updateDiscoveryService");
        DiscoveryServiceBuilder builder = new DiscoveryServiceBuilder(qualifiedName, displayName, description, owner, ownerType, zoneMembership, latestChange, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        InstanceProperties properties = builder.getInstanceProperties("updateDiscoveryService");
        this.repositoryHandler.updateEntity(userId, guid, "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", properties, "updateDiscoveryService");
        Relationship assetConnectionRelationship = this.repositoryHandler.getUniqueRelationshipByType(userId, guid, "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "updateDiscoveryService");
        if (connection == null) {
            if (assetConnectionRelationship != null) {
                this.repositoryHandler.removeRelationship(userId, "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", assetConnectionRelationship.getGUID(), "updateDiscoveryService");
                EntityProxy connectionProxy = assetConnectionRelationship.getEntityOneProxy();
                if (connectionProxy != null) {
                    this.connectionHandler.removeConnection(userId, connectionProxy.getGUID());
                }
            }
        } else {
            String connectionGUID = this.connectionHandler.saveConnection(userId, connection);
            if (assetConnectionRelationship == null) {
                this.repositoryHandler.createRelationship(userId, "e777d660-8dbe-453e-8b83-903771f054c0", connectionGUID, guid, null, "updateDiscoveryService");
            } else {
                this.repositoryHandler.updateUniqueRelationshipByType(userId, connectionGUID, "Connection", guid, "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "updateDiscoveryService");
            }
        }
    }

    public void deleteDiscoveryService(String userId, String guid, String qualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "deleteDiscoveryService";
        String qualifiedNameParameter = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, "deleteDiscoveryService");
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", "deleteDiscoveryService");
        EntityDetail connectionEntity = this.repositoryHandler.getEntityForRelationshipType(userId, guid, "OpenDiscoveryService", "e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", "deleteDiscoveryService");
        if (connectionEntity != null) {
            this.connectionHandler.removeConnection(userId, connectionEntity.getGUID());
        }
        this.repositoryHandler.removeEntity(userId, guid, "2f278dfc-4640-4714-b34b-303e84e4fc40", "OpenDiscoveryService", "qualifiedName", qualifiedName, "deleteDiscoveryService");
    }

    public void registerDiscoveryServiceWithEngine(String userId, String discoveryEngineGUID, String discoveryServiceGUID, List<String> assetTypes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "registerDiscoveryServiceWithEngine";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        String assetTypesParameter = "assetTypes";
        this.invalidParameterHandler.validateUserId(userId, "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "registerDiscoveryServiceWithEngine");
        this.invalidParameterHandler.validateStringArray(assetTypes, "assetTypes", "registerDiscoveryServiceWithEngine");
        InstanceProperties instanceProperties = new InstanceProperties();
        this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, instanceProperties, "assetTypes", assetTypes, "registerDiscoveryServiceWithEngine");
        this.repositoryHandler.createRelationship(userId, "dff45aeb-c65e-428c-9ab3-d756bc5d8dbb", discoveryServiceGUID, discoveryEngineGUID, instanceProperties, "registerDiscoveryServiceWithEngine");
    }

    public RegisteredDiscoveryService getRegisteredDiscoveryService(String userId, String discoveryEngineGUID, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredDiscoveryService";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredDiscoveryService");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "getRegisteredDiscoveryService");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "getRegisteredDiscoveryService");
        Relationship relationship = this.repositoryHandler.getRelationshipBetweenEntities(userId, discoveryServiceGUID, "OpenDiscoveryService", discoveryEngineGUID, "dff45aeb-c65e-428c-9ab3-d756bc5d8dbb", "SupportedDiscoveryService", "getRegisteredDiscoveryService");
        RegisteredDiscoveryServiceConverter converter = new RegisteredDiscoveryServiceConverter(this.getDiscoveryServiceByGUID(userId, discoveryServiceGUID), relationship, this.repositoryHelper, this.serviceName);
        return converter.getBean();
    }

    public List<String> getRegisteredDiscoveryServices(String userId, String discoveryEngineGUID, int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getRegisteredDiscoveryServices";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        this.invalidParameterHandler.validateUserId(userId, "getRegisteredDiscoveryServices");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "getRegisteredDiscoveryServices");
        this.invalidParameterHandler.validatePaging(startingFrom, maximumResults, "getRegisteredDiscoveryServices");
        List relationships = this.repositoryHandler.getPagedRelationshipsByType(userId, discoveryEngineGUID, "OpenDiscoveryEngine", "dff45aeb-c65e-428c-9ab3-d756bc5d8dbb", "SupportedDiscoveryService", startingFrom, maximumResults, "getRegisteredDiscoveryServices");
        ArrayList<String> results = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getGUID() == null) continue;
                results.add(relationship.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public void unregisterDiscoveryServiceFromEngine(String userId, String discoveryEngineGUID, String discoveryServiceGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unregisterDiscoveryServiceFromEngine";
        String discoveryEngineGUIDParameter = "discoveryEngineGUID";
        String discoveryServiceGUIDParameter = "discoveryServiceGUID";
        this.invalidParameterHandler.validateUserId(userId, "unregisterDiscoveryServiceFromEngine");
        this.invalidParameterHandler.validateGUID(discoveryEngineGUID, "discoveryEngineGUID", "unregisterDiscoveryServiceFromEngine");
        this.invalidParameterHandler.validateGUID(discoveryServiceGUID, "discoveryServiceGUID", "unregisterDiscoveryServiceFromEngine");
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, "dff45aeb-c65e-428c-9ab3-d756bc5d8dbb", "SupportedDiscoveryService", discoveryServiceGUID, "OpenDiscoveryService", discoveryEngineGUID, "unregisterDiscoveryServiceFromEngine");
    }
}

