/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server;

import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.AnnotationHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.handlers.DiscoveryAnalysisReportHandler;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.AnnotationResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryAnalysisReportResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.StatusRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryAnalysisReport;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryEngineServices {
    private static DiscoveryEngineServiceInstanceHandler instanceHandler = new DiscoveryEngineServiceInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(DiscoveryEngineServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public DiscoveryAnalysisReportResponse createDiscoveryAnalysisReport(String serverName, String userId, String assetGUID, DiscoveryAnalysisReportRequestBody requestBody) {
        String methodName = "createDiscoveryAnalysisReport";
        log.debug("Calling method: createDiscoveryAnalysisReport");
        OMRSAuditLog auditLog = null;
        DiscoveryAnalysisReportResponse response = new DiscoveryAnalysisReportResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "createDiscoveryAnalysisReport", serverName);
            } else {
                DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "createDiscoveryAnalysisReport");
                auditLog = instanceHandler.getAuditLog(userId, serverName, "createDiscoveryAnalysisReport");
                response.setAnalysisReport(handler.createDiscoveryAnalysisReport(userId, requestBody.getQualifiedName(), requestBody.getDisplayName(), requestBody.getDescription(), requestBody.getCreationDate(), requestBody.getAnalysisParameters(), requestBody.getDiscoveryRequestStatus(), assetGUID, requestBody.getDiscoveryEngineGUID(), requestBody.getDiscoveryServiceGUID(), requestBody.getAdditionalProperties(), requestBody.getClassifications(), "createDiscoveryAnalysisReport"));
            }
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createDiscoveryAnalysisReport", auditLog);
        }
        log.debug("Returning from method: createDiscoveryAnalysisReport with response: " + response.toString());
        return response;
    }

    public DiscoveryAnalysisReportResponse updateDiscoveryAnalysisReport(String serverName, String userId, String discoveryReportGUID, DiscoveryAnalysisReport requestBody) {
        String methodName = "updateDiscoveryAnalysisReport";
        log.debug("Calling method: updateDiscoveryAnalysisReport");
        OMRSAuditLog auditLog = null;
        DiscoveryAnalysisReportResponse response = new DiscoveryAnalysisReportResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "updateDiscoveryAnalysisReport", serverName);
            }
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "updateDiscoveryAnalysisReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDiscoveryAnalysisReport");
            response.setAnalysisReport(handler.updateDiscoveryAnalysisReport(userId, discoveryReportGUID, requestBody));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateDiscoveryAnalysisReport", auditLog);
        }
        log.debug("Returning from method: updateDiscoveryAnalysisReport with response: " + response.toString());
        return response;
    }

    public DiscoveryAnalysisReportResponse getDiscoveryAnalysisReport(String serverName, String userId, String discoveryReportGUID) {
        String methodName = "getDiscoveryAnalysisReport";
        log.debug("Calling method: getDiscoveryAnalysisReport");
        OMRSAuditLog auditLog = null;
        DiscoveryAnalysisReportResponse response = new DiscoveryAnalysisReportResponse();
        try {
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryAnalysisReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryAnalysisReport");
            response.setAnalysisReport(handler.getDiscoveryAnalysisReport(userId, discoveryReportGUID, "getDiscoveryAnalysisReport"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryAnalysisReport", auditLog);
        }
        log.debug("Returning from method: getDiscoveryAnalysisReport with response: " + response.toString());
        return response;
    }

    public AnnotationListResponse getAnnotationsForAssetByStatus(String serverName, String userId, String assetGUID, int startingFrom, int maximumResults, StatusRequestBody requestBody) {
        String methodName = "getAnnotationsForAssetByStatus";
        log.debug("Calling method: getAnnotationsForAssetByStatus");
        OMRSAuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        AnnotationStatus status = null;
        if (requestBody != null) {
            status = requestBody.getAnnotationStatus();
        }
        try {
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getAnnotationsForAssetByStatus");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotationsForAssetByStatus");
            response.setAnnotations(handler.getAnnotationsForAssetByStatus(userId, assetGUID, status, startingFrom, maximumResults, "getAnnotationsForAssetByStatus"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAnnotationsForAssetByStatus", auditLog);
        }
        log.debug("Returning from method: getAnnotationsForAssetByStatus with response: " + response.toString());
        return response;
    }

    public AnnotationListResponse getDiscoveryReportAnnotations(String serverName, String userId, String discoveryReportGUID, int startingFrom, int maximumResults) {
        String methodName = "getDiscoveryReportAnnotations";
        log.debug("Calling method: getDiscoveryReportAnnotations");
        OMRSAuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        try {
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "getDiscoveryReportAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryReportAnnotations");
            response.setAnnotations(handler.getDiscoveryReportAnnotations(userId, discoveryReportGUID, null, startingFrom, maximumResults, "getDiscoveryReportAnnotations"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryReportAnnotations", auditLog);
        }
        log.debug("Returning from method: getDiscoveryReportAnnotations with response: " + response.toString());
        return response;
    }

    public AnnotationListResponse getExtendedAnnotations(String serverName, String userId, String annotationGUID, int startingFrom, int maximumResults) {
        String methodName = "getExtendedAnnotations";
        log.debug("Calling method: getExtendedAnnotations");
        OMRSAuditLog auditLog = null;
        AnnotationListResponse response = new AnnotationListResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getExtendedAnnotations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getExtendedAnnotations");
            response.setAnnotations(handler.getExtendedAnnotations(userId, annotationGUID, null, startingFrom, maximumResults, "getExtendedAnnotations"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getExtendedAnnotations", auditLog);
        }
        log.debug("Returning from method: getExtendedAnnotations with response: " + response.toString());
        return response;
    }

    public AnnotationResponse getAnnotation(String serverName, String userId, String annotationGUID) {
        String methodName = "getAnnotation";
        log.debug("Calling method: getAnnotation");
        OMRSAuditLog auditLog = null;
        AnnotationResponse response = new AnnotationResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "getAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAnnotation");
            response.setAnnotation(handler.getAnnotation(userId, annotationGUID, "getAnnotation"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAnnotation", auditLog);
        }
        log.debug("Returning from method: getAnnotation with response: " + response.toString());
        return response;
    }

    public GUIDResponse addAnnotationToDiscoveryReport(String serverName, String userId, String discoveryReportGUID, Annotation requestBody) {
        String methodName = "addAnnotationToDiscoveryReport";
        log.debug("Calling method: addAnnotationToDiscoveryReport");
        OMRSAuditLog auditLog = null;
        GUIDResponse response = new GUIDResponse();
        try {
            if (requestBody == null) {
                this.restExceptionHandler.handleNoRequestBody(userId, "addAnnotationToDiscoveryReport", serverName);
            }
            DiscoveryAnalysisReportHandler handler = instanceHandler.getDiscoveryAnalysisReportHandler(userId, serverName, "addAnnotationToDiscoveryReport");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAnnotationToDiscoveryReport");
            response.setGUID(handler.addAnnotationToDiscoveryReport(userId, discoveryReportGUID, requestBody, "addAnnotationToDiscoveryReport"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAnnotationToDiscoveryReport", auditLog);
        }
        log.debug("Returning from method: addAnnotationToDiscoveryReport with response: " + response.toString());
        return response;
    }

    public AnnotationResponse addAnnotationToAnnotation(String serverName, String userId, String anchorAnnotationGUID, Annotation requestBody) {
        String methodName = "addAnnotationToAnnotation";
        log.debug("Calling method: addAnnotationToAnnotation");
        OMRSAuditLog auditLog = null;
        AnnotationResponse response = new AnnotationResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "addAnnotationToAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "addAnnotationToAnnotation");
            response.setAnnotation(handler.addAnnotationToAnnotation(userId, anchorAnnotationGUID, requestBody, "addAnnotationToAnnotation"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "addAnnotationToAnnotation", auditLog);
        }
        log.debug("Returning from method: addAnnotationToAnnotation with response: " + response.toString());
        return response;
    }

    public VoidResponse linkAnnotation(String serverName, String userId, String anchorGUID, String annotationGUID, NullRequestBody requestBody) {
        String methodName = "linkAnnotation";
        log.debug("Calling method: linkAnnotation");
        OMRSAuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "linkAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "linkAnnotation");
            handler.linkAnnotation(userId, anchorGUID, annotationGUID, "linkAnnotation");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "linkAnnotation", auditLog);
        }
        log.debug("Returning from method: linkAnnotation with response: " + response.toString());
        return response;
    }

    public VoidResponse unlinkAnnotation(String serverName, String userId, String anchorGUID, String annotationGUID, NullRequestBody requestBody) {
        String methodName = "unlinkAnnotation";
        log.debug("Calling method: unlinkAnnotation");
        OMRSAuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "unlinkAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unlinkAnnotation");
            handler.unlinkAnnotation(userId, anchorGUID, annotationGUID, "unlinkAnnotation");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "unlinkAnnotation", auditLog);
        }
        log.debug("Returning from method: unlinkAnnotation with response: " + response.toString());
        return response;
    }

    public AnnotationResponse updateAnnotation(String serverName, String userId, String annotationGUID, Annotation requestBody) {
        String methodName = "updateAnnotation";
        log.debug("Calling method: updateAnnotation");
        OMRSAuditLog auditLog = null;
        AnnotationResponse response = new AnnotationResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "updateAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateAnnotation");
            response.setAnnotation(handler.updateAnnotation(userId, annotationGUID, requestBody, "updateAnnotation"));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateAnnotation", auditLog);
        }
        log.debug("Returning from method: updateAnnotation with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteAnnotation(String serverName, String userId, String annotationGUID, NullRequestBody requestBody) {
        String methodName = "deleteAnnotation";
        log.debug("Calling method: deleteAnnotation");
        OMRSAuditLog auditLog = null;
        VoidResponse response = new VoidResponse();
        try {
            AnnotationHandler handler = instanceHandler.getAnnotationHandler(userId, serverName, "deleteAnnotation");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteAnnotation");
            handler.deleteAnnotation(userId, annotationGUID, "deleteAnnotation");
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "deleteAnnotation", auditLog);
        }
        log.debug("Returning from method: deleteAnnotation with response: " + response.toString());
        return response;
    }
}

