/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.discoveryengine.server;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.discoveryengine.handlers.DiscoveryConfigurationHandler;
import org.odpi.openmetadata.accessservices.discoveryengine.server.DiscoveryEngineServiceInstanceHandler;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponseBase;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDListResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DeleteRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEngineListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryEnginePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceListResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServicePropertiesResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.DiscoveryServiceRegistrationRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.NewDiscoveryServiceRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.RegisteredDiscoveryServiceResponse;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryEngineRequestBody;
import org.odpi.openmetadata.commonservices.odf.metadatamanagement.rest.UpdateDiscoveryServiceRequestBody;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;
import org.odpi.openmetadata.repositoryservices.auditlog.OMRSAuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryConfigurationServices {
    private static DiscoveryEngineServiceInstanceHandler instanceHandler = new DiscoveryEngineServiceInstanceHandler();
    private static final Logger log = LoggerFactory.getLogger(DiscoveryConfigurationServices.class);
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public GUIDResponse createDiscoveryEngine(String serverName, String userId, NewDiscoveryEngineRequestBody requestBody) {
        String methodName = "createDiscoveryEngine";
        log.debug("Calling method: createDiscoveryEngine");
        String qualifiedName = null;
        String displayName = null;
        String description = null;
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            description = requestBody.getDescription();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "createDiscoveryEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDiscoveryEngine");
            response.setGUID(handler.createDiscoveryEngine(userId, qualifiedName, displayName, description));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createDiscoveryEngine", auditLog);
        }
        log.debug("Returning from method: createDiscoveryEngine with response: " + response.toString());
        return response;
    }

    public DiscoveryEnginePropertiesResponse getDiscoveryEngineByGUID(String serverName, String userId, String guid) {
        String methodName = "getDiscoveryEngineByGUID";
        log.debug("Calling method: getDiscoveryEngineByGUID");
        DiscoveryEnginePropertiesResponse response = new DiscoveryEnginePropertiesResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryEngineByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryEngineByGUID");
            response.setDiscoveryEngineProperties(handler.getDiscoveryEngineByGUID(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryEngineByGUID", auditLog);
        }
        log.debug("Returning from method: getDiscoveryEngineByGUID with response: " + response.toString());
        return response;
    }

    public DiscoveryEnginePropertiesResponse getDiscoveryEngineByName(String serverName, String userId, String name) {
        String methodName = "getDiscoveryEngineByName";
        log.debug("Calling method: getDiscoveryEngineByName");
        DiscoveryEnginePropertiesResponse response = new DiscoveryEnginePropertiesResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryEngineByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryEngineByName");
            response.setDiscoveryEngineProperties(handler.getDiscoveryEngineByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryEngineByName", auditLog);
        }
        log.debug("Returning from method: getDiscoveryEngineByName with response: " + response.toString());
        return response;
    }

    public DiscoveryEngineListResponse getAllDiscoveryEngines(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllDiscoveryEngines";
        log.debug("Calling method: getAllDiscoveryEngines");
        DiscoveryEngineListResponse response = new DiscoveryEngineListResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getAllDiscoveryEngines");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllDiscoveryEngines");
            response.setDiscoveryEngines(handler.getAllDiscoveryEngines(userId, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAllDiscoveryEngines", auditLog);
        }
        log.debug("Returning from method: getAllDiscoveryEngines with response: " + response.toString());
        return response;
    }

    public VoidResponse updateDiscoveryEngine(String serverName, String userId, String guid, UpdateDiscoveryEngineRequestBody requestBody) {
        String methodName = "updateDiscoveryEngine";
        log.debug("Calling method: updateDiscoveryEngine");
        String qualifiedName = null;
        String displayName = null;
        String description = null;
        String typeDescription = null;
        String version = null;
        String patchLevel = null;
        String source = null;
        Map additionalProperties = null;
        Map extendedProperties = null;
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            description = requestBody.getDescription();
            typeDescription = requestBody.getTypeDescription();
            version = requestBody.getVersion();
            patchLevel = requestBody.getPatchLevel();
            source = requestBody.getSource();
            additionalProperties = requestBody.getAdditionalProperties();
            extendedProperties = requestBody.getExtendedProperties();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "updateDiscoveryEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDiscoveryEngine");
            handler.updateDiscoveryEngine(userId, guid, qualifiedName, displayName, description, typeDescription, version, patchLevel, source, additionalProperties, extendedProperties);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateDiscoveryEngine", auditLog);
        }
        log.debug("Returning from method: updateDiscoveryEngine with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteDiscoveryEngine(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteDiscoveryEngine";
        log.debug("Calling method: deleteDiscoveryEngine");
        String qualifiedName = null;
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "deleteDiscoveryEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDiscoveryEngine");
            handler.deleteDiscoveryEngine(userId, guid, qualifiedName);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "deleteDiscoveryEngine", auditLog);
        }
        log.debug("Returning from method: deleteDiscoveryEngine with response: " + response.toString());
        return response;
    }

    public GUIDResponse createDiscoveryService(String serverName, String userId, NewDiscoveryServiceRequestBody requestBody) {
        String methodName = "createDiscoveryService";
        log.debug("Calling method: createDiscoveryService");
        String qualifiedName = null;
        String displayName = null;
        String description = null;
        Connection connection = null;
        GUIDResponse response = new GUIDResponse();
        OMRSAuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            description = requestBody.getDescription();
            connection = requestBody.getConnection();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "createDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "createDiscoveryService");
            response.setGUID(handler.createDiscoveryService(userId, qualifiedName, displayName, description, connection));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "createDiscoveryService", auditLog);
        }
        log.debug("Returning from method: createDiscoveryService with response: " + response.toString());
        return response;
    }

    public DiscoveryServicePropertiesResponse getDiscoveryServiceByGUID(String serverName, String userId, String guid) {
        String methodName = "getDiscoveryServiceByGUID";
        log.debug("Calling method: getDiscoveryServiceByGUID");
        DiscoveryServicePropertiesResponse response = new DiscoveryServicePropertiesResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryServiceByGUID");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryServiceByGUID");
            response.setDiscoveryServiceProperties(handler.getDiscoveryServiceByGUID(userId, guid));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryServiceByGUID", auditLog);
        }
        log.debug("Returning from method: getDiscoveryServiceByGUID with response: " + response.toString());
        return response;
    }

    public DiscoveryServicePropertiesResponse getDiscoveryServiceByName(String serverName, String userId, String name) {
        String methodName = "getDiscoveryServiceByName";
        log.debug("Calling method: getDiscoveryServiceByName");
        DiscoveryServicePropertiesResponse response = new DiscoveryServicePropertiesResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryServiceByName");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryServiceByName");
            response.setDiscoveryServiceProperties(handler.getDiscoveryServiceByName(userId, name));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryServiceByName", auditLog);
        }
        log.debug("Returning from method: getDiscoveryServiceByName with response: " + response.toString());
        return response;
    }

    public DiscoveryServiceListResponse getAllDiscoveryServices(String serverName, String userId, int startingFrom, int maximumResults) {
        String methodName = "getAllDiscoveryServices";
        log.debug("Calling method: getAllDiscoveryServices");
        DiscoveryServiceListResponse response = new DiscoveryServiceListResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getAllDiscoveryServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getAllDiscoveryServices");
            response.setDiscoveryServices(handler.getAllDiscoveryServices(userId, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getAllDiscoveryServices", auditLog);
        }
        log.debug("Returning from method: getAllDiscoveryServices with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getDiscoveryServiceRegistrations(String serverName, String userId, String discoveryServiceGUID) {
        String methodName = "getDiscoveryServiceRegistrations";
        log.debug("Calling method: getDiscoveryServiceRegistrations");
        GUIDListResponse response = new GUIDListResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getDiscoveryServiceRegistrations");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getDiscoveryServiceRegistrations");
            response.setGUIDs(handler.getDiscoveryServiceRegistrations(userId, discoveryServiceGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getDiscoveryServiceRegistrations", auditLog);
        }
        log.debug("Returning from method: getDiscoveryServiceRegistrations with response: " + response.toString());
        return response;
    }

    public VoidResponse updateDiscoveryService(String serverName, String userId, String guid, UpdateDiscoveryServiceRequestBody requestBody) {
        String methodName = "updateDiscoveryService";
        log.debug("Calling method: updateDiscoveryService");
        String qualifiedName = null;
        String displayName = null;
        String shortDescription = null;
        String description = null;
        String owner = null;
        OwnerType ownerType = null;
        List zoneMembership = null;
        String latestChange = null;
        Connection connection = null;
        Map additionalProperties = null;
        Map extendedProperties = null;
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
            displayName = requestBody.getDisplayName();
            shortDescription = requestBody.getShortDescription();
            description = requestBody.getDescription();
            owner = requestBody.getOwner();
            ownerType = requestBody.getOwnerType();
            zoneMembership = requestBody.getZoneMembership();
            latestChange = requestBody.getLatestChange();
            connection = requestBody.getConnection();
            additionalProperties = requestBody.getAdditionalProperties();
            extendedProperties = requestBody.getExtendedProperties();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "updateDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "updateDiscoveryService");
            handler.updateDiscoveryService(userId, guid, qualifiedName, displayName, shortDescription, description, owner, ownerType, zoneMembership, latestChange, connection, additionalProperties, extendedProperties);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "updateDiscoveryService", auditLog);
        }
        log.debug("Returning from method: updateDiscoveryService with response: " + response.toString());
        return response;
    }

    public VoidResponse deleteDiscoveryService(String serverName, String userId, String guid, DeleteRequestBody requestBody) {
        String methodName = "deleteDiscoveryService";
        log.debug("Calling method: deleteDiscoveryService");
        String qualifiedName = null;
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        if (requestBody != null) {
            qualifiedName = requestBody.getQualifiedName();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "deleteDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "deleteDiscoveryService");
            handler.deleteDiscoveryService(userId, guid, qualifiedName);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "deleteDiscoveryService", auditLog);
        }
        log.debug("Returning from method: deleteDiscoveryService with response: " + response.toString());
        return response;
    }

    public VoidResponse registerDiscoveryServiceWithEngine(String serverName, String userId, String discoveryEngineGUID, DiscoveryServiceRegistrationRequestBody requestBody) {
        String methodName = "registerDiscoveryServiceWithEngine";
        log.debug("Calling method: registerDiscoveryServiceWithEngine");
        String discoveryServiceGUID = null;
        List assetDiscoveryTypes = null;
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        if (requestBody != null) {
            discoveryServiceGUID = requestBody.getDiscoveryServiceGUID();
            assetDiscoveryTypes = requestBody.getAssetDiscoveryTypes();
        }
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "registerDiscoveryServiceWithEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "registerDiscoveryServiceWithEngine");
            handler.registerDiscoveryServiceWithEngine(userId, discoveryEngineGUID, discoveryServiceGUID, assetDiscoveryTypes);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "registerDiscoveryServiceWithEngine", auditLog);
        }
        log.debug("Returning from method: registerDiscoveryServiceWithEngine with response: " + response.toString());
        return response;
    }

    public RegisteredDiscoveryServiceResponse getRegisteredDiscoveryService(String serverName, String userId, String discoveryEngineGUID, String discoveryServiceGUID) {
        String methodName = "getRegisteredDiscoveryService";
        log.debug("Calling method: getRegisteredDiscoveryService");
        RegisteredDiscoveryServiceResponse response = new RegisteredDiscoveryServiceResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getRegisteredDiscoveryService");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredDiscoveryService");
            response.setRegisteredDiscoveryService(handler.getRegisteredDiscoveryService(userId, discoveryEngineGUID, discoveryServiceGUID));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getRegisteredDiscoveryService", auditLog);
        }
        log.debug("Returning from method: getRegisteredDiscoveryService with response: " + response.toString());
        return response;
    }

    public GUIDListResponse getRegisteredDiscoveryServices(String serverName, String userId, String discoveryEngineGUID, int startingFrom, int maximumResults) {
        String methodName = "getRegisteredDiscoveryServices";
        log.debug("Calling method: getRegisteredDiscoveryServices");
        GUIDListResponse response = new GUIDListResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "getRegisteredDiscoveryServices");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getRegisteredDiscoveryServices");
            response.setGUIDs(handler.getRegisteredDiscoveryServices(userId, discoveryEngineGUID, startingFrom, maximumResults));
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "getRegisteredDiscoveryServices", auditLog);
        }
        log.debug("Returning from method: getRegisteredDiscoveryServices with response: " + response.toString());
        return response;
    }

    public VoidResponse unregisterDiscoveryServiceFromEngine(String serverName, String userId, String discoveryEngineGUID, String discoveryServiceGUID, NullRequestBody requestBody) {
        String methodName = "unregisterDiscoveryServiceFromEngine";
        log.debug("Calling method: unregisterDiscoveryServiceFromEngine");
        VoidResponse response = new VoidResponse();
        OMRSAuditLog auditLog = null;
        try {
            DiscoveryConfigurationHandler handler = instanceHandler.getDiscoveryConfigurationHandler(userId, serverName, "unregisterDiscoveryServiceFromEngine");
            auditLog = instanceHandler.getAuditLog(userId, serverName, "unregisterDiscoveryServiceFromEngine");
            handler.unregisterDiscoveryServiceFromEngine(userId, discoveryEngineGUID, discoveryServiceGUID);
        }
        catch (InvalidParameterException error) {
            this.restExceptionHandler.captureInvalidParameterException((FFDCResponseBase)response, error);
        }
        catch (PropertyServerException error) {
            this.restExceptionHandler.capturePropertyServerException((FFDCResponseBase)response, error);
        }
        catch (UserNotAuthorizedException error) {
            this.restExceptionHandler.captureUserNotAuthorizedException((FFDCResponseBase)response, error);
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponseBase)response, error, "unregisterDiscoveryServiceFromEngine", auditLog);
        }
        log.debug("Returning from method: unregisterDiscoveryServiceFromEngine with response: " + response.toString());
        return response;
    }
}

